/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.dual.heat;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerDoubleElectricMachine;
import com.denfop.gui.GuiAlloySmelter;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.recipe.IInputHandler;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tiles.base.EnumDoubleElectricMachine;
import com.denfop.tiles.base.TileDoubleElectricMachine;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileAlloySmelter
extends TileDoubleElectricMachine
implements IHasRecipe {
    public final InvSlot input_slot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public TileAlloySmelter(BlockPos pos, BlockState state) {
        super(1, 300, 1, EnumDoubleElectricMachine.ALLOY_SMELTER, BlockBaseMachine.alloy_smelter, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.input_slot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).m_41619_()) {
                    ((TileAlloySmelter)this.base).inputSlotA.changeAccepts(ItemStack.f_41583_);
                } else {
                    ((TileAlloySmelter)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean accepts(ItemStack stack, int index) {
                return stack.m_41720_() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.f_58857_.m_46467_() % 5L == 0L) {
            ParticleUtils.spawnAlloySmelterParticles(this.f_58857_, this.pos, this.f_58857_.f_46441_);
        }
    }

    public static void addAlloysmelter(IInputItemStack container, IInputItemStack fill, ItemStack output, int temperature) {
        CompoundTag nbt = ModUtils.nbt();
        nbt.m_128376_("temperature", (short)temperature);
        Recipes.recipes.addRecipe("alloysmelter", new BaseMachineRecipe(new Input(container, fill), new RecipeOutput(nbt, output)));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            if (this.input_slot.isEmpty()) {
                this.inputSlotA.changeAccepts(ItemStack.f_41583_);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine.alloy_smelter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.f_42416_), 1), input.getInput(new ItemStack((ItemLike)Items.f_42413_), 2), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(502), 1), 4000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:gems/bor", 1), input.getInput(new ItemStack((ItemLike)Items.f_42686_), 1), new ItemStack((ItemLike)IUItem.nether_star_ingot.getItem()), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/tungsten", 2), input.getInput("forge:ingots/nickel", 1), new ItemStack((ItemLike)IUItem.wolframite.getItem()), 3000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(13), 1)), input.getInput(new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(3), 2)), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(480), 2), 4000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(64), 1)), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(28), 1)), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(73), 1), 1000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(28), 2)), input.getInput(new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(32), 1)), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(31), 1), 4000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(1), 2)), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(31), 3)), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(59), 1), 4000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.f_42417_), 1), input.getInput("forge:ingots/silver", 1), new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(13), 1), 3500);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(481), 1)), input.getInput("forge:dusts/coal", 2), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(482), 1), 1000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/nickel", 1), input.getInput(new ItemStack((ItemLike)Items.f_42416_), 2), input.getInput("forge:ingots/Invar", 4).getInputs().get(0), 5000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(37), 1)), input.getInput("forge:dusts/iron", 2), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(38), 1), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(71), 1)), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(60), 1)), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(33), 1), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.f_42413_), 1), input.getInput(new ItemStack((ItemLike)Items.f_42692_), 4), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(319), 1), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:storage_blocks/silver", 1), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(484), 1), 1), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(434), 1), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/copper", 1), input.getInput("forge:ingots/zinc", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(2), 1), 3000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/nickel", 1), input.getInput("forge:ingots/chromium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(4), 1), 4000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/nickel", 1), input.getInput("forge:ingots/titanium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(15), 1), 4000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/tin", 1), input.getInput("forge:ingots/copper", 3), ModUtils.setSize(IUItem.bronzeIngot, 4), 1000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/aluminium", 1), input.getInput("forge:ingots/magnesium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(8), 1), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/aluminium", 1), input.getInput("forge:ingots/titanium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(1), 1), 5000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/aluminium", 1), input.getInput("forge:ingots/lithium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(22), 1), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/chromium", 1), input.getInput("forge:ingots/cobalt", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(23), 1), 2000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/niobium", 2), input.getInput("forge:ingots/titanium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(26), 1), 3000);
        TileAlloySmelter.addAlloysmelter(input.getInput("forge:ingots/osmium", 2), input.getInput("forge:ingots/iridium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(27), 1), 3000);
        TileAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.f_42416_), 1), input.getInput("forge:ingots/manganese", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(9), 1), 4500);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player entityPlayer, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiAlloySmelter((ContainerDoubleElectricMachine)menu);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.alloysmelter.getSoundEvent();
    }
}

