/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.multimechanism.photonic;

import com.denfop.IUItem;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlocksPhotonicMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.EnumMultiMachine;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.tiles.mechanism.multimechanism.IFarmer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class TilePhotonicFermer
extends TileMultiMachine
implements IFarmer {
    private final InvSlot fertilizerSlot = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, 1){

        @Override
        public boolean accepts(ItemStack stack, int index) {
            return stack.m_41720_() == IUItem.fertilizer.getItem();
        }

        @Override
        public EnumTypeSlot getTypeSlot() {
            return EnumTypeSlot.FERTILIZER;
        }
    };
    int col = 0;

    public TilePhotonicFermer(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.PHO_Fermer, BlocksPhotonicMachine.photonic_fermer, pos, state);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.cold.storage = 0.0;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.col = customPacketBuffer.readInt();
    }

    @Override
    public int getFertilizer() {
        return this.col;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        packetBuffer.writeInt(this.col);
        return packetBuffer;
    }

    @Override
    public InvSlot getFertilizerSlot() {
        return this.fertilizerSlot;
    }

    @Override
    public int getSize(int size) {
        size = Math.min(super.getSize(size), this.fertilizerSlot.get(0).m_41613_() * 8 + this.col);
        return size;
    }

    @Override
    public boolean canoperate(int size) {
        return !this.fertilizerSlot.isEmpty() && this.fertilizerSlot.get(0).m_41613_() * 8 + this.col >= size;
    }

    @Override
    public void consume(int size) {
        int size1 = size;
        while (size1 > 0) {
            if (this.col == 0) {
                this.col += 16;
                this.fertilizerSlot.get(0).m_41774_(1);
            }
            if (size1 <= this.col) {
                this.col -= size1;
                size1 = 0;
                continue;
            }
            size1 -= this.col;
            this.col = 0;
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlocksPhotonicMachine.photonic_fermer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.pho_machine.getBlock(this.getTeBlock().getId());
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.PHO_Fermer;
    }
}

