/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerSteamBoiler;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiSteamBoiler;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileElectricMachine;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntitySteamBoiler
extends TileElectricMachine
implements IUpdatableTileEvent {
    public final Fluids.InternalFluidTank fluidTank1;
    private final ComponentSteamEnergy steam;
    public FluidTank fluidTank;
    public Fluids fluids = this.addComponent(new Fluids(this));
    public boolean work = true;

    public TileEntitySteamBoiler(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockBaseMachine3.steamboiler, pos, state);
        this.fluidTank = this.fluids.addTank("fluidTank", 4000, InvSlot.TypeItemSlot.INPUT, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.f_76193_}));
        this.fluidTank1 = this.fluids.addTank("fluidTank1", 4000, InvSlot.TypeItemSlot.NONE, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSource(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank1);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.steam_info"));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.work) {
            if (this.pos.m_7495_().m_123331_((Vec3i)neighborPos) == 0.0) {
                FluidState blockState = this.f_58857_.m_6425_(this.pos.m_7495_());
                this.work = blockState.m_76152_() != net.minecraft.world.level.material.Fluids.f_76191_ ? blockState.m_76152_().m_6212_(Fluids.LAVA) : false;
            }
        } else if (this.pos.m_7495_().m_123331_((Vec3i)neighborPos) == 0.0) {
            FluidState blockState = this.f_58857_.m_6425_(this.pos.m_7495_());
            this.work = blockState.m_76152_() != net.minecraft.world.level.material.Fluids.f_76191_ ? blockState.m_76152_().m_6212_(Fluids.LAVA) : false;
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            FluidTank fluidTank2;
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
            if ((fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer)) != null) {
                this.fluidTank1.readFromNBT(fluidTank2.writeToNBT(new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockBaseMachine3.steamboiler;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
            EncoderHandler.encode(packet, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            FluidState blockState = this.f_58857_.m_6425_(this.pos.m_7495_());
            this.work = blockState.m_76152_() != net.minecraft.world.level.material.Fluids.f_76191_ ? blockState.m_76152_().m_6212_(Fluids.LAVA) : false;
        }
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            if (this.getWorld().m_46467_() % 3L == 0L) {
                if (!this.fluidTank.getFluid().isEmpty() && this.fluidTank.getFluid().getAmount() >= 2 && this.steam.getEnergy() + 2.0 <= this.steam.getCapacity()) {
                    this.steam.addEnergy(2.0);
                    this.fluidTank.drain(2, IFluidHandler.FluidAction.EXECUTE);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            }
        } else {
            this.setActive(false);
        }
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerSteamBoiler getGuiContainer(Player entityPlayer) {
        return new ContainerSteamBoiler(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiSteamBoiler((ContainerSteamBoiler)menu);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

