/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.reactors.water.controller;

import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.multiblock.IMultiElement;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.api.radiationsystem.RadiationSystem;
import com.denfop.api.reactors.EnumTypeSecurity;
import com.denfop.api.reactors.EnumTypeWork;
import com.denfop.api.reactors.IFluidReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.ITypeRector;
import com.denfop.api.reactors.InvSlotReactorModules;
import com.denfop.api.reactors.LogicFluidReactor;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerLevelFuel;
import com.denfop.container.ContainerWaterMainController;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiLevelFuel;
import com.denfop.gui.GuiWaterMainController;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotScheduleReactor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketExplosion;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.reactors.water.IInput;
import com.denfop.tiles.reactors.water.ILevelFuel;
import com.denfop.tiles.reactors.water.IOutput;
import com.denfop.tiles.reactors.water.ISecurity;
import com.denfop.tiles.reactors.water.ISocket;
import com.denfop.tiles.reactors.water.ITank;
import com.denfop.tiles.reactors.water.controller.EnumFluidReactors;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityMainController
extends TileMultiBlockBase
implements IFluidReactor,
IUpdatableTileEvent {
    public final EnumFluidReactors enumFluidReactors;
    public final InvSlot reactorsElements;
    public final InvSlotReactorModules<TileEntityMainController> reactorsModules;
    public final InvSlotScheduleReactor scheduleReactor;
    private final ComponentBaseEnergy rad;
    public Timer timer = new Timer(9999, 0, 0);
    public Timer red_timer = new Timer(0, 2, 30);
    public Timer yellow_timer = new Timer(0, 15, 0);
    public Energy energy;
    public EnumTypeWork typeWork = EnumTypeWork.WORK;
    public int pressure = 1;
    public boolean work = false;
    public double heat;
    public double output = 0.0;
    public LogicFluidReactor reactor;
    public EnumTypeSecurity security = EnumTypeSecurity.NONE;
    public int blockLevel = 0;
    public boolean heat_sensor;
    public boolean stable_sensor;
    List<Fluids.InternalFluidTank> fluidTankInputList = new ArrayList<Fluids.InternalFluidTank>();
    List<Fluids.InternalFluidTank> fluidTankOutputList = new ArrayList<Fluids.InternalFluidTank>();
    List<Fluids.InternalFluidTank> fluidTankCoolantList = new ArrayList<Fluids.InternalFluidTank>();
    List<Fluids.InternalFluidTank> fluidTankHotCoolantList = new ArrayList<Fluids.InternalFluidTank>();
    List<ISecurity> securities = new ArrayList<ISecurity>();

    public TileEntityMainController(MultiBlockStructure multiBlockStructure, EnumFluidReactors enumFluidReactors, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(multiBlockStructure, block, pos, state);
        this.enumFluidReactors = enumFluidReactors;
        this.reactorsElements = new InvSlot(this, InvSlot.TypeItemSlot.INPUT, enumFluidReactors.getHeight() * enumFluidReactors.getWidth()){

            @Override
            public boolean accepts(ItemStack stack, int index) {
                if (TileEntityMainController.this.scheduleReactor.getAccepts().isEmpty()) {
                    if (stack.m_41720_() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.m_41720_();
                        return ((TileEntityMainController)this.base).getLevelReactor() >= iReactorItem.getLevel();
                    }
                    return false;
                }
                ItemStack stack1 = TileEntityMainController.this.scheduleReactor.getAccepts().get(index);
                if (stack1.m_41619_()) {
                    return false;
                }
                return stack1.m_150930_(stack.m_41720_());
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                TileEntityMainController.this.reactor = null;
                return content;
            }
        };
        this.reactorsElements.setStackSizeLimit(1);
        this.reactorsModules = new InvSlotReactorModules<TileEntityMainController>(this);
        this.scheduleReactor = new InvSlotScheduleReactor(this, 1, enumFluidReactors.ordinal() + 1, enumFluidReactors.getWidth(), enumFluidReactors.getHeight());
        this.rad = this.addComponent(new ComponentBaseEnergy(EnergyType.RADIATION, this, enumFluidReactors.getRadiation() * 100.0));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.reactor_safety_doom.info"));
    }

    public LogicReactor getReactor() {
        if (this.reactor == null) {
            this.reactor = new LogicFluidReactor(this);
        }
        return this.reactor;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("pressure")) {
            try {
                this.pressure = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("reactor")) {
            if (this.reactor == null) {
                this.reactor = new LogicFluidReactor(this);
            }
            try {
                this.reactor.setGeneration((Integer)DecoderHandler.decode(is));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ContainerWaterMainController getGuiContainer(Player entityPlayer) {
        return new ContainerWaterMainController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        if (menu instanceof ContainerLevelFuel) {
            return new GuiLevelFuel((ContainerLevelFuel)menu);
        }
        return new GuiWaterMainController((ContainerWaterMainController)menu);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            BlockEntity tile;
            this.fluidTankInputList.clear();
            this.fluidTankOutputList.clear();
            this.fluidTankCoolantList.clear();
            this.fluidTankHotCoolantList.clear();
            List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IInput.class);
            for (BlockPos pos : pos1) {
                BlockEntity tile2 = this.getWorld().m_7702_(pos);
                if (!(tile2 instanceof IInput)) continue;
                ((IInput)tile2).clearList();
            }
            List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IOutput.class);
            for (BlockPos pos : pos2) {
                tile = this.getWorld().m_7702_(pos);
                if (!(tile instanceof IOutput)) continue;
                ((IOutput)tile).clearList();
            }
            pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ILevelFuel.class);
            for (BlockPos pos3 : pos2) {
                tile = this.getWorld().m_7702_(pos3);
                if (!(tile instanceof ILevelFuel)) continue;
                ((ILevelFuel)tile).setMainMultiElement(null);
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0 && this.blockLevel > 0) {
            this.setWork(!this.work);
        }
        if (var2 == 1.0) {
            ++this.pressure;
            this.pressure = Math.min(5, this.pressure);
        } else if (var2 == 2.0) {
            --this.pressure;
            this.pressure = Math.max(1, this.pressure);
        } else if (var2 == -1.0) {
            if (!this.stable_sensor) {
                this.heat_sensor = !this.heat_sensor;
            }
        } else if (var2 == -2.0) {
            if (!this.heat_sensor) {
                this.stable_sensor = !this.stable_sensor;
            }
        } else if (this.typeWork == EnumTypeWork.WORK && this.getLevelReactor() < this.getMaxLevelReactor()) {
            this.typeWork = EnumTypeWork.LEVEL_INCREASE;
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            switch (this.blockLevel) {
                case 0: {
                    this.energy.setCapacity(4000000.0);
                    break;
                }
                case 1: {
                    this.energy.setCapacity(5.0E7);
                    break;
                }
                case 2: {
                    this.energy.setCapacity(2.0E8);
                    break;
                }
                case 3: {
                    this.energy.setCapacity(5.0E8);
                }
            }
        } else if (this.typeWork == EnumTypeWork.LEVEL_INCREASE && this.getLevelReactor() < this.getMaxLevelReactor()) {
            this.typeWork = EnumTypeWork.WORK;
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.noFacings, ModUtils.allFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            this.energy.setCapacity(this.energy.defaultCapacity);
            this.energy.buffer.storage = 0.0;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.scheduleReactor.update();
            this.reactorsModules.load();
            try {
                if (this.typeWork == EnumTypeWork.LEVEL_INCREASE) {
                    this.energy.onUnloaded();
                    this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
                    this.energy.delegate = null;
                    this.energy.createDelegate();
                    this.energy.onLoaded();
                    switch (this.blockLevel) {
                        case 0: {
                            this.energy.setCapacity(4000000.0);
                            break;
                        }
                        case 1: {
                            this.energy.setCapacity(5.0E7);
                            break;
                        }
                        case 2: {
                            this.energy.setCapacity(2.0E8);
                            break;
                        }
                        case 3: {
                            this.energy.setCapacity(5.0E8);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ChunkPos chunkPos = this.getWorld().m_46745_(this.pos).m_7697_();
            List list = RadiationSystem.rad_system.getAdvReactorMap().computeIfAbsent(chunkPos, k -> new ArrayList());
            list.add(this);
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.getWorld().f_46443_) {
            ChunkPos chunkPos = this.getWorld().m_46745_(this.pos).m_7697_();
            List list = RadiationSystem.rad_system.getAdvReactorMap().computeIfAbsent(chunkPos, k -> new ArrayList());
            list.remove(this);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.reactor == null) {
            this.reactor = new LogicFluidReactor(this);
            this.reactor.temp_heat = this.heat;
            new PacketUpdateFieldTile(this, "reactor", this.reactor.getGeneration());
        } else if (this.full) {
            if (this.typeWork == EnumTypeWork.WORK) {
                this.energy.buffer.capacity = Math.max(this.output, this.energy.getDefaultCapacity());
                if (this.work) {
                    if (this.getWorld().m_46467_() % 20L == 0L) {
                        this.reactor.onTick();
                        if (this.rad.getEnergy() >= this.rad.getCapacity() * 0.5 && this.rad.getEnergy() < this.rad.getCapacity() * 0.75) {
                            this.setSecurity(EnumTypeSecurity.UNSTABLE);
                        }
                        this.workTimer();
                        if (!this.timer.canWork()) {
                            this.explode();
                            this.reactor = null;
                        } else if (!this.yellow_timer.canWork()) {
                            this.explode();
                            this.reactor = null;
                        } else if (!this.red_timer.canWork()) {
                            this.explode();
                            this.reactor = null;
                        } else if (this.reactor != null && this.getHeat() >= (double)this.getMaxHeat() && this.reactor.getMaxHeat() >= (double)this.getMaxHeat() * 1.5) {
                            this.explode();
                            this.reactor = null;
                        }
                    }
                    if (this.work && this.reactor != null) {
                        this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.output));
                        this.energy.addEnergy(this.output);
                    }
                }
            } else if (this.energy.getEnergy() >= this.energy.getCapacity()) {
                ++this.blockLevel;
                this.typeWork = EnumTypeWork.WORK;
                this.energy.onUnloaded();
                this.energy.setCapacity(this.energy.defaultCapacity);
                this.energy.setDirections(ModUtils.noFacings, ModUtils.allFacings);
                this.energy.delegate = null;
                this.energy.createDelegate();
                this.energy.onLoaded();
                this.energy.buffer.storage = 0.0;
            }
        }
    }

    public Timer getYellow_timer() {
        return this.yellow_timer;
    }

    public Timer getRed_timer() {
        return this.red_timer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        FluidTank fluidTank1;
        super.readContainerPacket(customPacketBuffer);
        this.pressure = customPacketBuffer.readInt();
        this.work = customPacketBuffer.readBoolean();
        this.stable_sensor = customPacketBuffer.readBoolean();
        this.heat_sensor = customPacketBuffer.readBoolean();
        boolean socket = customPacketBuffer.readBoolean();
        if (socket) {
            try {
                this.energy.onNetworkUpdate(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.security = EnumTypeSecurity.values()[customPacketBuffer.readInt()];
        this.heat = customPacketBuffer.readDouble();
        this.output = customPacketBuffer.readDouble();
        try {
            this.timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.blockLevel = customPacketBuffer.readInt();
        this.typeWork = EnumTypeWork.values()[customPacketBuffer.readInt()];
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankCoolantList) {
            try {
                fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
                if (fluidTank1 == null) continue;
                fluidTank.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankInputList) {
            try {
                fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
                if (fluidTank1 == null) continue;
                fluidTank.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankOutputList) {
            try {
                fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
                if (fluidTank1 == null) continue;
                fluidTank.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankHotCoolantList) {
            try {
                fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
                if (fluidTank1 == null) continue;
                fluidTank.readFromNBT(fluidTank1.writeToNBT(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.red_timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.yellow_timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.pressure);
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBoolean(this.stable_sensor);
        customPacketBuffer.writeBoolean(this.heat_sensor);
        customPacketBuffer.writeBoolean(this.energy != null);
        if (this.energy != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.energy, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        customPacketBuffer.writeInt(this.security.ordinal());
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeDouble(this.output);
        this.timer.writeBuffer(customPacketBuffer);
        customPacketBuffer.writeInt(this.blockLevel);
        customPacketBuffer.writeInt(this.typeWork.ordinal());
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankCoolantList) {
            try {
                EncoderHandler.encode(customPacketBuffer, (Object)fluidTank);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankInputList) {
            try {
                EncoderHandler.encode(customPacketBuffer, (Object)fluidTank);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankOutputList) {
            try {
                EncoderHandler.encode(customPacketBuffer, (Object)fluidTank);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (Fluids.InternalFluidTank fluidTank : this.fluidTankHotCoolantList) {
            try {
                EncoderHandler.encode(customPacketBuffer, (Object)fluidTank);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.red_timer.writeBuffer(customPacketBuffer);
        this.yellow_timer.writeBuffer(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.m_128471_("work");
        this.pressure = nbttagcompound.m_128451_("pressure");
        this.blockLevel = nbttagcompound.m_128451_("level");
        this.timer.readNBT(nbttagcompound);
        this.red_timer.readNBT(nbttagcompound.m_128469_("red"));
        this.yellow_timer.readNBT(nbttagcompound.m_128469_("yellow"));
        this.heat = nbttagcompound.m_128459_("heat");
        this.typeWork = EnumTypeWork.values()[nbttagcompound.m_128451_("typeWork")];
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        CompoundTag nbt = super.writeToNBT(nbttagcompound);
        nbt.m_128379_("work", this.work);
        nbt.m_128405_("pressure", this.pressure);
        nbt.m_128405_("level", this.blockLevel);
        this.timer.writeNBT(nbt);
        CompoundTag nbt1 = new CompoundTag();
        this.red_timer.writeNBT(nbt1);
        nbt.m_128365_("red", (Tag)nbt1);
        CompoundTag nbt2 = new CompoundTag();
        this.yellow_timer.writeNBT(nbt2);
        nbt.m_128365_("yellow", (Tag)nbt2);
        nbt.m_128347_("heat", this.heat);
        nbt.m_128405_("typeWork", this.typeWork.ordinal());
        return nbt;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        return super.writePacket();
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
        try {
            this.red_timer.readBuffer(packetBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.yellow_timer.readBuffer(packetBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer customPacketBuffer = super.writeUpdatePacket();
        this.red_timer.writeBuffer(customPacketBuffer);
        this.yellow_timer.writeBuffer(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public void updateAfterAssembly() {
        IMultiElement output;
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ITank.class);
        ArrayList<Fluids> inputs = new ArrayList<Fluids>();
        ArrayList<Fluids> outputs = new ArrayList<Fluids>();
        block12: for (int i = 0; i < pos1.size(); ++i) {
            int k = i % 4;
            ITank tank = (ITank)this.getWorld().m_7702_(pos1.get(i));
            switch (k) {
                case 0: {
                    this.fluidTankInputList.add(tank.getTank());
                    tank.setFluid((Fluid)net.minecraft.world.level.material.Fluids.f_76193_);
                    if (!tank.getTank().getFluid().isEmpty() && !tank.getTank().getFluid().getFluid().equals(net.minecraft.world.level.material.Fluids.f_76193_)) {
                        tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    inputs.add(tank.getFluids());
                    continue block12;
                }
                case 1: {
                    this.fluidTankOutputList.add(tank.getTank());
                    tank.setFluid((Fluid)FluidName.fluidsteam.getInstance().get());
                    if (!tank.getTank().getFluid().isEmpty() && !tank.getTank().getFluid().getFluid().equals(FluidName.fluidsteam.getInstance().get())) {
                        tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    outputs.add(tank.getFluids());
                    continue block12;
                }
                case 2: {
                    this.fluidTankCoolantList.add(tank.getTank());
                    tank.setFluid((Fluid)FluidName.fluidcoolant.getInstance().get());
                    if (!tank.getTank().getFluid().isEmpty() && !tank.getTank().getFluid().getFluid().equals(FluidName.fluidcoolant.getInstance().get())) {
                        tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    inputs.add(tank.getFluids());
                    continue block12;
                }
                case 3: {
                    this.fluidTankHotCoolantList.add(tank.getTank());
                    tank.setFluid((Fluid)FluidName.fluidhot_coolant.getInstance().get());
                    if (!tank.getTank().getFluid().isEmpty() && !tank.getTank().getFluid().getFluid().equals(FluidName.fluidhot_coolant.getInstance().get())) {
                        tank.getTank().drain(tank.getTank().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    outputs.add(tank.getFluids());
                }
            }
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IInput.class);
        for (BlockPos pos2 : pos1) {
            IInput input = (IInput)this.getWorld().m_7702_(pos2);
            inputs.forEach(input1 -> input.addFluids((Fluids)input1));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IOutput.class);
        for (BlockPos pos2 : pos1) {
            output = (IOutput)this.getWorld().m_7702_(pos2);
            outputs.forEach(arg_0 -> TileEntityMainController.lambda$updateAfterAssembly$3((IOutput)output, arg_0));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ISocket.class);
        for (BlockPos pos2 : pos1) {
            output = (ISocket)this.getWorld().m_7702_(pos2);
            this.energy = output.getEnergy();
        }
        if (!this.getWorld().f_46443_) {
            this.reactor = new LogicFluidReactor(this);
            this.reactor.temp_heat = this.heat;
            new PacketUpdateFieldTile(this, "reactor", this.reactor.getGeneration());
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ISecurity.class);
        for (BlockPos pos2 : pos1) {
            ISecurity security = (ISecurity)this.getWorld().m_7702_(pos2);
            this.securities.add(security);
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ILevelFuel.class);
        for (BlockPos pos2 : pos1) {
            ILevelFuel levelFuel = (ILevelFuel)this.getWorld().m_7702_(pos2);
            levelFuel.setMainMultiElement(this);
        }
        if (!this.getWorld().f_46443_) {
            this.reactorsModules.load();
        }
        if (this.isFull() && this.typeWork == EnumTypeWork.LEVEL_INCREASE) {
            this.energy.onUnloaded();
            this.energy.setDirections(ModUtils.allFacings, ModUtils.noFacings);
            this.energy.delegate = null;
            this.energy.createDelegate();
            this.energy.onLoaded();
            switch (this.blockLevel) {
                case 0: {
                    this.energy.setCapacity(4000000.0);
                    break;
                }
                case 1: {
                    this.energy.setCapacity(5.0E7);
                    break;
                }
                case 2: {
                    this.energy.setCapacity(2.0E8);
                    break;
                }
                case 3: {
                    this.energy.setCapacity(5.0E8);
                }
            }
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public boolean isWork() {
        return this.work;
    }

    @Override
    public void setWork(boolean work) {
        this.work = work;
        if (this.work) {
            this.setSecurity(EnumTypeSecurity.STABLE);
        } else {
            this.setSecurity(EnumTypeSecurity.NONE);
        }
    }

    @Override
    public double getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(double var1) {
        this.heat = var1;
        if (this.heat > (double)this.getMaxHeat()) {
            this.heat = this.getMaxHeat();
        }
        if (this.heat < (double)this.getStableMaxHeat()) {
            this.setSecurity(EnumTypeSecurity.STABLE);
            this.setTime(EnumTypeSecurity.STABLE);
        } else if (this.heat >= (double)this.getStableMaxHeat() && this.heat <= (double)this.getStableMaxHeat() + (double)(this.getMaxHeat() - this.getStableMaxHeat()) * 0.75) {
            this.setSecurity(EnumTypeSecurity.UNSTABLE);
            this.setTime(EnumTypeSecurity.UNSTABLE);
        } else {
            this.setSecurity(EnumTypeSecurity.ERROR);
            this.setTime(EnumTypeSecurity.ERROR);
        }
    }

    @Override
    public void setUpdate() {
        this.reactor = null;
    }

    @Override
    public int getBlockLevel() {
        return this.enumFluidReactors.ordinal();
    }

    @Override
    public int getMaxHeat() {
        return (int)((double)this.enumFluidReactors.getMaxHeat() * this.reactorsModules.getStableHeat());
    }

    @Override
    public int getStableMaxHeat() {
        return (int)((double)this.enumFluidReactors.getMaxStable() * this.reactorsModules.getStableHeat());
    }

    @Override
    public double getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(double output) {
        this.output = output * this.reactorsModules.getGeneration();
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.reactorsElements.get(y * this.getWidth() + x);
    }

    @Override
    public void setItemAt(int x, int y) {
        this.reactorsElements.set(y * this.getWidth() + x, ItemStack.f_41583_);
    }

    @Override
    public void explode() {
        int weight = this.getMultiBlockStucture().maxWeight + this.getMultiBlockStucture().minWeight;
        int height = this.getMultiBlockStucture().maxHeight + this.getMultiBlockStucture().minHeight;
        int length = this.getMultiBlockStucture().maxLength + this.getMultiBlockStucture().maxLength;
        ArrayList<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
        ChunkPos chunkPos = this.getWorld().m_46745_(this.pos).m_7697_();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                chunkPosList.add(new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z));
            }
        }
        double rad = this.rad.getEnergy() / 9.0;
        this.setFull(false);
        this.activate = false;
        Explosion explosion = new Explosion(this.f_58857_, null, (double)(this.getPos().m_123341_() + weight), (double)(this.getPos().m_123342_() + height), (double)(this.getPos().m_123343_() + length), 25.0f, false, Explosion.BlockInteraction.NONE);
        this.f_58857_.m_7731_(this.pos, Blocks.f_50016_.m_49966_(), 11);
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.getMultiBlockStucture().blockPosMap.entrySet()) {
            if (this.f_58857_.f_46441_.m_188503_(2) == 0) continue;
            this.f_58857_.m_7731_(switch (Direction.values()[this.facing]) {
                case Direction.NORTH -> this.pos.m_121955_((Vec3i)entry.getKey());
                case Direction.EAST -> this.pos.m_7918_(entry.getKey().m_123343_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123341_());
                case Direction.WEST -> this.pos.m_7918_(entry.getKey().m_123343_(), entry.getKey().m_123342_(), entry.getKey().m_123341_() * -1);
                case Direction.SOUTH -> this.pos.m_7918_(entry.getKey().m_123341_() * -1, entry.getKey().m_123342_(), entry.getKey().m_123343_() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + this.facing);
            }, Blocks.f_50016_.m_49966_(), 11);
        }
        if (this.f_58857_.m_46472_() == Level.f_46428_) {
            for (ChunkPos pos1 : chunkPosList) {
                if (!pos1.equals((Object)chunkPos)) {
                    new PacketUpdateRadiationValue(pos1, (int)(rad * 10.0));
                    continue;
                }
                new PacketUpdateRadiationValue(pos1, (int)(rad * 50.0));
            }
        }
        new PacketExplosion(explosion, 25, false, false);
    }

    public List<Fluids.InternalFluidTank> getFluidTankCoolantList() {
        return this.fluidTankCoolantList;
    }

    public EnumTypeWork getTypeWork() {
        return this.typeWork;
    }

    public List<Fluids.InternalFluidTank> getFluidTankHotCoolantList() {
        return this.fluidTankHotCoolantList;
    }

    public List<Fluids.InternalFluidTank> getFluidTankInputList() {
        return this.fluidTankInputList;
    }

    public List<Fluids.InternalFluidTank> getFluidTankOutputList() {
        return this.fluidTankOutputList;
    }

    public ComponentBaseEnergy getRad() {
        return this.rad;
    }

    @Override
    public void setRad(double rad) {
        this.rad.addEnergy(rad * this.reactorsModules.getRadiation());
        if (this.rad.getEnergy() >= this.rad.getCapacity()) {
            this.explode();
        }
    }

    @Override
    public ITypeRector getTypeRector() {
        return ITypeRector.FLUID;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public void setTime(EnumTypeSecurity enumTypeSecurity) {
        if (this.security == enumTypeSecurity) {
            switch (enumTypeSecurity) {
                case STABLE: {
                    this.timer = new Timer(9999, 0, 0);
                    break;
                }
                case ERROR: {
                    this.timer = new Timer(0, 2, 30);
                    break;
                }
                case UNSTABLE: {
                    this.timer = new Timer(0, 15, 0);
                }
            }
        }
    }

    @Override
    public void workTimer() {
        switch (this.security) {
            case UNSTABLE: {
                this.yellow_timer.work();
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case STABLE: {
                this.timer.work();
                if (!this.yellow_timer.getMinute(15)) {
                    this.yellow_timer.rework();
                }
                if (this.red_timer.getMinute(3)) break;
                this.red_timer.rework();
                break;
            }
            case ERROR: {
                this.red_timer.work();
            }
        }
    }

    @Override
    public EnumTypeSecurity getSecurity() {
        return this.security;
    }

    @Override
    public void setSecurity(EnumTypeSecurity enumTypeSecurity) {
        if (this.security != enumTypeSecurity) {
            this.security = enumTypeSecurity;
            new PacketUpdateFieldTile(this, "security", (Object)this.security);
            this.securities.forEach(security -> {
                security.setActive(enumTypeSecurity.name().toLowerCase());
                security.setSecurity(enumTypeSecurity);
            });
        }
    }

    @Override
    public int getWidth() {
        return this.enumFluidReactors.getWidth();
    }

    @Override
    public int getHeight() {
        return this.enumFluidReactors.getHeight();
    }

    @Override
    public int getLevelReactor() {
        return this.blockLevel;
    }

    @Override
    public int getMaxLevelReactor() {
        return this.enumFluidReactors.ordinal() + 1;
    }

    @Override
    public void increaseLevelReactor() {
        ++this.blockLevel;
    }

    @Override
    public ComponentBaseEnergy getRadiation() {
        return this.rad;
    }

    @Override
    public double getModuleStableHeat() {
        return this.reactorsModules.getStableHeat();
    }

    @Override
    public double getModuleRadiation() {
        return this.reactorsModules.getRadiation();
    }

    @Override
    public double getModuleGeneration() {
        return this.reactorsModules.getGeneration();
    }

    @Override
    public double getModuleVent() {
        return this.reactorsModules.getVent();
    }

    @Override
    public double getModuleComponentVent() {
        return this.reactorsModules.getComponentVent();
    }

    @Override
    public double getModuleCapacitor() {
        return this.reactorsModules.getCapacitor();
    }

    @Override
    public double getModuleExchanger() {
        return this.reactorsModules.getExchanger();
    }

    @Override
    public FluidTank getInputTank() {
        for (Fluids.InternalFluidTank tank : this.fluidTankInputList) {
            if (tank.getFluidAmount() < 5 * this.getPressure()) continue;
            return tank;
        }
        return this.fluidTankInputList.get(0);
    }

    @Override
    public FluidTank getCoolantTank() {
        for (Fluids.InternalFluidTank tank : this.fluidTankCoolantList) {
            if (tank.getFluidAmount() < 5) continue;
            return tank;
        }
        return this.fluidTankCoolantList.get(0);
    }

    @Override
    public FluidTank getHotCoolantTank() {
        for (Fluids.InternalFluidTank tank : this.fluidTankHotCoolantList) {
            if (tank.getFluidAmount() < 2) continue;
            return tank;
        }
        return this.fluidTankHotCoolantList.get(0);
    }

    @Override
    public FluidTank getOutputTank() {
        for (Fluids.InternalFluidTank tank : this.fluidTankOutputList) {
            if (tank.getFluidAmount() < 2 * this.getPressure()) continue;
            return tank;
        }
        return this.fluidTankOutputList.get(0);
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public void addPressure(int pressure) {
        this.pressure += pressure;
    }

    @Override
    public void removePressure(int pressure) {
        this.pressure -= pressure;
    }

    private static /* synthetic */ void lambda$updateAfterAssembly$3(IOutput output, Fluids output1) {
        output.addFluids(output1);
    }
}

