/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crafting;

import com.denfop.api.Recipes;
import com.denfop.items.ItemToolCrafting;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.IngredientInput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BaseShapelessRecipe
implements CraftingRecipe {
    final NonNullList<Ingredient> listIngridient;
    private final ItemStack output;
    private final List<IInputItemStack> recipeInputList;
    private final String id;
    private ResourceLocation name;

    public BaseShapelessRecipe(ItemStack output, List<IInputItemStack> recipeInputList) {
        this.output = output;
        this.recipeInputList = recipeInputList;
        this.listIngridient = NonNullList.m_122779_();
        for (IInputItemStack input : this.recipeInputList) {
            this.listIngridient.add((Object)new IngredientInput(input));
        }
        this.id = Recipes.registerRecipe((Recipe)this);
    }

    public List<IInputItemStack> getRecipeInputList() {
        return this.recipeInputList;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack matches(CraftingContainer inv) {
        ArrayList<IInputItemStack> recipeInputList1 = new ArrayList<IInputItemStack>(this.recipeInputList);
        block0: for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            Iterator iter = recipeInputList1.iterator();
            while (iter.hasNext()) {
                IInputItemStack recipeInput = (IInputItemStack)iter.next();
                if (!recipeInput.matches(stack)) continue;
                iter.remove();
                continue block0;
            }
        }
        if (!recipeInputList1.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int col = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            ++col;
        }
        if (col == this.recipeInputList.size()) {
            return this.output.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer p_44002_, Level p_44003_) {
        return this.matches(p_44002_) != ItemStack.f_41583_;
    }

    public ItemStack assemble(CraftingContainer p_44001_) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= this.recipeInputList.size();
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer p_44004_) {
        NonNullList list = NonNullList.m_122780_((int)p_44004_.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < p_44004_.m_6643_(); ++i) {
            ItemStack stack = p_44004_.m_8020_(i);
            if (!(stack.m_41720_() instanceof ItemToolCrafting)) continue;
            stack = stack.m_41720_().getCraftingRemainingItem(stack);
            list.set(i, (Object)stack);
        }
        return list;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.listIngridient;
    }

    public ResourceLocation m_6423_() {
        return new ResourceLocation(this.id);
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44077_;
    }
}

