/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy;

import com.denfop.api.IAdvEnergyNet;
import com.denfop.api.energy.EnergyNetLocal;
import com.denfop.api.energy.EnergyTile;
import com.denfop.api.energy.EventHandler;
import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.NodeStats;
import com.denfop.api.energy.Path;
import com.denfop.api.energy.SunCoef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyNetGlobal
implements IAdvEnergyNet {
    public static IAdvEnergyNet instance;
    public static long tick;
    public static IEnergyTile EMPTY;
    private static Map<ResourceKey<Level>, EnergyNetLocal> worldToEnergyNetMap;
    private boolean transformer;
    private boolean hasrestrictions;
    private boolean explosing;
    private boolean ignoring;
    private boolean losing;

    public EnergyNetGlobal() {
        instance = this;
    }

    public static EnergyNetLocal getForWorld(Level world) {
        if (world == null) {
            return EnergyNetLocal.EMPTY;
        }
        ResourceKey id = world.m_46472_();
        if (!worldToEnergyNetMap.containsKey(id)) {
            EnergyNetLocal local = new EnergyNetLocal(world);
            worldToEnergyNetMap.put((ResourceKey<Level>)id, local);
            return local;
        }
        return worldToEnergyNetMap.getOrDefault(id, EnergyNetLocal.EMPTY);
    }

    public static EnergyNetLocal getForWorld(ResourceKey<Level> id) {
        return worldToEnergyNetMap.getOrDefault(id, EnergyNetLocal.EMPTY);
    }

    public static void onTickEnd(Level world) {
        EnergyNetLocal energyNet = EnergyNetGlobal.getForWorld(world);
        if (energyNet != EnergyNetLocal.EMPTY) {
            energyNet.onTickEnd();
        }
    }

    public static EnergyNetGlobal initialize() {
        new EventHandler();
        instance = new EnergyNetGlobal();
        instance.update();
        return (EnergyNetGlobal)instance;
    }

    public static void onWorldUnload(Level world) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld((ResourceKey<Level>)world.m_46472_());
        if (local != EnergyNetLocal.EMPTY) {
            local.onUnload();
            worldToEnergyNetMap.remove(world.m_46472_());
        }
    }

    public IEnergyTile getTileEntity(Level world, int x, int y, int z) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileEntity(new BlockPos(x, y, z));
        }
        return EMPTY;
    }

    public IEnergyTile getTileEntity(Level world, BlockPos pos) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileEntity(pos);
        }
        return EMPTY;
    }

    @Override
    public IEnergyTile getTile(Level world, BlockPos blockPos) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileEntity(blockPos);
        }
        return EMPTY;
    }

    @Override
    public Level getWorld(IEnergyTile tile) {
        if (tile == null) {
            return null;
        }
        if (tile instanceof BlockEntity) {
            return ((BlockEntity)tile).m_58904_();
        }
        if (tile.getTileEntity() != null) {
            return tile.getTileEntity().m_58904_();
        }
        throw new UnsupportedOperationException("unlocatable tile type: " + tile.getClass().getName());
    }

    @Override
    public BlockPos getPos(IEnergyTile iEnergyTile) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(iEnergyTile));
        if (local != EnergyNetLocal.EMPTY) {
            return local.getPos(iEnergyTile);
        }
        return null;
    }

    @Override
    public NodeStats getNodeStats(IEnergyTile te) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(te));
        if (local == EnergyNetLocal.EMPTY) {
            return new NodeStats(0.0, 0.0);
        }
        return local.getNodeStats(te);
    }

    @Override
    public double getPowerFromTier(int tier) {
        return tier < 14 ? 8.0 * Math.pow(4.0, tier) : 9.223372036854776E18;
    }

    @Override
    public int getTierFromPower(double power) {
        if (power <= 0.0) {
            return 0;
        }
        return Math.min(14, (int)Math.ceil(Math.log(power / 8.0) / Math.log(4.0)));
    }

    @Override
    public SunCoef getSunCoefficient(Level world) {
        return EnergyNetGlobal.getForWorld(world).getSuncoef();
    }

    @Override
    public boolean getTransformerMode() {
        return this.transformer;
    }

    @Override
    public Map<ChunkPos, List<IEnergySink>> getChunkPosListMap(Level world) {
        return EnergyNetGlobal.getForWorld(world).getChunkPosListMap();
    }

    @Override
    public boolean getLosing() {
        return this.getTransformerMode() && this.losing;
    }

    @Override
    public boolean needExplosion() {
        return this.getTransformerMode() && this.explosing;
    }

    @Override
    public boolean needIgnoringTiers() {
        return this.getTransformerMode() && !this.ignoring;
    }

    @Override
    public boolean hasRestrictions() {
        return this.getTransformerMode() && this.hasrestrictions;
    }

    @Override
    public BlockEntity getBlockPosFromEnergyTile(IEnergyTile tile) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(tile));
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileFromIEnergy(tile);
        }
        return null;
    }

    @Override
    public List<Path> getEnergyPaths(Level world, BlockPos pos) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        IEnergyTile energyTile = local.getChunkCoordinatesIEnergyTileMap().get(pos);
        if (energyTile != EMPTY) {
            return local.getEnergyPaths(energyTile);
        }
        return new ArrayList<Path>();
    }

    @Override
    public void update() {
        this.transformer = true;
        this.losing = true;
        this.ignoring = true;
        this.explosing = true;
        this.hasrestrictions = false;
    }

    static {
        tick = 0L;
        EMPTY = new EnergyTile(){};
        worldToEnergyNetMap = new HashMap<ResourceKey<Level>, EnergyNetLocal>();
    }
}

