/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gasvein;

import com.denfop.api.gasvein.GasVein;
import com.denfop.api.gasvein.IGasVeinSystem;
import com.denfop.api.gasvein.TypeGas;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.MinecraftForge;

public class GasVeinSystem
implements IGasVeinSystem {
    public static IGasVeinSystem system;
    public static GasVein EMPTY;
    private final Random rand;
    List<GasVein> list;
    List<ChunkPos> chunkPos;
    Map<ChunkPos, GasVein> chunkPosVeinMap;

    public GasVeinSystem() {
        system = this;
        this.list = new LinkedList<GasVein>();
        this.chunkPos = new LinkedList<ChunkPos>();
        this.chunkPosVeinMap = new HashMap<ChunkPos, GasVein>();
        this.rand = new Random();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public GasVein getEMPTY() {
        return EMPTY;
    }

    @Override
    public List<ChunkPos> getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public List<GasVein> getVeinsList() {
        return this.list;
    }

    @Override
    public void addVein(ChunkAccess chunk) {
        int chance = this.rand.nextInt(100);
        this.rand.setSeed(this.rand.nextLong());
        GasVein vein = new GasVein(TypeGas.NONE, chunk.m_7697_());
        if (chance < 20) {
            vein.setType(TypeGas.values()[this.rand.nextInt(4) + 1]);
            vein.setMaxCol(200000);
            vein.setCol(200000);
        }
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public void addVein(CompoundTag tag) {
        GasVein vein = new GasVein(tag);
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public GasVein getVein(ChunkPos pos) {
        return this.chunkPosVeinMap.getOrDefault(pos, EMPTY);
    }

    @Override
    public void unload() {
        this.list.clear();
        this.chunkPos.clear();
        this.chunkPosVeinMap.clear();
    }

    static {
        EMPTY = new GasVein(TypeGas.NONE, new ChunkPos(999999999, 999999999));
    }
}

