/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.blocks.FluidName;
import com.denfop.componets.Fluids;
import com.denfop.gui.GuiCore;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TankGauge
extends GuiElement<TankGauge> {
    public static final int v = 100;
    protected final IFluidTank tank;
    private final TankGuiStyle style;

    public TankGauge(GuiCore<?> gui, int x, int y, int width, int height, IFluidTank tank, TankGuiStyle style) {
        super(gui, x, y, width, height);
        if (tank == null) {
            throw new NullPointerException("null tank");
        }
        this.tank = tank;
        this.style = style;
    }

    public static TankGauge createNormal(GuiCore<?> gui, int x, int y, IFluidTank tank) {
        return new TankGauge(gui, x, y, 20, 55, tank, TankGuiStyle.Normal);
    }

    public static TankGauge createPlain(GuiCore<?> gui, int x, int y, int width, int height, IFluidTank tank) {
        return new TankGauge(gui, x, y, width, height, tank, TankGuiStyle.Plain);
    }

    public static TankGauge createBorderless(GuiCore<?> gui, int x, int y, IFluidTank tank, boolean mirrored) {
        return new TankGauge(gui, x, y, 12, 47, tank, mirrored ? TankGuiStyle.BorderlessMirrored : TankGuiStyle.Borderless);
    }

    public TankGuiStyle getStyle() {
        return this.style;
    }

    @Override
    public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
        TankGauge.bindCommonTexture();
        FluidStack fs = this.tank.getFluid();
        if (!fs.isEmpty() && fs.getAmount() > 0) {
            Fluid fluid;
            if (this.style.withBorder) {
                this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.width, this.height);
            }
            int fluidX = this.x;
            int fluidY = this.y;
            int fluidWidth = this.width;
            int fluidHeight = this.height;
            if (this.style.withBorder) {
                fluidX += 4;
                fluidY += 4;
                fluidWidth = 12;
                fluidHeight = 48;
            }
            if ((fluid = fs.getFluid()) == Fluids.f_76193_) {
                fluid = (Fluid)FluidName.fluidwater.getInstance().get();
            }
            IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
            TextureAtlasSprite sprite = TankGauge.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
            int color = extensions.getTintColor();
            double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
            TankGauge.bindBlockTexture();
            this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, -1, 1.0, false, true);
            if (this.style.withGauge) {
                TankGauge.bindCommonTexture();
                int gaugeX = this.x;
                int gaugeY = this.y;
                if (!this.style.withBorder) {
                    gaugeX -= 4;
                    gaugeY -= 4;
                }
                this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
            }
        } else if (this.style.withBorder) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 70, 100, this.width, this.height);
        } else if (this.style.withGauge) {
            this.gui.drawTexturedModalRect(poseStack, mouseX + this.x, mouseY + this.y, 74, 104, this.width, this.height);
        }
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.tank.getFluid();
        if (KeyboardIU.isKeyDown(340)) {
            if (this.tank instanceof Fluids.InternalFluidTank) {
                Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                ret.add(Localization.translate("iu.tank.fluids"));
                ret.addAll(tank1.getFluidList());
            }
        } else if (!fs.isEmpty() && fs.getAmount() > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(Localization.translate(fs.getFluid().getFluidType().getDescriptionId()) + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
            } else {
                ret.add("invalid fluid stack");
            }
        } else {
            ret.add(Localization.translate("iu.generic.text.empty"));
        }
        return ret;
    }

    public static enum TankGuiStyle {
        Normal(true, true, false),
        Borderless(false, true, false),
        BorderlessMirrored(false, true, true),
        Plain(false, false, false);

        public final boolean withBorder;
        public final boolean withGauge;
        public final boolean mirrorGauge;

        private TankGuiStyle(boolean withBorder, boolean withGauge, boolean mirrorGauge) {
            this.withBorder = withBorder;
            this.withGauge = withGauge;
            this.mirrorGauge = mirrorGauge;
        }
    }
}

