/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.item.IDamageItem;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.items.reactors.ItemComponentVent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LogicComponent {
    private final IReactorItem item;
    private final ItemStack stack;
    private final IAdvReactor reactor;
    private final int maxDamage;
    private final boolean componentVent;
    private final byte x;
    private final byte y;
    public byte nearRod = 0;
    public short damage;
    double heat;
    private int maxDamageItem;
    private byte count;
    private List<LogicComponent> logicComponents;

    public LogicComponent(IReactorItem item, int x, int y, ItemStack stack, IAdvReactor reactor) {
        Item item2;
        this.item = item;
        this.x = (byte)x;
        this.y = (byte)y;
        this.logicComponents = new ArrayList<LogicComponent>(Collections.nCopies(4, LogicReactor.NULL));
        this.heat = item.getHeat(reactor);
        if (item.getType() == EnumTypeComponent.ROD) {
            this.damage = 1;
        }
        this.stack = stack;
        this.count = 0;
        this.reactor = reactor;
        this.componentVent = this.getItem() instanceof ItemComponentVent;
        if (stack != null && (item2 = stack.m_41720_()) instanceof IDamageItem) {
            IDamageItem damageItem = (IDamageItem)item2;
            this.maxDamage = damageItem.getMaxCustomDamage(stack);
            this.maxDamageItem = damageItem.getCustomDamage(stack);
        } else {
            this.maxDamage = 0;
            this.maxDamageItem = 0;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getY() {
        return this.y;
    }

    public List<LogicComponent> getLogicComponents() {
        return this.logicComponents;
    }

    public IReactorItem getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicComponent that = (LogicComponent)o;
        return this.x == that.x && this.y == that.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public void updateAllInterface(List<LogicComponent> logicComponents, int width, int height, IAdvReactor reactor) {
        double temp_heat;
        LogicComponent cmp;
        if (this.x == -1 || this.y == -1) {
            return;
        }
        int i = -1;
        int k = 0;
        while (i <= 1) {
            if (this.x + i < 0 || this.x + i >= width) {
                this.count = (byte)(this.count + 1);
            } else {
                if (this.getItem().getType() == EnumTypeComponent.ROD) {
                    this.heat *= reactor.getMulHeatRod(this.x, this.y, this.stack);
                }
                if ((cmp = logicComponents.get(this.x + i + width * this.y)).getItem() != null && cmp.x != -1) {
                    this.logicComponents.set(k, cmp);
                    if (this.getItem().getType() == EnumTypeComponent.ROD && cmp.getItem().getType() == EnumTypeComponent.ROD) {
                        temp_heat = this.heat;
                        this.heat += cmp.heat / 4.0;
                        cmp.heat += temp_heat / 4.0;
                    }
                }
                if (cmp.equals(LogicReactor.NULL)) {
                    this.count = (byte)(this.count + 1);
                }
            }
            i += 2;
            ++k;
        }
        int j = -1;
        k = 2;
        while (j <= 1) {
            if (this.y + j < 0 || this.y + j >= height) {
                this.count = (byte)(this.count + 1);
            } else {
                cmp = logicComponents.get(this.x + width * (this.y + j));
                if (cmp.getItem() != null) {
                    this.logicComponents.set(k, cmp);
                    if (this.getItem().getType() == EnumTypeComponent.ROD && cmp.getItem().getType() == EnumTypeComponent.ROD) {
                        temp_heat = this.heat;
                        this.heat += cmp.heat / 4.0;
                        cmp.heat += temp_heat / 4.0;
                    }
                }
                if (cmp.equals(LogicReactor.NULL)) {
                    this.count = (byte)(this.count + 1);
                }
                if (this.getItem().getType() == EnumTypeComponent.ROD && this.count != 0) {
                    this.heat *= (double)(this.count + 1) * 1.5;
                }
            }
            j += 2;
            ++k;
        }
        this.logicComponents.removeIf(logicComponent -> logicComponent.x == -1);
    }

    public boolean canExtractHeat() {
        return this.getItem().caneExtractHeat();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean onTick() {
        if (this.getItem().getType() == EnumTypeComponent.ROD) {
            return false;
        }
        if (this.getItem().getType() == EnumTypeComponent.ENERGY_COUPLER || this.getItem().getType() == EnumTypeComponent.NEUTRON_PROTECTOR) {
            this.item.damageItem(this.stack, 1);
            ++this.maxDamageItem;
        } else if (this.damage != 0) {
            if (!this.componentVent) {
                if (this.maxDamageItem > 0) {
                    this.item.damageItem(this.stack, this.damage);
                }
                if (this.maxDamageItem > 0 && this.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
                    this.item.damageItem(this.stack, this.damage);
                }
                this.maxDamageItem -= this.damage * -1;
                if (this.maxDamageItem > this.maxDamage) {
                    this.maxDamageItem = this.maxDamage;
                }
                if (this.maxDamageItem < 0) {
                    this.maxDamageItem = 0;
                }
            } else if (this.damage >= 150 * this.getItem().getLevel()) {
                this.item.damageItem(this.stack, this.damage);
                this.maxDamageItem = 0;
            }
        }
        if (this.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
            double heat = this.reactor.getHeat();
            heat -= this.heat;
            heat = Math.max(0.0, heat);
            this.reactor.setHeat(heat);
        }
        return this.maxDamageItem == this.maxDamage;
    }

    public double getHeat() {
        if (this.getItem().getType() == EnumTypeComponent.CAPACITOR || this.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
            return 0.0;
        }
        return this.heat;
    }
}

