/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.IHeatReactor;
import com.denfop.api.reactors.LogicComponent;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.blocks.FluidName;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LogicHeatReactor
extends LogicReactor {
    private final IHeatReactor heatReactor;
    public double temp_heat = 0.0;
    private HashMap<Integer, Double> mapGraphiteConsume;

    public LogicHeatReactor(IHeatReactor advReactor) {
        super(advReactor);
        this.heatReactor = advReactor;
    }

    @Override
    public void calculateComponent() {
        super.calculateComponent();
        this.mapGraphiteConsume = new HashMap();
        for (int i = 0; i < this.x; ++i) {
            double col = 0.0;
            for (LogicComponent component : this.rodsList) {
                if (component.getX() != i) continue;
                col += component.heat * 0.83 / 160.0;
            }
            if (col == 0.0) continue;
            this.mapGraphiteConsume.put(i, col);
        }
    }

    @Override
    public void onTick() {
        if (this.rodsList.isEmpty()) {
            if (this.temp_heat >= 1.0) {
                this.temp_heat -= (double)rand.nextInt((int)this.temp_heat);
            }
            this.reactor.setOutput(0.0);
        } else {
            boolean can = true;
            for (Map.Entry<Integer, Double> entry : this.mapGraphiteConsume.entrySet()) {
                double col;
                int[] lengthGraphite = this.heatReactor.getLengthGraphiteIndex(entry.getKey());
                double col1 = col = entry.getValue().doubleValue();
                for (int i : lengthGraphite) {
                    if (col1 <= 0.0) break;
                    if (this.heatReactor.getFuelGraphite(i) > col1) {
                        this.heatReactor.consumeFuelGraphite(i, col1);
                        int level = this.heatReactor.getLevelGraphite(i);
                        col1 = 0.0;
                        if ((double)this.heatReactor.getHeliumTank().getFluidAmount() >= col * (double)level) {
                            this.heatReactor.addHeliumToRegenerate(col * (double)level / 2.0);
                            this.heatReactor.getHeliumTank().drain((int)(col * (double)level), IFluidHandler.FluidAction.EXECUTE);
                            this.temp_heat -= (double)rand.nextInt(100);
                            if (!(this.temp_heat < 0.0)) continue;
                            this.temp_heat = 0.0;
                            continue;
                        }
                        this.temp_heat += (double)rand.nextInt(200);
                        continue;
                    }
                    if (!this.heatReactor.getGraphite(i).m_41619_()) {
                        this.heatReactor.consumeGraphite(i);
                        double fuel = this.heatReactor.getFuelGraphite(i);
                        if (fuel < col1) {
                            col1 -= fuel;
                            continue;
                        }
                        this.heatReactor.consumeFuelGraphite(i, col1);
                        int level = this.heatReactor.getLevelGraphite(i);
                        col1 = 0.0;
                        if ((double)this.heatReactor.getHeliumTank().getFluidAmount() >= col * (double)level) {
                            this.heatReactor.addHeliumToRegenerate(col * (double)level / 2.0);
                            this.heatReactor.getHeliumTank().drain((int)(col * (double)level), IFluidHandler.FluidAction.EXECUTE);
                            this.temp_heat -= (double)rand.nextInt(100);
                            if (!(this.temp_heat < 0.0)) continue;
                            this.temp_heat = 0.0;
                            continue;
                        }
                        this.temp_heat += (double)rand.nextInt(200);
                        continue;
                    }
                    this.temp_heat += (double)rand.nextInt(100);
                }
                if (!(col1 > 0.0)) continue;
                this.temp_heat += (double)rand.nextInt((int)(50.0 * col));
                can = false;
                break;
            }
            if (this.temp_heat < 0.0) {
                this.temp_heat = 0.0;
            }
            int temp = (int)((double)this.generation * 1.05);
            if (can) {
                int j;
                super.onTick();
                if (!this.heatReactor.isFull()) {
                    return;
                }
                if (this.temp_heat < 0.0) {
                    this.temp_heat = 0.0;
                }
                if (this.temp_heat >= 0.0 && this.temp_heat < this.getMaxHeat() && this.getMaxHeat() > 1.0) {
                    this.temp_heat += (double)rand.nextInt((int)(this.getMaxHeat() - this.temp_heat));
                }
                for (j = 0; j < this.heatReactor.getLengthSimplePump(); ++j) {
                    double col = Math.floor(this.heatReactor.getHeliumToRegenerate());
                    if ((col = Math.min(col, (double)this.heatReactor.getHeliumTank().getFluidAmount())) < 1.0) break;
                    int energy = this.heatReactor.getEnergySimplePump(j);
                    if (energy <= 0 || temp < energy) continue;
                    temp -= energy;
                    int power = this.heatReactor.getPowerSimplePump(j);
                    if ((double)power > col) {
                        this.heatReactor.addHeliumToRegenerate(-col);
                        this.heatReactor.getHeliumTank().fill(new FluidStack((Fluid)FluidName.fluidHelium.getInstance().get(), (int)col), IFluidHandler.FluidAction.EXECUTE);
                        this.temp_heat -= (double)rand.nextInt(20 * power);
                        if (!(this.temp_heat < 0.0)) continue;
                        this.temp_heat = 0.0;
                        continue;
                    }
                    this.heatReactor.addHeliumToRegenerate(-power);
                    this.heatReactor.getHeliumTank().fill(new FluidStack((Fluid)FluidName.fluidHelium.getInstance().get(), power), IFluidHandler.FluidAction.EXECUTE);
                    this.temp_heat -= (double)rand.nextInt(10 * power);
                    if (!(this.temp_heat < 0.0)) continue;
                    this.temp_heat = 0.0;
                }
                for (j = 0; j < this.heatReactor.getLengthPump(); ++j) {
                    int energy = this.heatReactor.getEnergyPump(j);
                    if (energy <= 0 || temp < energy) continue;
                    temp -= energy;
                    int power = this.heatReactor.getPowerPump(j);
                    if (this.heatReactor.getWaterTank().getFluidAmount() <= 15 * power || this.heatReactor.getHydrogenTank().getFluidAmount() + 10 * power >= this.heatReactor.getHydrogenTank().getCapacity() || this.heatReactor.getOxygenTank().getFluidAmount() + 5 * power >= this.heatReactor.getOxygenTank().getCapacity()) continue;
                    this.heatReactor.getWaterTank().drain(15 * power, IFluidHandler.FluidAction.EXECUTE);
                    this.heatReactor.getHydrogenTank().fill(new FluidStack((Fluid)FluidName.fluidhyd.getInstance().get(), 10 * power), IFluidHandler.FluidAction.EXECUTE);
                    this.heatReactor.getOxygenTank().fill(new FluidStack((Fluid)FluidName.fluidoxy.getInstance().get(), 5 * power), IFluidHandler.FluidAction.EXECUTE);
                    this.heatReactor.damagePump(j);
                    this.temp_heat -= (double)rand.nextInt(power * 20);
                    if (!(this.temp_heat < 0.0)) continue;
                    this.temp_heat = 0.0;
                }
                this.heatReactor.setOutput(temp);
            } else {
                this.temp_heat += (double)rand.nextInt(200);
                this.reactor.setOutput(0.0);
            }
        }
        this.heatReactor.setHeat(this.temp_heat);
    }

    public double getTemp_heat() {
        return this.temp_heat;
    }

    public void setTemp_heat(double temp_heat) {
        this.temp_heat = temp_heat;
    }
}

