/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IInput;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeArrayList;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.componets.Fluids;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.items.ItemRecipeSchedule;
import com.denfop.tiles.base.TileConverterSolidMatter;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class InvSlotRecipes
extends InvSlot
implements ITypeSlot {
    public final IUpdateTick tile;
    private final ConcurrentHashMap<Integer, RecipeArrayList<IRecipeInputStack>> map = new ConcurrentHashMap();
    private final RecipeArrayList<IRecipeInputStack> default_accepts;
    private IBaseRecipe recipe;
    private RecipeArrayList<IRecipeInputStack> accepts;
    private List<BaseMachineRecipe> recipe_list;
    private Fluids.InternalFluidTank tank;
    private InvSlotFluidByList invSlotConsumableLiquidByList = null;
    private int index;

    public InvSlotRecipes(TileEntityInventory base, IBaseRecipe baseRecipe, IUpdateTick tile) {
        super(base, InvSlot.TypeItemSlot.INPUT, baseRecipe.getSize());
        this.recipe = baseRecipe;
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
        this.default_accepts = this.accepts;
        if (this.recipe_list != null) {
            for (BaseMachineRecipe baseMachineRecipe : this.recipe_list) {
                IInput input = baseMachineRecipe.input;
                for (int i = 0; i < input.getInputs().size(); ++i) {
                    RecipeArrayList<IRecipeInputStack> list = this.map.get(i);
                    if (list == null) {
                        RecipeArrayList inputStackList = new RecipeArrayList();
                        inputStackList.add(new RecipeInputStack(input.getInputs().get(i)));
                        this.map.put(i, inputStackList);
                        continue;
                    }
                    list.add(new RecipeInputStack(input.getInputs().get(i)));
                }
            }
        }
        this.tile = tile;
        this.tank = null;
    }

    public InvSlotRecipes(TileEntityInventory base, String baseRecipe, IUpdateTick tile) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile);
    }

    public InvSlotRecipes(TileEntityInventory base, String baseRecipe, IUpdateTick tile, Fluids.InternalFluidTank tank) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile);
        this.tank = tank;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void changeAccepts(ItemStack stack) {
        if (stack.m_41619_()) {
            this.accepts = this.default_accepts;
        } else {
            ItemRecipeSchedule itemRecipeSchedule = (ItemRecipeSchedule)stack.m_41720_();
            this.accepts = itemRecipeSchedule.getInputs(this.recipe, stack);
        }
    }

    public IUpdateTick getTile() {
        return this.tile;
    }

    public void setInvSlotConsumableLiquidByList(InvSlotFluidByList invSlotConsumableLiquidByList) {
        this.invSlotConsumableLiquidByList = invSlotConsumableLiquidByList;
    }

    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    public void load() {
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.map.clear();
        if (this.recipe_list != null) {
            for (BaseMachineRecipe baseMachineRecipe : this.recipe_list) {
                IInput input = baseMachineRecipe.input;
                for (int i = 0; i < input.getInputs().size(); ++i) {
                    RecipeArrayList<IRecipeInputStack> list = this.map.get(i);
                    if (list == null) {
                        RecipeArrayList inputStackList = new RecipeArrayList();
                        inputStackList.add(new RecipeInputStack(input.getInputs().get(i)));
                        this.map.put(i, inputStackList);
                        continue;
                    }
                    list.add(new RecipeInputStack(input.getInputs().get(i)));
                }
            }
        }
        if (this.invSlotConsumableLiquidByList != null) {
            this.invSlotConsumableLiquidByList.setAcceptedFluids(new HashSet<Fluid>(Recipes.recipes.getInputFluidsFromRecipe(this.recipe.getName())));
        }
        if (this.tank != null) {
            this.tank.setAcceptedFluids(Fluids.fluidPredicate(Recipes.recipes.getInputFluidsFromRecipe(this.recipe.getName())));
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        MachineRecipe recipe1 = this.process();
        this.tile.setRecipeOutput(this.index, recipe1);
        this.tile.onUpdate();
        return content;
    }

    @Override
    public boolean acceptAllOrIndex() {
        return !this.recipe.require();
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        if (index > this.recipe.getSize()) {
            return false;
        }
        if (!this.recipe.require()) {
            return !itemStack.m_41619_() && (this.recipe.getName().equals("painter") || this.recipe.getName().equals("upgradeblock") || this.recipe.getName().equals("recycler") || this.accepts.contains(itemStack));
        }
        RecipeArrayList<IRecipeInputStack> list = this.map.get(index);
        if (list == null) {
            return false;
        }
        return list.contains(itemStack);
    }

    public void consume(int number, int amount) {
        this.consume(number, amount, false);
    }

    public boolean continue_process(MachineRecipe recipe) {
        if (this.tank == null) {
            return Recipes.recipes.needContinue(recipe, this);
        }
        return Recipes.recipes.needContinue(recipe, this, this.tank);
    }

    public void consume(int number, int amount, boolean simulate) {
        ItemStack stack = this.get(number);
        if (!stack.m_41619_() && stack.m_41613_() >= 1) {
            int currentAmount = Math.min(amount, stack.m_41613_());
            if (!simulate) {
                stack.m_41774_(currentAmount);
            }
        }
    }

    @Override
    public ItemStack get(int index) {
        return super.get(index);
    }

    public MachineRecipe process() {
        if (!this.recipe.workbench()) {
            for (int i = 0; i < Math.min(this.size(), this.recipe.getSize()); ++i) {
                if (!this.get(i).m_41619_()) continue;
                return null;
            }
            MachineRecipe output = this.getOutputFor();
            if (this.tile instanceof TileConverterSolidMatter) {
                TileConverterSolidMatter mechanism = (TileConverterSolidMatter)this.tile;
                if (output != null) {
                    mechanism.getrequiredmatter(output.getRecipe().getOutput());
                }
            }
            return output;
        }
        MachineRecipe output = this.getOutputFor();
        return output;
    }

    public BaseMachineRecipe consume() {
        for (int i = 0; i < this.recipe.getSize(); ++i) {
            if (!this.get(i).m_41619_()) continue;
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.recipe.getSize(); ++i) {
            list.add((ItemStack)this.contents.get(i));
        }
        if (this.tank == null) {
            return Recipes.recipes.getRecipeConsume(this.recipe, this.tile.getRecipeOutput(this.index), this.recipe.consume(), list);
        }
        return Recipes.recipes.getRecipeOutputFluid(this.recipe, this.tile.getRecipeOutput(this.index), this.recipe.consume(), list, this.tank);
    }

    public boolean continue_proccess(InvSlotOutput slot) {
        if (this.tile.getRecipeOutput(this.index) == null) {
            return false;
        }
        if (this.tank == null) {
            return slot.canAdd(this.tile.getRecipeOutput((int)this.index).getRecipe().output.items) && this.get(0).m_41613_() >= this.tile.getRecipeOutput(this.index).getList().get(0);
        }
        return slot.canAdd(this.tile.getRecipeOutput((int)this.index).getRecipe().output.items) && this.get(0).m_41613_() >= this.tile.getRecipeOutput(this.index).getList().get(0) && this.tank.getFluidAmount() >= this.tile.getRecipeOutput((int)this.index).getRecipe().input.getFluid().getAmount();
    }

    private MachineRecipe getOutputFor() {
        ArrayList<ItemStack> list = new ArrayList(this.contents);
        list = list.stream().limit(this.recipe.getSize()).collect(Collectors.toList());
        if (this.tank == null) {
            return Recipes.recipes.getRecipeMachineRecipeOutput(this.recipe, this.recipe_list, false, list);
        }
        return Recipes.recipes.getRecipeOutputMachineFluid(this.recipe, this.recipe_list, false, list, this.tank);
    }

    public IBaseRecipe getRecipe() {
        return this.recipe;
    }

    public void setRecipe(IBaseRecipe recipe) {
        this.recipe = recipe;
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
        this.load();
    }

    public void setRecipe(String recipe) {
        this.setRecipe(Recipes.recipes.getRecipe(recipe));
    }

    public List<BaseMachineRecipe> getRecipe_list() {
        return this.recipe_list;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        if (this.recipe.getName().equals("rotor_assembler")) {
            if (slotid == 4) {
                return EnumTypeSlot.ROD_PART1;
            }
            return EnumTypeSlot.ROD_PART;
        }
        if (this.recipe.getName().equals("water_rotor_assembler")) {
            if (slotid == 4) {
                return EnumTypeSlot.ROD_PART1;
            }
            return EnumTypeSlot.WATER_ROD_PART;
        }
        return null;
    }

    public void consume(int size, MachineRecipe output) {
        if (this.recipe.consume()) {
            if (this.recipe.workbench()) {
                for (int i = 0; i < output.getList().size(); ++i) {
                    ItemStack stack = this.get(i);
                    if (stack.m_41619_()) continue;
                    stack.m_41774_(size * output.getList().get(i));
                }
                if (output.getRecipe().input.getFluid() != null) {
                    this.getTank().drain(output.getRecipe().input.getFluid().getAmount() * size, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                for (int i = 0; i < output.getList().size(); ++i) {
                    ItemStack stack = this.get(i);
                    stack.m_41774_(size * output.getList().get(i));
                }
                if (output.getRecipe().input.getFluid() != null) {
                    this.getTank().drain(output.getRecipe().input.getFluid().getAmount() * size, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }
}

