/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.DataItem;
import com.denfop.api.space.colonies.Sends;
import com.denfop.api.space.colonies.api.IBuildingItem;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.IColonyBuilding;
import com.denfop.api.space.colonies.api.IColonyNet;
import com.denfop.api.space.colonies.api.building.IStorage;
import com.denfop.api.space.colonies.building.ColonyHouse;
import com.denfop.api.space.colonies.building.ColonyPanelFactory;
import com.denfop.api.space.colonies.building.Factory;
import com.denfop.api.space.colonies.building.OxygenFactory;
import com.denfop.api.space.colonies.building.ProtectionBuilding;
import com.denfop.api.space.colonies.enums.EnumHousesLevel;
import com.denfop.api.space.colonies.enums.EnumProtectionLevel;
import com.denfop.api.space.colonies.enums.EnumTypeFactory;
import com.denfop.api.space.colonies.enums.EnumTypeSolarPanel;
import com.denfop.api.space.fakebody.Data;
import com.denfop.network.packet.PacketSuccessUpdateColony;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ColonyNet
implements IColonyNet {
    Map<UUID, List<IColony>> fakePlayerListMap;
    List<IColony> colonyList;
    List<UUID> fakePlayerList;
    Map<IBody, List<DataItem<ItemStack>>> bodyItemStackList = new ConcurrentHashMap<IBody, List<DataItem<ItemStack>>>();
    Map<IBody, List<DataItem<FluidStack>>> bodyFluidStackList = new ConcurrentHashMap<IBody, List<DataItem<FluidStack>>>();
    Map<UUID, List<Sends>> sends = new ConcurrentHashMap<UUID, List<Sends>>();
    List<IColony> deleteList = new LinkedList<IColony>();

    public ColonyNet() {
        this.fakePlayerListMap = new ConcurrentHashMap<UUID, List<IColony>>();
        this.colonyList = new LinkedList<IColony>();
        this.fakePlayerList = new LinkedList<UUID>();
    }

    @Override
    public Map<UUID, List<IColony>> getMap() {
        return this.fakePlayerListMap;
    }

    @Override
    public boolean canAddColony(IBody body, Player player) {
        Data data = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(player.m_20148_()).get(body);
        if (data == null) {
            return false;
        }
        IColonyBuilding houses = this.hasItemInInventory(player, ColonyHouse.class, 3);
        if (houses == null) {
            return false;
        }
        if (((ColonyHouse)houses).getLevel() != EnumHousesLevel.LOW) {
            return false;
        }
        IColonyBuilding oxygen = this.hasItemInInventory(player, OxygenFactory.class, 1);
        if (oxygen == null) {
            return false;
        }
        IColonyBuilding factory = this.hasItemInInventory(player, Factory.class, 2);
        if (factory == null) {
            return false;
        }
        if (((Factory)factory).getType() != EnumTypeFactory.LOW) {
            return false;
        }
        IColonyBuilding protection = this.hasItemInInventory(player, ProtectionBuilding.class, 1);
        if (protection == null) {
            return false;
        }
        if (((ProtectionBuilding)protection).getProtectionBuilding() != EnumProtectionLevel.LOW) {
            return false;
        }
        IColonyBuilding panel = this.hasItemInInventory(player, ColonyPanelFactory.class, 1);
        if (panel == null) {
            return false;
        }
        if (((ColonyPanelFactory)panel).getType() != EnumTypeSolarPanel.LOW) {
            return false;
        }
        List<IColony> list = this.fakePlayerListMap.get(player.m_20148_());
        if (list == null) {
            return true;
        }
        for (IColony colony : list) {
            if (!colony.matched(body)) continue;
            return false;
        }
        return true;
    }

    private IColonyBuilding hasItemInInventory(Player player, Class<?> colonyClass, int count) {
        NonNullList mainInventory = player.m_150109_().f_35974_;
        for (ItemStack stack : mainInventory) {
            IBuildingItem buildingItem;
            IColonyBuilding building;
            if (!(stack.m_41720_() instanceof IBuildingItem) || stack.m_41613_() < count || !colonyClass.isInstance(building = (buildingItem = (IBuildingItem)stack.m_41720_()).getBuilding(null, stack, true))) continue;
            return building;
        }
        return null;
    }

    private void consumeItemInInventory(Player player, Class<?> colonyClass, int count, Colony colony) {
        NonNullList mainInventory = player.m_150109_().f_35974_;
        for (ItemStack stack : mainInventory) {
            IBuildingItem buildingItem;
            IColonyBuilding building;
            if (!(stack.m_41720_() instanceof IBuildingItem) || stack.m_41613_() < count || !colonyClass.isInstance(building = (buildingItem = (IBuildingItem)stack.m_41720_()).getBuilding(colony, stack, true))) continue;
            for (int i = 0; i < count; ++i) {
                buildingItem.getBuilding(colony, stack, false);
            }
            stack.m_41774_(count);
        }
    }

    @Override
    public void addItemToColony(IBody body, Player player) {
        List<IColony> list = this.fakePlayerListMap.get(player.m_20148_());
        if (list == null) {
            return;
        }
        for (IColony colony : list) {
            if (!colony.matched(body)) continue;
            ItemStack stack = player.f_36096_.m_142621_();
            if (!(stack.m_41720_() instanceof IBuildingItem)) break;
            IBuildingItem buildingItem = (IBuildingItem)stack.m_41720_();
            IColonyBuilding building = buildingItem.getBuilding(colony, stack, true);
            if (colony.getLevel() < building.getMinLevelColony() || colony.getAvailableBuilding() <= 0) break;
            buildingItem.getBuilding(colony, stack, false);
            stack.m_41774_(1);
            player.f_36096_.m_38946_();
            new PacketSuccessUpdateColony(player);
            break;
        }
    }

    @Override
    public void addColony(IBody body, Player player) {
        if (this.canAddColony(body, player)) {
            Colony colony = new Colony(body, player.m_20148_());
            this.consumeItemInInventory(player, ColonyHouse.class, 3, colony);
            this.consumeItemInInventory(player, Factory.class, 2, colony);
            this.consumeItemInInventory(player, OxygenFactory.class, 1, colony);
            this.consumeItemInInventory(player, ProtectionBuilding.class, 1, colony);
            this.consumeItemInInventory(player, ColonyPanelFactory.class, 1, colony);
            List colonyList = this.fakePlayerListMap.computeIfAbsent(player.m_20148_(), l -> new LinkedList());
            if (colonyList.isEmpty()) {
                this.fakePlayerList.add(player.m_20148_());
            }
            colonyList.add(colony);
            this.colonyList.add(colony);
        }
    }

    @Override
    public void removeColony(IColony colony, UUID player) {
        List<IColony> colonyList = this.fakePlayerListMap.get(player);
        colonyList.remove(colony);
        this.colonyList.remove(colony);
    }

    @Override
    public void removeColony(IBody body, UUID player) {
        List<IColony> colonyList = this.fakePlayerListMap.get(player);
        IColony colony = null;
        for (IColony colony1 : colonyList) {
            if (colony1.getBody() != body) continue;
            colony = colony1;
        }
        colonyList.remove(colony);
        this.colonyList.remove(colony);
    }

    @Override
    public List<Sends> getSendsFromUUID(UUID uuid) {
        return this.sends.getOrDefault(uuid, Collections.emptyList());
    }

    @Override
    public void working() {
        for (Map.Entry<UUID, List<Sends>> uuidListEntry : this.sends.entrySet()) {
            Iterator<Sends> iter = uuidListEntry.getValue().iterator();
            while (iter.hasNext()) {
                Sends sends = iter.next();
                sends.works();
                if (!sends.needRemove()) continue;
                iter.remove();
            }
        }
        for (IColony colony : this.colonyList) {
            colony.update();
            if (colony.getTimeToDelete() > 0) continue;
            this.deleteList.add(colony);
        }
        for (IColony colony : this.deleteList) {
            this.removeColony(colony, colony.getFakePlayer());
        }
        this.deleteList.clear();
    }

    @Override
    public List<IColony> getColonies() {
        return this.colonyList;
    }

    @Override
    public void addFluidStack(IBody body, short level, FluidStack fluidStack) {
        List list = this.bodyFluidStackList.computeIfAbsent(body, k -> new ArrayList());
        list.add(new DataItem<FluidStack>(level, fluidStack));
    }

    @Override
    public void addItemStack(IBody body, short level, ItemStack fluidStack) {
        List list = this.bodyItemStackList.computeIfAbsent(body, k -> new ArrayList());
        list.add(new DataItem<ItemStack>(level, fluidStack));
    }

    @Override
    public List<DataItem<FluidStack>> getFluidsFromBody(IBody body) {
        return this.bodyFluidStackList.getOrDefault(body, Collections.emptyList());
    }

    @Override
    public List<DataItem<ItemStack>> getItemsFromBody(IBody body) {
        return this.bodyItemStackList.getOrDefault(body, Collections.emptyList());
    }

    @Override
    public CompoundTag writeNBT(CompoundTag tag, UUID player) {
        List list = this.fakePlayerListMap.getOrDefault(player, Collections.emptyList());
        ListTag nbt = new ListTag();
        tag.m_128362_("player", player);
        for (IColony colonies : list) {
            nbt.add((Object)colonies.writeNBT(new CompoundTag()));
        }
        ListTag nbt1 = new ListTag();
        for (Sends sends1 : this.sends.getOrDefault(player, Collections.emptyList())) {
            nbt1.add((Object)sends1.writeToNbt());
        }
        tag.m_128365_("sends", (Tag)nbt1);
        tag.m_128365_("colonial", (Tag)nbt);
        return tag;
    }

    @Override
    public void addColony(CompoundTag tag) {
        CompoundTag nbt2;
        int i;
        ListTag nbt = tag.m_128437_("colonial", 10);
        ListTag nbt1 = tag.m_128437_("sends", 10);
        UUID player = tag.m_128342_("player");
        if (this.fakePlayerList.contains(player)) {
            return;
        }
        this.fakePlayerList.add(player);
        LinkedList<Colony> list = new LinkedList<Colony>();
        LinkedList<Sends> list1 = new LinkedList<Sends>();
        for (i = 0; i < nbt1.size(); ++i) {
            nbt2 = nbt.m_128728_(i);
            Sends sends1 = new Sends(nbt2);
            list1.add(sends1);
        }
        for (i = 0; i < nbt.size(); ++i) {
            nbt2 = nbt.m_128728_(i);
            Colony colonies = new Colony(nbt2, player);
            list.add(colonies);
            this.colonyList.add(colonies);
        }
        this.sends.put(player, list1);
        this.fakePlayerListMap.put(player, new ArrayList(list));
    }

    @Override
    public List<UUID> getList() {
        return this.fakePlayerList;
    }

    @Override
    public void unload() {
        this.fakePlayerListMap.clear();
        this.colonyList.clear();
        this.fakePlayerList.clear();
        this.sends.clear();
    }

    @Override
    public void sendResourceToPlanet(UUID uniqueID, IBody body1) {
        List<IColony> colonies = this.fakePlayerListMap.get(uniqueID);
        if (colonies != null) {
            for (IColony colony : colonies) {
                if (!colony.matched(body1)) continue;
                Sends sends1 = new Sends(uniqueID, body1, colony);
                List<IStorage> storages = colony.getStorageList();
                for (IStorage storage : storages) {
                    for (ItemStack stack : storage.getStacks()) {
                        if (sends1.stacks.size() == 27) break;
                        sends1.addStack(stack.m_41777_());
                    }
                    for (FluidStack fluidStack : storage.getFluidStacks()) {
                        if (sends1.fluidStacks.size() == 9) break;
                        sends1.addStack(fluidStack.copy());
                    }
                    storage.getStacks().clear();
                    storage.getFluidStacks().clear();
                }
                if (sends1.stacks.isEmpty() && sends1.fluidStacks.isEmpty()) break;
                List list = this.sends.computeIfAbsent(uniqueID, k -> new LinkedList());
                list.add(sends1);
                break;
            }
        }
    }

    @Override
    public void setAutoSends(UUID uniqueID, IBody body1) {
        List<IColony> colonies = this.fakePlayerListMap.get(uniqueID);
        if (colonies != null) {
            for (IColony colony : colonies) {
                if (!colony.matched(body1)) continue;
                colony.setAuto(!colony.isAuto());
                break;
            }
        }
    }
}

