/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.DataItem;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.building.IColonyMiningFactory;
import com.denfop.api.space.colonies.api.building.IStorage;
import com.denfop.api.space.colonies.enums.EnumMiningFactory;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.world.WorldBaseGen;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class ItemFactory
extends Building
implements IColonyMiningFactory {
    private final EnumMiningFactory type;
    private byte people;

    public ItemFactory(IColony colonie, EnumMiningFactory type, boolean simulate) {
        super(colonie);
        this.type = type;
        this.people = 0;
        if (!simulate) {
            this.getColony().addBuilding(this);
        }
    }

    public ItemFactory(CustomPacketBuffer packetBuffer, Colony colonie) {
        super(colonie);
        this.type = EnumMiningFactory.getID(packetBuffer.readByte());
        this.people = packetBuffer.readByte();
        this.getColony().addBuilding(this);
    }

    public ItemFactory(CompoundTag tag, IColony colonie) {
        super(colonie);
        this.type = EnumMiningFactory.getID(tag.m_128445_("id"));
        this.people = tag.m_128445_("people");
        this.getColony().addBuilding(this);
    }

    @Override
    public CustomPacketBuffer writePacket(CustomPacketBuffer customPacketBuffer) {
        super.writePacket(customPacketBuffer);
        customPacketBuffer.writeByte(this.type.ordinal());
        customPacketBuffer.writeByte(this.people);
        return customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    public void work() {
        List<IStorage> storageList = this.getColony().getStorageList();
        if (storageList.isEmpty() || this.getColony().getEnergy() < this.getEnergy()) {
            return;
        }
        if (this.getColony().getTick() % 5 != 0) {
            return;
        }
        if (WorldBaseGen.random.nextInt(100) < this.type.getChance()) {
            for (IStorage storage : storageList) {
                if (!storage.work()) continue;
                List<DataItem<Object>> itemStacks = SpaceNet.instance.getColonieNet().getItemsFromBody(this.getColony().getBody());
                if (itemStacks.isEmpty()) {
                    return;
                }
                if ((itemStacks = itemStacks.stream().filter(fluidStackDataItem -> fluidStackDataItem.getLevel() <= this.getColony().getLevel()).collect(Collectors.toList())).isEmpty()) {
                    return;
                }
                ItemStack itemStack = ((ItemStack)itemStacks.get(WorldBaseGen.random.nextInt(itemStacks.size())).getElement()).m_41777_();
                itemStack.m_41764_((int)((double)(WorldBaseGen.random.nextInt(this.type.getMaxItemValue()) + 1) * this.getColony().getPercentEntertainment()));
                if (!storage.canAddItemStack(itemStack)) continue;
                this.getColony().useEnergy(this.getEnergy());
                return;
            }
        }
    }

    @Override
    public EnumTypeBuilding getTypeBuilding() {
        return EnumTypeBuilding.FABRIC;
    }

    @Override
    public int getPeople() {
        return this.people;
    }

    @Override
    public CompoundTag writeTag(CompoundTag tag) {
        super.writeTag(tag);
        tag.m_128344_("id", (byte)this.type.ordinal());
        tag.m_128344_("people", this.people);
        return tag;
    }

    @Override
    public int getMinLevelColony() {
        return this.type.getLevel();
    }

    @Override
    public int getEnergy() {
        return this.type.getEnergy();
    }

    @Override
    public EnumMiningFactory getFactory() {
        return this.type;
    }

    @Override
    public int getWorkers() {
        return this.people;
    }

    @Override
    public int needWorkers() {
        return this.type.getNeedPeople() - this.people;
    }

    @Override
    public void addWorkers(int workers) {
        this.people = (byte)(this.people + workers);
    }

    @Override
    public void removeWorkers(int remove) {
        this.people = (byte)(this.people - remove);
    }
}

