/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.sytem.InfoTile;
import com.denfop.api.transport.ITransportAcceptor;
import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportEmitter;
import com.denfop.api.transport.ITransportSink;
import com.denfop.api.transport.ITransportSource;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.InfoCable;
import com.denfop.api.transport.Path;
import com.denfop.api.transport.TransportItem;
import com.denfop.api.transport.TransportTick;
import com.denfop.api.transport.TransportTickList;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TransportNetLocal {
    final TransportTickList<TransportTick<ITransportSource, Path>> senderPath = new TransportTickList();
    private final Level world;
    private final Map<BlockPos, ITransportTile> chunkCoordinatesITransportTileMap;
    List<ITransportSource> sourceToUpdateList = new LinkedList<ITransportSource>();
    byte tick;
    List<ITransportSource> delete = new ArrayList<ITransportSource>();

    TransportNetLocal(Level world) {
        this.world = world;
        this.chunkCoordinatesITransportTileMap = new HashMap<BlockPos, ITransportTile>();
    }

    public void remove1(ITransportSource par1) {
        for (TransportTick transportTick : this.senderPath) {
            if (transportTick.getSource() != par1) continue;
            if (transportTick.getList() != null) {
                for (Path path : transportTick.getList()) {
                    path.target.getEnergyTickList().remove((Object)((ITransportSource)transportTick.getSource()).hashCode());
                }
            }
            transportTick.setItemList(null);
            transportTick.setFluidList(null);
            break;
        }
    }

    public void remove(ITransportSource par1) {
        TransportTick<ITransportSource, Path> energyTick = this.senderPath.removeSource(par1);
        if (energyTick != null) {
            if (energyTick.getList() != null) {
                for (Path path : energyTick.getList()) {
                    path.target.getEnergyTickList().remove((Object)energyTick.getSource().hashCode());
                }
            }
            energyTick.setFluidList(null);
            energyTick.setItemList(null);
        }
    }

    public void removeAll(List<TransportTick<ITransportSource, Path>> par1) {
        if (par1 == null) {
            return;
        }
        for (TransportTick<ITransportSource, Path> IEnergySource2 : par1) {
            if (IEnergySource2.getList() != null) {
                for (Path path : IEnergySource2.getList()) {
                    path.target.getEnergyTickList().remove((Object)IEnergySource2.getSource().hashCode());
                }
            }
            IEnergySource2.setFluidList(null);
            IEnergySource2.setItemList(null);
        }
    }

    public boolean hasInSystem(ITransportAcceptor par1) {
        for (TransportTick transportTick : this.senderPath) {
            if (transportTick.getEnergyItemPaths() != null) {
                for (Path path : transportTick.getEnergyItemPaths()) {
                    if (!path.first.getPos().equals((Object)par1.getPos()) && !path.end.getPos().equals((Object)par1.getPos())) continue;
                    return true;
                }
                continue;
            }
            if (transportTick.getEnergyFluidPaths() == null) continue;
            for (Path path : transportTick.getEnergyFluidPaths()) {
                if (!path.first.getPos().equals((Object)par1.getPos()) && !path.end.getPos().equals((Object)par1.getPos())) continue;
                return true;
            }
        }
        return false;
    }

    public List<TransportTick<ITransportSource, Path>> getSources(ITransportAcceptor par1) {
        if (par1 instanceof ITransportSink) {
            LinkedList<TransportTick<ITransportSource, Path>> list = new LinkedList<TransportTick<ITransportSource, Path>>();
            for (TransportTick transportTick : this.senderPath) {
                if (!((ITransportSink)par1).getEnergyTickList().contains(((ITransportSource)transportTick.getSource()).hashCode())) continue;
                list.add(transportTick);
            }
            return list;
        }
        if (par1 instanceof ITransportConductor) {
            LinkedList<TransportTick> list = new LinkedList<TransportTick>();
            for (TransportTick transportTick : this.senderPath) {
                if (!transportTick.getConductors().contains(par1)) continue;
                list.add(transportTick);
            }
            return new ArrayList<TransportTick<ITransportSource, Path>>(list);
        }
        return Collections.emptyList();
    }

    public void addTile(ITransportTile tile1) {
        this.addTileEntity(tile1.getPos(), tile1);
    }

    public boolean containsKey(TransportTick<ITransportSource, Path> par1) {
        return this.senderPath.contains(par1);
    }

    public void addTileEntity(BlockPos coords, ITransportTile tile) {
        if (this.chunkCoordinatesITransportTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesITransportTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof ITransportAcceptor) {
            this.onTileEntityAdded((ITransportAcceptor)tile);
        }
        if (tile instanceof ITransportSource) {
            this.senderPath.add(new TransportTick(tile, null));
        }
    }

    private void updateAdd(BlockPos pos, ITransportTile tile) {
        for (Direction dir : Direction.values()) {
            ITransportAcceptor receiver2;
            ITransportEmitter sender2;
            BlockPos pos1 = pos.m_121955_(dir.m_122436_());
            ITransportTile tile1 = this.chunkCoordinatesITransportTileMap.get(pos1);
            if (tile1 == null) continue;
            Direction inverseDirection2 = dir.m_122424_();
            if (tile1 instanceof ITransportEmitter && tile instanceof ITransportAcceptor) {
                sender2 = (ITransportEmitter)tile1;
                receiver2 = (ITransportAcceptor)tile;
                if (!sender2.emitsTo(receiver2, dir.m_122424_()) || !receiver2.acceptsFrom(sender2, inverseDirection2.m_122424_())) continue;
                tile1.AddTile(tile, dir.m_122424_());
                tile.AddTile(tile1, dir);
                continue;
            }
            if (!(tile1 instanceof ITransportAcceptor) || !(tile instanceof ITransportEmitter) || !(sender2 = (ITransportEmitter)tile).emitsTo(receiver2 = (ITransportAcceptor)tile1, dir) || !receiver2.acceptsFrom(sender2, inverseDirection2)) continue;
            tile1.AddTile(tile, dir.m_122424_());
            tile.AddTile(tile1, dir);
        }
    }

    public void onTileEntityAdded(ITransportAcceptor tile) {
        LinkedList<ITransportTile> tileEntitiesToCheck = new LinkedList<ITransportTile>();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        this.sourceToUpdateList = new LinkedList<ITransportSource>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ITransportTile currentTileEntity = (ITransportTile)tileEntitiesToCheck.pop();
            List<InfoTile<ITransportTile>> validReceivers = currentTileEntity.getValidReceivers();
            for (InfoTile<ITransportTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((ITransportTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((ITransportTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof ITransportSource) {
                    this.sourceToUpdateList.add((ITransportSource)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof ITransportConductor)) continue;
                tileEntitiesToCheck.push((ITransportTile)validReceiver.tileEntity);
            }
        }
        this.sourceToUpdateList = new ArrayList<ITransportSource>(this.sourceToUpdateList);
    }

    public void removeTile(ITransportTile tile1) {
        this.removeTileEntity(tile1);
    }

    public void removeTileEntity(ITransportTile tile) {
        if (!this.chunkCoordinatesITransportTileMap.containsKey(tile.getPos())) {
            return;
        }
        this.chunkCoordinatesITransportTileMap.remove(tile.getPos());
        if (tile instanceof ITransportAcceptor) {
            this.removeAll(this.getSources((ITransportAcceptor)tile));
        }
        if (tile instanceof ITransportSource) {
            this.remove((ITransportSource)tile);
        }
        this.updateRemove(tile.getPos(), tile);
    }

    private void updateRemove(BlockPos pos, ITransportTile tile) {
        for (Direction dir : Direction.values()) {
            BlockPos pos1 = pos.m_121955_(dir.m_122436_());
            ITransportTile tile1 = this.chunkCoordinatesITransportTileMap.get(pos1);
            if (tile1 == null) continue;
            tile1.RemoveTile(tile, dir.m_122424_());
        }
    }

    public boolean canInsertOrExtract(ITransportConductor transportConductor, ItemStack stack, Direction facing) {
        List<ItemStack> BlackItemStacks = transportConductor.getBlackListItems(facing);
        if (BlackItemStacks.isEmpty()) {
            List<ItemStack> WhiteItemStacks = transportConductor.getWhiteListItems(facing);
            if (!WhiteItemStacks.isEmpty()) {
                for (ItemStack stack1 : WhiteItemStacks) {
                    if (!ModUtils.checkItemEquality(stack1, stack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (ItemStack stack1 : BlackItemStacks) {
            if (!ModUtils.checkItemEquality(stack1, stack)) continue;
            return false;
        }
        return true;
    }

    public boolean canInsertOrExtract(ITransportConductor transportConductor, FluidStack stack, Direction facing) {
        List<FluidStack> BlackItemStacks = transportConductor.getBlackListFluids(facing);
        if (BlackItemStacks.isEmpty()) {
            List<FluidStack> WhiteItemStacks = transportConductor.getWhiteListFluids(facing);
            if (!WhiteItemStacks.isEmpty()) {
                for (FluidStack stack1 : WhiteItemStacks) {
                    if (!stack1.isFluidEqual(stack)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (FluidStack stack1 : BlackItemStacks) {
            if (!stack1.isFluidEqual(stack)) continue;
            return false;
        }
        return true;
    }

    public void emitTransportFrom(ITransportSource<ItemStack, IItemHandler> transportSource, List<Path> transportPaths) {
        for (Path path : transportPaths) {
            ITransportSink transportSink;
            List<Integer> demandedSlots;
            TransportItem<ItemStack> amount = transportSource.getOffered(0, path.firstSide);
            List<ItemStack> items = amount.getList();
            List<Integer> indices = amount.getList1();
            if (items.isEmpty() || path.end.getMax(this.tick) == 0 || path.first.getMax(this.tick) == 0 || (demandedSlots = (transportSink = path.target).getDemanded(path.targetDirection)).isEmpty() || !path.first.canWork() || !path.end.canWork()) continue;
            for (Integer slot : demandedSlots) {
                for (int i = 0; i < indices.size(); ++i) {
                    ItemStack remainingStack;
                    ItemStack currentItem = items.get(i);
                    if (currentItem.m_41619_() || !this.canInsertOrExtract(path.first, currentItem, path.firstSide.m_122424_()) || !this.canInsertOrExtract(path.end, currentItem, path.targetDirection.m_122424_()) || !(remainingStack = path.getHandler().insertItem(slot.intValue(), currentItem, true)).m_41619_() && remainingStack.m_41613_() == currentItem.m_41613_()) continue;
                    ItemStack stack = currentItem.m_41777_();
                    int count = Math.min(Math.min(stack.m_41613_(), path.end.getMax(this.tick)), path.first.getMax(this.tick));
                    stack.m_41764_(count);
                    remainingStack = path.getHandler().insertItem(slot.intValue(), stack, false);
                    int transferredAmount = Math.min(count, currentItem.m_41613_()) - remainingStack.m_41613_();
                    path.end.setMax(transferredAmount);
                    path.first.setMax(transferredAmount);
                    if (transferredAmount > 0) {
                        ItemStack drawnStack = currentItem.m_41620_(transferredAmount);
                        transportSource.draw(drawnStack, indices.get(i), path.firstSide);
                    }
                    if (remainingStack.m_41619_()) {
                        items.set(i, ItemStack.f_41583_);
                        continue;
                    }
                    items.get(i).m_41764_(remainingStack.m_41613_());
                }
            }
        }
    }

    public BlockEntity getTileFromITransport(ITransportTile tile) {
        if (tile == null) {
            return null;
        }
        if (tile instanceof BlockEntity) {
            return (BlockEntity)tile;
        }
        return this.world.m_7702_(tile.getPos());
    }

    public Tuple<List<Path>, LinkedList<ITransportConductor>> discover(ITransportSource emitter) {
        LinkedList<ITransportTile> tileEntitiesToCheck = new LinkedList<ITransportTile>();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList<ITransportConductor> set = new LinkedList<ITransportConductor>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ITransportTile currentTileEntity = (ITransportTile)tileEntitiesToCheck.pop();
            List<InfoTile<ITransportTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            InfoCable cable = null;
            if (currentTileEntity instanceof ITransportConductor) {
                cable = ((ITransportConductor)currentTileEntity).getCable();
            }
            for (InfoTile<ITransportTile> validReceiver : validReceivers) {
                ITransportConductor conductor;
                if (currentTileEntity == emitter) {
                    if (validReceiver.tileEntity == emitter || ((ITransportTile)validReceiver.tileEntity).getIdNetwork() == id || !(validReceiver.tileEntity instanceof ITransportConductor) || !((ITransportConductor)validReceiver.tileEntity).isOutput()) continue;
                    conductor = (ITransportConductor)validReceiver.tileEntity;
                    ((ITransportTile)validReceiver.tileEntity).setId(id);
                    conductor.setCable(new InfoCable(conductor, validReceiver.direction, cable));
                    tileEntitiesToCheck.push((ITransportTile)validReceiver.tileEntity);
                    continue;
                }
                if (validReceiver.tileEntity == emitter || ((ITransportTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                if (validReceiver.tileEntity instanceof ITransportSink && currentTileEntity instanceof ITransportConductor && ((ITransportConductor)currentTileEntity).isInput()) {
                    ((ITransportTile)validReceiver.tileEntity).setId(id);
                    energyPaths.add(new Path((ITransportSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof ITransportConductor)) continue;
                ((ITransportTile)validReceiver.tileEntity).setId(id);
                conductor = (ITransportConductor)validReceiver.tileEntity;
                conductor.setCable(new InfoCable(conductor, validReceiver.direction, cable));
                tileEntitiesToCheck.push((ITransportTile)validReceiver.tileEntity);
            }
        }
        int id1 = WorldBaseGen.random.nextInt();
        energyPaths = new ArrayList(energyPaths);
        for (Path energyPath : energyPaths) {
            ITransportTile tileEntity = energyPath.target;
            Direction energyBlockLink = energyPath.targetDirection;
            if (!((tileEntity = tileEntity.getTiles().get(energyBlockLink)) instanceof ITransportConductor)) continue;
            energyPath.end = (ITransportConductor)tileEntity;
            InfoCable cable = ((ITransportConductor)tileEntity).getCable();
            int max = energyPath.end.getMax();
            while (cable != null) {
                ITransportConductor energyConductor = cable.getConductor();
                if (energyConductor.getHashCodeSource() != id1) {
                    energyConductor.setHashCodeSource(id1);
                    set.add(energyConductor);
                }
                if (energyConductor.getMax() < max) {
                    energyPath.end = null;
                    break;
                }
                if ((cable = cable.getPrev()) == null) break;
                energyPath.first = cable.getConductor();
            }
            if (energyPath.first == null) continue;
            energyPath.firstSide = ModUtils.getFacingFromTwoPositions(emitter.getPos(), energyPath.first.getPos());
        }
        return new Tuple((Object)energyPaths, set);
    }

    private List<InfoTile<ITransportTile>> getValidReceivers(ITransportTile emitter) {
        return emitter.getValidReceivers();
    }

    public void onTickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (ITransportSource iTransportSource : this.sourceToUpdateList) {
                this.remove1(iTransportSource);
            }
            this.sourceToUpdateList.clear();
        }
        if (!this.delete.isEmpty()) {
            for (ITransportSource iTransportSource : this.delete) {
                this.removeTile(iTransportSource);
            }
            this.delete.clear();
        }
        try {
            for (TransportTick transportTick : this.senderPath) {
                LinkedList<Path> removePath;
                List list;
                Tuple<List<Path>, LinkedList<ITransportConductor>> tuple;
                ITransportSource entry;
                if (((ITransportSource)transportTick.getSource()).getValidReceivers().isEmpty() || ((ITransportSource)transportTick.getSource()).getTiles().isEmpty() || ((ITransportSource)transportTick.getSource()).getTileEntity().m_58901_()) {
                    this.delete.add((ITransportSource)transportTick.getSource());
                    continue;
                }
                if (this.world.m_46467_() % 2L == 0L && ((ITransportSource)transportTick.getSource()).isItem() && (entry = (ITransportSource)transportTick.getSource()) != null) {
                    if (transportTick.getEnergyItemPaths() == null) {
                        tuple = this.discover(entry);
                        list = (List)tuple.m_14418_();
                        removePath = new LinkedList<Path>();
                        for (Path transportPaths : list) {
                            if (transportPaths.end == null || transportPaths.first == null || transportPaths.first == transportPaths.end) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.target.isSink()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.first.isOutput() || transportPaths.end.isOutput()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.first.isInput() && !transportPaths.first.isOutput()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.first.isItem() || !transportPaths.end.isItem()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!transportPaths.end.isInput() && !transportPaths.end.isOutput()) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            if (!(((ITransportSource)transportTick.getSource()).getHandler(transportPaths.firstSide) instanceof IItemHandler)) {
                                removePath.add(transportPaths);
                                continue;
                            }
                            transportPaths.target.getEnergyTickList().add(((ITransportSource)transportTick.getSource()).hashCode());
                        }
                        list.removeAll(removePath);
                        transportTick.setItemList(list);
                        transportTick.setConductors((LinkedList)tuple.m_14419_());
                    }
                    if (!transportTick.getEnergyItemPaths().isEmpty()) {
                        this.emitTransportFrom(entry, transportTick.getEnergyItemPaths());
                    }
                }
                if (!((ITransportSource)transportTick.getSource()).isFluid() || (entry = (ITransportSource)transportTick.getSource()) == null) continue;
                if (transportTick.getEnergyFluidPaths() == null) {
                    tuple = this.discover(entry);
                    list = (List)tuple.m_14418_();
                    removePath = new LinkedList();
                    for (Path transportPaths : list) {
                        if (transportPaths.end == null || transportPaths.first == null || transportPaths.first == transportPaths.end) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.first.isOutput() || transportPaths.end.isOutput()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.first.isInput() && !transportPaths.first.isOutput()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.end.isInput() && !transportPaths.end.isOutput()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!transportPaths.target.isFluidSink()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (transportPaths.first.isItem() || transportPaths.end.isItem()) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        if (!(((ITransportSource)transportTick.getSource()).getHandler(transportPaths.firstSide) instanceof IFluidHandler)) {
                            removePath.add(transportPaths);
                            continue;
                        }
                        transportPaths.target.getEnergyTickList().add(((ITransportSource)transportTick.getSource()).hashCode());
                    }
                    list.removeAll(removePath);
                    transportTick.setFluidList(list);
                    transportTick.setConductors((LinkedList)tuple.m_14419_());
                }
                if (transportTick.getEnergyFluidPaths().isEmpty()) continue;
                this.emitTransportFluidFrom(entry, transportTick.getEnergyFluidPaths());
            }
        }
        catch (Exception exception) {
            System.out.println("IUERROR:" + exception.getMessage());
        }
        this.tick = (byte)(this.tick + 1);
    }

    public void emitTransportFluidFrom(ITransportSource<FluidStack, IFluidHandler> TransportSource, List<Path> TransportPaths) {
        for (Path TransportPath : TransportPaths) {
            TransportItem<FluidStack> transportItem = TransportSource.getOffered(1, TransportPath.firstSide);
            List<FluidStack> list = transportItem.getList();
            if (list.isEmpty()) break;
            if (TransportPath.end.getMax(this.tick) == 0 || TransportPath.first.getMax(this.tick) == 0) continue;
            IFluidHandler handler = TransportPath.getFluidHandler();
            for (FluidStack fluidStack : list) {
                if (!this.canInsertOrExtract(TransportPath.first, fluidStack, TransportPath.firstSide.m_122424_()) || !this.canInsertOrExtract(TransportPath.end, fluidStack, TransportPath.targetDirection.m_122424_()) || fluidStack.getAmount() <= 0) continue;
                int amount = handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                amount = Math.min(amount, Math.min(TransportPath.first.getMax(this.tick), TransportPath.end.getMax(this.tick)));
                fluidStack = fluidStack.copy();
                fluidStack.setAmount(amount);
                if (amount <= 0) continue;
                handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                TransportPath.first.setMax(amount);
                TransportPath.end.setMax(amount);
                TransportSource.draw(fluidStack, amount, TransportPath.firstSide);
            }
        }
    }

    public ITransportTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesITransportTileMap.get(pos);
    }

    public void onTileEntityRemoved(ITransportAcceptor par1) {
        this.onTileEntityAdded(par1);
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesITransportTileMap.clear();
    }
}

