/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.DataBlock;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.IDeposits;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.items.energy.ItemHammer;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class BlockDeposits2<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag,
SimpleWaterloggedBlock,
IDeposits {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape Deposits = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.2, (double)1.0);
    Map<Integer, List<String>> mapInf = new HashMap<Integer, List<String>>();

    public BlockDeposits2(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_155954_(3.0f).m_60955_().m_155956_(5.0f).m_60918_(SoundType.f_56742_).m_60999_(), elements, element, dataBlock);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BlockTagsProvider.list.add(this);
    }

    @Override
    public List<String> getInformationFromMeta() {
        int meta = ((ISubEnum)this.getElement()).getId();
        List<String> inf = this.mapInf.get(meta);
        if (inf == null) {
            VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
            ArrayList<String> stringList = new ArrayList<String>();
            String s = Localization.translate("deposists.jei1") + (vein.getHeavyOre() != null ? new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1).m_41611_().getString() : new ItemStack((ItemLike)vein.getOres().get(0).getBlock().m_60734_(), 1).m_41611_().getString());
            stringList.add(s);
            if (vein.getHeavyOre() != null) {
                String s1 = new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1).m_41611_().getString() + " 50%";
                stringList.add(s1);
                for (int i = 0; i < vein.getOres().size(); ++i) {
                    ChanceOre chanceOre = vein.getOres().get(i);
                    String s2 = new ItemStack((ItemLike)chanceOre.getBlock().m_60734_(), 1).m_41611_().getString() + " " + chanceOre.getChance() + "%";
                    stringList.add(s2);
                }
            } else {
                for (int i = 0; i < vein.getOres().size(); ++i) {
                    ChanceOre chanceOre = vein.getOres().get(i);
                    String s2 = new ItemStack((ItemLike)chanceOre.getBlock().m_60734_(), 1).m_41611_().getString() + " " + chanceOre.getChance() + "%";
                    stringList.add(s2);
                }
            }
            this.mapInf.put(meta, stringList);
            return stringList;
        }
        return inf;
    }

    public static boolean isFree(BlockState p_53242_) {
        Material material = p_53242_.m_60767_();
        return p_53242_.m_60795_() || p_53242_.m_204336_(BlockTags.f_13076_) || material.m_76332_() || material.m_76336_();
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    public BlockState m_7417_(BlockState p_154530_, Direction p_154531_, BlockState p_154532_, LevelAccessor p_154533_, BlockPos p_154534_, BlockPos p_154535_) {
        BlockState blockstate = super.m_7417_(p_154530_, p_154531_, p_154532_, p_154533_, p_154534_, p_154535_);
        p_154533_.m_186460_(p_154534_, (Block)this, this.getDelayAfterPlace());
        FluidState fluidState = p_154533_.m_6425_(p_154534_);
        if (!blockstate.m_60795_() && fluidState.m_76152_() == Fluids.f_76193_) {
            p_154533_.m_186469_(p_154534_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_154533_));
        }
        return blockstate;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        int meta = this.getMetaFromState(pState);
        VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
        if (vein.getHeavyOre() == null) {
            ChanceOre block = vein.getOres().get(0);
            return new ItemStack((ItemLike)block.getBlock().m_60734_(), 1);
        }
        return new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1);
    }

    @Override
    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        ItemStack tool = (ItemStack)p_60538_.m_78970_(LootContextParams.f_81463_);
        BlockPos pos = new BlockPos((Vec3)p_60538_.m_78970_(LootContextParams.f_81460_));
        Object drops = NonNullList.m_122779_();
        drops = this.getDrops((Level)p_60538_.m_78962_(), pos, p_60537_, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool), tool);
        return drops;
    }

    public List<ItemStack> getDrops(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int fortune, ItemStack tool) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (tool.m_41720_() instanceof ItemHammer) {
            int meta = this.getMetaFromState(state);
            VeinType vein = WorldBaseGen.veinTypes.get(16 + meta);
            if (vein.getHeavyOre() == null) {
                ChanceOre block = vein.getOres().get(0);
                drops.add(new ItemStack((ItemLike)block.getBlock().m_60734_(), 1));
            } else {
                List<BaseMachineRecipe> recipe_list;
                IBaseRecipe recipe = Recipes.recipes.getRecipe("handlerho");
                MachineRecipe output = Recipes.recipes.getRecipeMachineRecipeOutput(recipe, recipe_list = Recipes.recipes.getRecipeList("handlerho"), false, Collections.singletonList(new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1)));
                if (output != null) {
                    int[] col = new int[output.getRecipe().output.items.size()];
                    for (int i = 0; i < col.length; ++i) {
                        col[i] = output.getRecipe().output.metadata.m_128451_("input" + i);
                        col[i] = Math.min(col[i], 95);
                    }
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < col.length; ++i) {
                        RandomSource rand = world.f_46441_;
                        if (rand.m_188503_(100) >= col[i]) continue;
                        stacks.add(output.getRecipe().output.items.get(i));
                    }
                    for (ItemStack stack : stacks) {
                        BaseMachineRecipe rec1 = Recipes.recipes.getRecipeOutput("macerator", false, stack);
                        if (rec1 != null) {
                            ItemStack stack1 = rec1.output.items.get(0).m_41777_();
                            stack1.m_41764_(1);
                            drops.add(stack1);
                            continue;
                        }
                        drops.add(stack.m_41777_());
                    }
                }
            }
        } else {
            int meta = this.getMetaFromState(state);
            VeinType vein = WorldBaseGen.veinTypes.get(16 + meta);
            if (vein.getHeavyOre() == null) {
                ChanceOre block = vein.getOres().get(0);
                drops.add(new ItemStack((ItemLike)block.getBlock().m_60734_(), 1));
            } else {
                drops.add(new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1));
            }
        }
        return drops;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        int meta = this.getMetaFromState(state);
        VeinType vein = WorldBaseGen.veinTypes.get(32 + meta);
        if (vein.getHeavyOre() == null) {
            ChanceOre block = vein.getOres().get(0);
            return new ItemStack((ItemLike)block.getBlock().m_60734_(), 1);
        }
        return new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED))) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return Fluids.f_76191_.m_76145_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_6044_(BlockGetter p_154505_, BlockPos p_154506_, BlockState p_154507_, Fluid p_154508_) {
        return false;
    }

    public boolean m_7361_(LevelAccessor p_154520_, BlockPos p_154521_, BlockState p_154522_, FluidState p_154523_) {
        return false;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        int levelEnchant = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
        return levelEnchant == 0;
    }

    public float m_7749_(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public boolean m_180643_(BlockState p_181242_, BlockGetter p_181243_, BlockPos p_181244_) {
        return false;
    }

    public boolean m_7420_(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    public boolean m_6104_(BlockState p_53972_, BlockState p_53973_, Direction p_53974_) {
        return true;
    }

    public boolean m_5946_(BlockState p_53035_, Fluid p_53036_) {
        return false;
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public void m_6807_(BlockState p_53233_, Level p_53234_, BlockPos p_53235_, BlockState p_53236_, boolean p_53237_) {
        p_53234_.m_186460_(p_53235_, (Block)this, this.getDelayAfterPlace());
    }

    public void m_213897_(BlockState p_221124_, ServerLevel p_221125_, BlockPos p_221126_, RandomSource p_221127_) {
        if (BlockDeposits2.isFree(p_221125_.m_8055_(p_221126_.m_7495_())) && p_221126_.m_123342_() >= p_221125_.m_141937_()) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)p_221125_, (BlockPos)p_221126_, (BlockState)p_221124_);
            this.falling(fallingblockentity);
        }
    }

    public void m_214162_(BlockState p_221129_, Level p_221130_, BlockPos p_221131_, RandomSource p_221132_) {
        BlockPos blockpos;
        if (p_221132_.m_188503_(16) == 0 && BlockDeposits2.isFree(p_221130_.m_8055_(blockpos = p_221131_.m_7495_()))) {
            double d0 = (double)p_221131_.m_123341_() + p_221132_.m_188500_();
            double d1 = (double)p_221131_.m_123342_() - 0.05;
            double d2 = (double)p_221131_.m_123343_() + p_221132_.m_188500_();
            p_221130_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, p_221129_), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void falling(FallingBlockEntity p_53206_) {
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        worldIn.m_186460_(pos, (Block)this, 3);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Deposits;
    }

    public VoxelShape m_5939_(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Deposits;
    }

    public VoxelShape m_5909_(BlockState p_60479_, BlockGetter p_60480_, BlockPos p_60481_, CollisionContext p_60482_) {
        return Deposits;
    }

    public VoxelShape m_6079_(BlockState p_60547_, BlockGetter p_60548_, BlockPos p_60549_) {
        return super.m_6079_(p_60547_, p_60548_, p_60549_);
    }

    @Override
    public ModelResourceLocation registerModels() {
        return new ModelResourceLocation(this.modName + ":" + ((ISubEnum)this.getElement()).getMainPath(), "type=" + ((ISubEnum)this.getElement()).getName());
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.f_49792_.m_61090_()).m_60734_()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"pickaxe", (Object)0);
    }

    public static enum Type implements ISubEnum
    {
        deposits_fergusonite(0),
        deposits_appatite(1),
        deposits_crystal(2),
        deposits_coal(3);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "deposits2";
        }

        @Override
        public boolean canAddToTab() {
            return false;
        }

        public int getLight() {
            return 0;
        }
    }
}

