/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.pollution.IPollutionMechanism;
import com.denfop.api.pollution.PollutionAirLoadEvent;
import com.denfop.api.pollution.PollutionAirUnLoadEvent;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AirPollutionComponent
extends AbstractComponent
implements IPollutionMechanism {
    private double pollution;
    private double default_pollution;
    private ChunkPos chunkPos;
    private double percent = 1.0;

    public AirPollutionComponent(TileEntityInventory parent, double pollution) {
        super(parent);
        this.pollution = pollution;
        this.default_pollution = pollution;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnCustomPollutionParticle(Level world, double x, double y, double z, double windSpeed) {
        if (world != null) {
            Vec3 windDirection = WindSystem.windSystem.getWindSide().getDirectionVector();
            double motionX = windDirection.f_82479_ * windSpeed * 0.5;
            double motionY = 0.01;
            double motionZ = windDirection.f_82481_ * windSpeed * 0.5;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, motionX, motionY, motionZ);
        }
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tagCompound = super.writeToNbt();
        tagCompound.m_128347_("percent", this.percent);
        return tagCompound;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.percent = nbt.m_128459_("percent");
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return this.percent != 1.0;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        if (this.percent == 0.0) {
            this.percent = 0.5;
            return new ItemStack((ItemLike)IUItem.antiairpollution1.getItem());
        }
        this.percent = 1.0;
        return new ItemStack((ItemLike)IUItem.antiairpollution.getItem());
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.percent == 0.0) {
            ret.add(new ItemStack((ItemLike)IUItem.antiairpollution1.getItem()));
            ret.add(new ItemStack((ItemLike)IUItem.antiairpollution.getItem()));
        } else if (this.percent == 0.5) {
            ret.add(new ItemStack((ItemLike)IUItem.antiairpollution.getItem()));
        }
        return ret;
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        if (!this.parent.m_58904_().f_46443_) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (this.percent == 1.0 && item == IUItem.antiairpollution.getItem()) {
                stack.m_41774_(1);
                this.percent = 0.5;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            } else if (this.percent == 0.5 && item == IUItem.antiairpollution1.getItem()) {
                stack.m_41774_(1);
                this.percent = 0.0;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            }
        }
        return super.onBlockActivated(player, hand);
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeDouble(this.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.pollution = is.readDouble();
        this.default_pollution = is.readDouble();
        this.percent = is.readDouble();
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.parent.getActive()) {
            // empty if block
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.parent.getActive()) {
            this.setPollution(this.default_pollution * this.percent);
        } else {
            this.setPollution(0.0);
        }
    }

    @Override
    public void onLoaded() {
        if (!this.parent.m_58904_().f_46443_ && this.parent.m_58904_().m_46472_() == Level.f_46428_) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirLoadEvent(this.parent.m_58904_(), this));
        }
    }

    public double getDefault_pollution() {
        return this.default_pollution;
    }

    @Override
    public void onUnloaded() {
        if (!this.parent.m_58904_().f_46443_ && this.parent.m_58904_().m_46472_() == Level.f_46428_) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirUnLoadEvent(this.parent.m_58904_(), this));
        }
    }

    @Override
    public ChunkPos getChunkPos() {
        if (this.chunkPos == null) {
            this.chunkPos = new ChunkPos(this.getParent().m_58899_());
        }
        return this.chunkPos;
    }

    @Override
    public double getPollution() {
        return this.pollution;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.parent != null && this.parent.getWorld() == null) {
            tooltip.add(Localization.translate("iu.pollution.air.info") + " " + String.format("%.2f", this.default_pollution) + Localization.translate("iu.pollution.air.info1"));
        }
    }

    public void setPollution(double pollution) {
        if (this.pollution != pollution * this.percent && !this.parent.m_58904_().f_46443_ && this.parent.m_58904_().m_46472_() == Level.f_46428_) {
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirUnLoadEvent(this.parent.m_58904_(), this));
            this.pollution = pollution * this.percent;
            MinecraftForge.EVENT_BUS.post((Event)new PollutionAirLoadEvent(this.parent.m_58904_(), this));
        }
    }
}

