/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.Localization;
import com.denfop.componets.AbstractComponent;
import com.denfop.invslot.InvSlot;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class Fluids
extends AbstractComponent {
    public static final Fluid LAVA = net.minecraft.world.level.material.Fluids.f_76195_;
    public static final Fluid WATER = net.minecraft.world.level.material.Fluids.f_76193_;
    public static final Fluid EMPTY = net.minecraft.world.level.material.Fluids.f_76191_;
    protected final List<InternalFluidTank> managedTanks = new ArrayList<InternalFluidTank>();
    protected final List<Supplier<? extends Collection<InternalFluidTank>>> unmanagedTanks = new ArrayList<Supplier<? extends Collection<InternalFluidTank>>>();

    public Fluids(TileEntityInventory parent) {
        super(parent);
    }

    public static Predicate<Fluid> fluidPredicate(Fluid ... fluids) {
        Collection<Fluid> acceptedFluids = fluids.length > 10 ? new HashSet<Fluid>(Arrays.asList(fluids)) : Arrays.asList(fluids);
        return acceptedFluids::contains;
    }

    public static Predicate<Fluid> fluidPredicate(List<Fluid> fluids) {
        Collection<Object> acceptedFluids = fluids != null ? (fluids.size() > 10 ? new HashSet<Fluid>(fluids) : fluids) : new ArrayList();
        return acceptedFluids::contains;
    }

    public InternalFluidTank addTankInsert(String name, int capacity) {
        return this.addTankInsert(name, capacity, (Predicate<Fluid>)Predicates.alwaysTrue());
    }

    public InternalFluidTank addTankInsert(String name, int capacity, Predicate<Fluid> acceptedFluids) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.INPUT, acceptedFluids);
    }

    public InternalFluidTank addTankExtract(String name, int capacity) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.OUTPUT, (Predicate<Fluid>)Predicates.alwaysTrue());
    }

    public InternalFluidTank addTankExtract(String name, int capacity, Predicate<Fluid> acceptedFluids) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.OUTPUT, acceptedFluids);
    }

    public InternalFluidTank addTank(String name, int capacity) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.INPUT_OUTPUT);
    }

    public InternalFluidTank addTank(String name, int capacity, InvSlot.TypeItemSlot typeItemSlot) {
        return this.addTank(name, capacity, typeItemSlot, (Predicate<Fluid>)Predicates.alwaysTrue());
    }

    public InternalFluidTank addTank(String name, int capacity, Predicate<Fluid> acceptedFluids) {
        return this.addTank(name, capacity, InvSlot.TypeItemSlot.INPUT_OUTPUT, acceptedFluids);
    }

    public InternalFluidTank addTank(String name, int capacity, Predicate<Fluid> acceptedFluids, InvSlot.TypeItemSlot slot) {
        return this.addTank(name, capacity, slot, acceptedFluids);
    }

    public InternalFluidTank addTank(String name, int capacity, InvSlot.TypeItemSlot typeItemSlot, Predicate<Fluid> acceptedFluids) {
        return this.addTank(name, capacity, typeItemSlot.isInput() ? ModUtils.allFacings : Collections.emptySet(), typeItemSlot.isOutput() ? ModUtils.allFacings : Collections.emptySet(), acceptedFluids, typeItemSlot);
    }

    public InternalFluidTank addTank(String name, int capacity, Collection<Direction> inputSides, Collection<Direction> outputSides, Predicate<Fluid> acceptedFluids, InvSlot.TypeItemSlot typeItemSlot) {
        return this.addTank(new InternalFluidTank(name, inputSides, outputSides, acceptedFluids, capacity, typeItemSlot));
    }

    public InternalFluidTank addTank(InternalFluidTank tank) {
        this.managedTanks.add(tank);
        return tank;
    }

    public void addUnmanagedTanks(InternalFluidTank tank) {
        this.unmanagedTanks.add((Supplier<? extends Collection<InternalFluidTank>>)Suppliers.ofInstance(Collections.singleton(tank)));
    }

    public void addUnmanagedTanks(Collection<InternalFluidTank> tanks) {
        this.addUnmanagedTankHook((Supplier<? extends Collection<InternalFluidTank>>)Suppliers.ofInstance(tanks));
    }

    public void addUnmanagedTankHook(Supplier<? extends Collection<InternalFluidTank>> suppl) {
        this.unmanagedTanks.add(suppl);
    }

    public void changeConnectivity(InternalFluidTank tank, InvSlot.TypeItemSlot typeItemSlot) {
        this.changeConnectivity(tank, typeItemSlot.isInput() ? ModUtils.allFacings : Collections.emptySet(), typeItemSlot.isOutput() ? ModUtils.allFacings : Collections.emptySet());
    }

    public void changeConnectivity(InternalFluidTank tank, Collection<Direction> inputSides, Collection<Direction> outputSides) {
        assert (this.managedTanks.contains((Object)tank));
        tank.inputSides = new ArrayList<Direction>(inputSides);
        tank.outputSides = new ArrayList<Direction>(outputSides);
    }

    public FluidTank getFluidTank(String name) {
        InternalFluidTank tank;
        Iterator<InternalFluidTank> var2 = this.getAllTanks().iterator();
        do {
            if (!var2.hasNext()) {
                throw new IllegalArgumentException("Unable to find tank: " + name);
            }
            tank = var2.next();
        } while (!tank.identifier.equals(name));
        return tank;
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        for (InternalFluidTank tank : this.managedTanks) {
            CompoundTag subTag = new CompoundTag();
            subTag = tank.writeToNBT(subTag);
            try {
                EncoderHandler.encode(buffer, subTag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        for (InternalFluidTank tank : this.managedTanks) {
            CompoundTag subTag = new CompoundTag();
            subTag = tank.writeToNBT(subTag);
            try {
                EncoderHandler.encode(buffer, subTag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        for (InternalFluidTank tank : this.managedTanks) {
            tank.readFromNBT((CompoundTag)DecoderHandler.decode(is));
        }
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        for (InternalFluidTank tank : this.managedTanks) {
            if (!nbt.m_128425_(tank.identifier, 10)) continue;
            tank.readFromNBT(nbt.m_128469_(tank.identifier));
        }
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag nbt = new CompoundTag();
        for (InternalFluidTank tank : this.managedTanks) {
            CompoundTag subTag = new CompoundTag();
            subTag = tank.writeToNBT(subTag);
            nbt.m_128365_(tank.identifier, (Tag)subTag);
        }
        return nbt;
    }

    @Override
    public Collection<? extends Capability<?>> getProvidedCapabilities(Direction side) {
        return Collections.singleton(ForgeCapabilities.FLUID_HANDLER);
    }

    @Override
    public <T> T getCapability(Capability<T> cap, Direction side) {
        return (T)(cap == ForgeCapabilities.FLUID_HANDLER ? new FluidHandler(side) : super.getCapability(cap, side));
    }

    public List<InternalFluidTank> getManagedTanks() {
        return this.managedTanks;
    }

    public Iterable<InternalFluidTank> getAllTanks() {
        if (this.unmanagedTanks.isEmpty()) {
            return this.managedTanks;
        }
        ArrayList<InternalFluidTank> tanks = new ArrayList<InternalFluidTank>();
        tanks.addAll(this.managedTanks);
        for (Supplier<? extends Collection<InternalFluidTank>> unmanagedTank : this.unmanagedTanks) {
            tanks.addAll((Collection)unmanagedTank.get());
        }
        return tanks;
    }

    public static class InternalFluidTank
    extends FluidTank {
        protected final String identifier;
        List<String> fluidList = new ArrayList<String>();
        private InvSlot.TypeItemSlot typeItemSlot;
        private Predicate<Fluid> acceptedFluids;
        private List<Direction> inputSides;
        private List<Direction> outputSides;
        private boolean canAccept = true;

        protected InternalFluidTank(String identifier, Collection<Direction> inputSides, Collection<Direction> outputSides, Predicate<Fluid> acceptedFluids, int capacity, InvSlot.TypeItemSlot typeItemSlot) {
            super(capacity);
            this.identifier = identifier;
            this.acceptedFluids = acceptedFluids;
            this.inputSides = new ArrayList<Direction>(inputSides);
            this.outputSides = new ArrayList<Direction>(outputSides);
            this.typeItemSlot = typeItemSlot;
            List<Fluid> fluidList1 = ForgeRegistries.FLUIDS.getValues().stream().filter(acceptedFluids).toList();
            for (Fluid fluid1 : fluidList1) {
                this.fluidList.add(Localization.translate(fluid1.getFluidType().getDescriptionId()));
            }
        }

        public CustomPacketBuffer writePacket() {
            CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
            this.fluid.writeToPacket((FriendlyByteBuf)packetBuffer);
            return packetBuffer;
        }

        public void readPacket(CustomPacketBuffer packetBuffer) {
            this.fluid = FluidStack.readFromPacket((FriendlyByteBuf)packetBuffer);
        }

        public List<String> getFluidList() {
            return this.fluidList;
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
        }

        public void setTypeItemSlot(InvSlot.TypeItemSlot typeItemSlot) {
            this.typeItemSlot = typeItemSlot;
            if (this.inputSides != null && this.outputSides != null) {
                this.inputSides.clear();
                this.outputSides.clear();
                this.inputSides.addAll(typeItemSlot.isInput() ? ModUtils.allFacings : Collections.emptySet());
                this.outputSides.addAll(typeItemSlot.isOutput() ? ModUtils.allFacings : Collections.emptySet());
            }
        }

        public boolean isInput() {
            return this.typeItemSlot.isInput();
        }

        public boolean isOutput() {
            return this.typeItemSlot.isOutput();
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.acceptsFluid(stack.getFluid());
        }

        public boolean acceptsFluid(Fluid fluid) {
            return this.acceptedFluids.apply((Object)fluid);
        }

        public Predicate<Fluid> getAcceptedFluids() {
            return this.acceptedFluids;
        }

        public void setAcceptedFluids(Predicate<Fluid> acceptedFluids) {
            this.acceptedFluids = acceptedFluids;
            List<Fluid> fluidList1 = ForgeRegistries.FLUIDS.getValues().stream().filter(acceptedFluids).toList();
            this.fluidList.clear();
            for (Fluid fluid1 : fluidList1) {
                this.fluidList.add(Localization.translate(fluid1.getFluidType().getDescriptionId()));
            }
        }

        public boolean canFill(Direction side) {
            return this.canAccept && this.inputSides.contains(side);
        }

        public boolean canDrain(Direction side) {
            return this.outputSides.contains(side);
        }

        public void setCanAccept(boolean b) {
            this.canAccept = b;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private final Direction side;

        FluidHandler(Direction side) {
            this.side = side;
        }

        public int getTanks() {
            return Fluids.this.managedTanks.size();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return Fluids.this.managedTanks.get(tank).getFluid();
        }

        public int getTankCapacity(int tank) {
            return Fluids.this.managedTanks.get(tank).getTankCapacity(0);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return Fluids.this.managedTanks.get(tank).acceptsFluid(stack.getFluid());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource != null && resource.getAmount() > 0) {
                int total = 0;
                FluidStack missing = resource.copy();
                for (InternalFluidTank tank : Fluids.this.getAllTanks()) {
                    if (!tank.canFill(this.side)) continue;
                    missing.setAmount(resource.getAmount() - (total += tank.fill(missing, action)));
                    if (missing.getAmount() > 0) continue;
                    break;
                }
                return total;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource != null && resource.getAmount() > 0) {
                FluidStack ret = new FluidStack(resource.getFluid(), 0);
                for (InternalFluidTank tank : Fluids.this.getAllTanks()) {
                    FluidStack add;
                    FluidStack inTank;
                    if (!tank.canDrain(this.side) || (inTank = tank.getFluid()).isEmpty() || inTank.getFluid() != resource.getFluid() || (add = tank.drain(resource.getAmount() - ret.getAmount(), action)).isEmpty()) continue;
                    assert (add.getFluid() == resource.getFluid());
                    ret.setAmount(ret.getAmount() + add.getAmount());
                    if (ret.getAmount() < resource.getAmount()) continue;
                    break;
                }
                return ret.getAmount() == 0 ? FluidStack.EMPTY : ret;
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            Iterable<InternalFluidTank> tanks = Fluids.this.getAllTanks();
            for (InternalFluidTank tank : tanks) {
                FluidStack stack;
                if (!tank.canDrain(this.side) || (stack = tank.drain(maxDrain, action)).isEmpty()) continue;
                stack.setAmount(maxDrain);
                return this.drain(stack, action);
            }
            return FluidStack.EMPTY;
        }
    }
}

