/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events.client;

import com.denfop.gui.GuiIU;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GlobalRenderManager {
    private static final Map<String, Map<BlockPos, Function<RenderLevelStageEvent, Void>>> globalRenders = new HashMap<String, Map<BlockPos, Function<RenderLevelStageEvent, Void>>>();
    public static long tick = 0L;

    public GlobalRenderManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addRender(Level world, BlockPos pos, Function<RenderLevelStageEvent, Void> globalRender) {
        String dimension = world.m_46472_().m_135782_().toString();
        globalRenders.computeIfAbsent(dimension, k -> new HashMap()).putIfAbsent(pos, globalRender);
    }

    public static void removeRender(Level world, BlockPos pos) {
        String dimension = world.m_46472_().m_135782_().toString();
        globalRenders.computeIfPresent(dimension, (k, v) -> {
            v.remove(pos);
            return v.isEmpty() ? null : v;
        });
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        ((Map)globalRenders.getOrDefault(((Level)event.getLevel()).m_46472_().toString(), new HashMap())).clear();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onWorldTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player.m_9236_().f_46443_ && tick != event.player.m_9236_().m_46467_()) {
            tick = event.player.m_9236_().m_46467_();
            Screen guiScreen = Minecraft.m_91087_().f_91080_;
            if (guiScreen instanceof GuiIU) {
                for (double ticks = 4.0; ticks > 0.0; ticks -= 1.0) {
                    ((GuiIU)guiScreen).updateTickInterface();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        try {
            for (Map.Entry<String, Map<BlockPos, Function<RenderLevelStageEvent, Void>>> entry : globalRenders.entrySet()) {
                if (!Objects.equals(entry.getKey(), mc.f_91073_.m_46472_().m_135782_().toString())) continue;
                PoseStack poseStack = event.getPoseStack();
                Vec3 camera = event.getCamera().m_90583_();
                double x = camera.f_82479_;
                double y = camera.f_82480_;
                double z = camera.f_82481_;
                double dopY = 0.0;
                poseStack.m_85836_();
                poseStack.m_85837_(-x, -y, -z);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (Function<RenderLevelStageEvent, Void> function : entry.getValue().values()) {
                    function.apply(event);
                }
                poseStack.m_85849_();
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

