/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.CustomButton;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.api.upgrade.UpgradeModificator;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.container.ContainerAntiUpgrade;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.base.TileAntiUpgradeBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiAntiUpgradeBlock<T extends ContainerAntiUpgrade>
extends GuiIU<ContainerAntiUpgrade> {
    public final ContainerAntiUpgrade container;

    public GuiAntiUpgradeBlock(ContainerAntiUpgrade container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.addComponent(new GuiComponent(this, 3, 14, EnumTypeComponent.SOUND_BUTTON, new com.denfop.api.gui.Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.addElement(new CustomButton(this, 8, 30, 50, 20, (TileEntityBlock)((Object)container1.base), 0, Localization.translate("button.need_mod")));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.anti_modification.info"));
            List<String> compatibleUpgrades = ListInformationUtils.anti_upgrade_block;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.f_96543_ - this.f_97726_) / 2;
        int yMin = (this.f_96544_ - this.f_97727_) / 2;
        int x = i - xMin;
        int y = j - yMin;
        for (int m = 0; m < 4; ++m) {
            if (x < 70 || x > 87 || y < 10 + 18 * m || y >= 27 + 18 * m) continue;
            new PacketUpdateServerTile((BlockEntity)this.container.base, m + 1);
        }
        List<UpgradeModificator> list1 = UpgradeSystem.system.getListModifications(((TileAntiUpgradeBlock)this.container.base).input.get(0));
        if (x >= 149 && x <= 167 && y >= 10 && y < 27 && !list1.isEmpty()) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 5.0);
        }
        if (x >= 149 && x <= 167 && y >= 28 && y < 45 && list1.size() > 1) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 6.0);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiantiupgrade.png");
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
        String tooltip2 = ModUtils.getString(Math.min(((TileAntiUpgradeBlock)this.container.base).energy.getEnergy(), ((TileAntiUpgradeBlock)this.container.base).energy.getCapacity())) + "/" + ModUtils.getString(((TileAntiUpgradeBlock)this.container.base).energy.getCapacity()) + " EF";
        ((Area)new AdvArea(this, 26, 56, 37, 71).withTooltip(tooltip2)).drawForeground(poseStack, mouseX, mouseY);
    }

    @Override
    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
        String name = Localization.translate(((TileAntiUpgradeBlock)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.f_97726_ / 2, 1, Component.m_130674_((String)name), 0x404040, false);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        int xoffset = (this.f_96543_ - this.f_97726_) / 2;
        int yoffset = (this.f_96544_ - this.f_97727_) / 2;
        GuiAntiUpgradeBlock.bindTexture(this.getTexture());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int progress = Math.min(31 * ((TileAntiUpgradeBlock)this.container.base).progress / 100, 31);
        GuiAntiUpgradeBlock.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        GuiAntiUpgradeBlock.bindTexture(this.getTexture());
        int chargeLevel = (int)(14.0f * ((TileAntiUpgradeBlock)this.container.base).getChargeLevel());
        if (chargeLevel > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 25, yoffset + 57 + 14 - chargeLevel, 176, 14 - chargeLevel, 14, chargeLevel);
        }
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 136, yoffset + 58 - progress, 176, 50 - progress + 31, 5, progress);
        }
        if (!((TileAntiUpgradeBlock)this.container.base).input.isEmpty()) {
            int i;
            List<ItemStack> list = UpgradeSystem.system.getListStack(((TileAntiUpgradeBlock)this.container.base).input.get(0));
            List<UpgradeModificator> list1 = UpgradeSystem.system.getListModifications(((TileAntiUpgradeBlock)this.container.base).input.get(0));
            for (i = 0; i < list1.size(); ++i) {
                this.drawTexturedModalRect(poseStack, xoffset + 149, yoffset + 10 + 18 * i, 200, 88, 18, 18);
            }
            i = 0;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (((TileAntiUpgradeBlock)this.container.base).index <= 3) {
                this.drawTexturedModalRect(poseStack, xoffset + 70, yoffset + 8 + 18 * ((TileAntiUpgradeBlock)this.container.base).index, 200, 11 + 18 * ((TileAntiUpgradeBlock)this.container.base).index, 18, 18);
            } else {
                this.drawTexturedModalRect(poseStack, xoffset + 149, yoffset + 10 + 18 * (((TileAntiUpgradeBlock)this.container.base).index - 4), 200, 28, 18, 18);
            }
            for (ItemStack stack : list) {
                if (stack.m_41619_()) {
                    ++i;
                    continue;
                }
                new ItemStackImage(this, 71, 9 + i * 18, () -> stack).drawBackground(poseStack, this.guiLeft, this.guiTop);
                ++i;
            }
        }
    }
}

