/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.GuiElement;
import com.denfop.container.ContainerApiary;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.bee.TileEntityApiary;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiApiary<T extends ContainerApiary>
extends GuiIU<ContainerApiary> {
    public ContainerApiary container;

    public GuiApiary(ContainerApiary container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.f_97727_ = 207;
        this.addElement((GuiElement<?>)new AdvArea(this, 10, 21, 21, 69).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).food))));
        this.addElement((GuiElement<?>)new AdvArea(this, 154, 21, 165, 69).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).royalJelly))));
        this.addElement((GuiElement<?>)new AdvArea(this, 37, 22, 50, 32).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).workers))));
        this.addElement((GuiElement<?>)new AdvArea(this, 37, 35, 50, 49).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).doctors))));
        this.addElement((GuiElement<?>)new AdvArea(this, 37, 51, 50, 64).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).builders))));
        this.addElement((GuiElement<?>)new AdvArea(this, 37, 67, 50, 80).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).attacks))));
        this.addElement((GuiElement<?>)new AdvArea(this, 37, 83, 50, 94).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).ill))));
        this.addElement((GuiElement<?>)new AdvArea(this, 37, 97, 50, 109).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((TileEntityApiary)container1.base).birth) + "/" + ModUtils.getString(((TileEntityApiary)container1.base).death))));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.bee.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 21; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.bee.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 160, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiapiary.png");
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        switch (((TileEntityApiary)this.container.base).task) {
            case 0: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 24, 249, 1, 6, 6);
                break;
            }
            case 1: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 71, 249, 1, 6, 6);
                break;
            }
            case 2: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 39, 249, 1, 6, 6);
                break;
            }
            case 3: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 55, 249, 1, 6, 6);
            }
        }
        if (((TileEntityApiary)this.container.base).deathTask == 1) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 101, 249, 1, 6, 6);
        }
        if (((TileEntityApiary)this.container.base).illTask == 1) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 86, 249, 1, 6, 6);
        }
        int renderHeight = (int)(49.0 * ModUtils.limit(((TileEntityApiary)this.container.base).food / ((double)((TileEntityApiary)this.container.base).maxFood * 1.0), 0.0, 1.0));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 10, this.guiTop + 20 + 50 - renderHeight, 236, 50 - renderHeight, 12, renderHeight);
        renderHeight = (int)(49.0 * ModUtils.limit(((TileEntityApiary)this.container.base).royalJelly / ((double)((TileEntityApiary)this.container.base).maxJelly * 1.0), 0.0, 1.0));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 154, this.guiTop + 20 + 50 - renderHeight, 223, 50 - renderHeight, 12, renderHeight);
        GuiApiary.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }
}

