/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.bee.IBee;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ImageInterface;
import com.denfop.api.gui.ImageScreen;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.EnumTypeComponentSlot;
import com.denfop.container.ContainerBeeAnalyzer;
import com.denfop.gui.GuiIU;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.items.bee.ItemStackBeeAnalyzer;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiBeeAnalyzer<T extends ContainerBeeAnalyzer>
extends GuiIU<ContainerBeeAnalyzer> {
    private static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    private final String name;
    private int prevText;
    private float scaled;
    private int textIndex;

    public GuiBeeAnalyzer(ContainerBeeAnalyzer container, ItemStack itemStack1) {
        super(container);
        this.name = Localization.translate(itemStack1.m_41778_());
        this.f_97727_ = 232;
        this.componentList.clear();
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.DEFAULT)));
        this.componentList.add(this.slots);
        this.addElement(new ImageInterface(this, 0, 0, this.f_97726_, this.f_97727_));
        this.addElement(new ImageScreen(this, 30, 20, this.f_97726_ - 36, 124));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.bee.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 21; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.bee.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 160, mouseY - 10, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.f_96547_.m_92883_(poseStack, this.name, (float)((this.f_97726_ - this.getStringWidth(this.name)) / 2 - 10), 11.0f, 0);
        this.handleUpgradeTooltip(par1, par2);
        if (!((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).get(0).m_41619_() && ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genome == null) {
            ModUtils.nbt(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).get(0)).m_128379_("analyzed", true);
            ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genome = new Genome(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).get(0));
            ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).crop = ItemJarBees.getBee(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).get(0));
            ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).set();
            this.textIndex = 0;
        } else if (((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).get(0).m_41619_() && ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genome != null) {
            ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genome = null;
            ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).crop = null;
            ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).set();
            this.textIndex = 0;
        }
        if (((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genome != null) {
            String text = this.getInformationFromCrop();
            int canvasX = 34;
            int canvasY = 24;
            int canvasWidth = this.f_97726_ - 40;
            int canvasHeight = 116;
            float scale = (float)(2.0 / this.f_96541_.m_91268_().m_85449_());
            if (this.prevText != text.length()) {
                this.scaled = -1.0f;
                this.prevText = text.length();
            }
            if (this.scaled == -1.0f) {
                this.scaled = scale = this.adjustTextScale(text, canvasWidth, canvasHeight, scale, 0.8f);
            } else {
                scale = this.scaled;
            }
            if (((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).player.m_9236_().m_46467_() % 2L == 0L && this.textIndex < text.length()) {
                ++this.textIndex;
            }
            if (this.textIndex > text.length()) {
                this.textIndex = text.length();
            }
            String visibleText = text.substring(0, this.textIndex);
            this.drawTextInCanvas(poseStack, visibleText, canvasX, canvasY, canvasWidth, canvasHeight, scale * 1.0f);
        }
    }

    private String getInformationFromCrop() {
        IBee queen = ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).crop;
        Genome genome = ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genome;
        return Localization.translate("iu.bee_analyzer.name") + " " + Localization.translate("bee_" + queen.getName()) + "\n" + Localization.translate("iu.bee_analyzer.time_life") + " " + new Timer((int)((double)queen.getTickLifecycles() * ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).populationGenome / 20.0)).getDisplay() + "\n" + Localization.translate("iu.bee_analyzer.main_crop") + " " + Localization.translate("crop." + queen.getCropFlower().getName()) + "\n" + Localization.translate("iu.bee_analyzer.birth_rate") + " " + ModUtils.getString((double)queen.getOffspring() * ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).birthRateGenome) + "\n" + Localization.translate("iu.bee_analyzer.pest_crop") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).pestGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.daytime") + " " + (queen.isSun() || ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).sunGenome ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.bee_analyzer.nighttime") + " " + (queen.isNight() || ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).nightGenome ? Localization.translate("iu.space_yes") : Localization.translate("iu.space_no")) + "\n" + Localization.translate("iu.bee_analyzer.radius") + " " + ModUtils.getString(queen.getSizeTerritory().f_82291_ * ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).radiusGenome) + "x" + ModUtils.getString(queen.getSizeTerritory().f_82292_ * ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).radiusGenome) + "x" + ModUtils.getString(queen.getSizeTerritory().f_82293_ * ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).radiusGenome) + "\n" + Localization.translate("iu.bee_analyzer.increase_food") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).foodGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.increase_jelly") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).jellyGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.increase_getting_crop_percent") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).productGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.decrease_sicken") + " " + ModUtils.getString(Math.abs(((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).hardeningGenome - 1.0) * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.max_population") + " " + ModUtils.getString((double)queen.getMaxSwarm() * ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).swarmGenome) + "\n" + Localization.translate("iu.bee_analyzer.mortality_rate") + " " + ModUtils.getString(queen.getMaxMortalityRate() * ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).mortalityGenome * 100.0) + "%\n" + Localization.translate("iu.bee_analyzer.weather_resistance") + " " + (((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).weatherGenome == 0 ? Localization.translate("iu.space_no") : (((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).weatherGenome == 1 ? Localization.translate("iu.space_rain") : Localization.translate("iu.space_thunder"))) + "\n" + Localization.translate("iu.bee_analyzer.percent_genome_adaptive") + " " + Math.max(5, ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genomeAdaptive) + "%\n" + Localization.translate("iu.bee_analyzer.percent_genome_resistance") + " " + Math.max(5, ((ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)this.container).base).genomeResistance) + "%";
    }

    @Override
    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        GuiBeeAnalyzer.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

