/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.TankGauge;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerCokeOven;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.cokeoven.TileCokeOvenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class GuiCokeOven<T extends ContainerCokeOven>
extends GuiIU<ContainerCokeOven> {
    public final ContainerCokeOven container;
    public boolean highlightedMinus = false;
    public boolean highlightedPlus = false;

    public GuiCokeOven(ContainerCokeOven container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.f_97727_ = 182;
        this.addComponent(new GuiComponent(this, 155, 44, EnumTypeComponent.SOUND_BUTTON, new com.denfop.api.gui.Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.addElement((GuiElement<?>)new AdvArea(this, 108, 23, 150, 36).withTooltip("+1"));
        this.addElement((GuiElement<?>)new AdvArea(this, 34, 23, 47, 36).withTooltip("-1"));
        this.addElement(new AdvArea(this, 63, 76, 118, 89){

            @Override
            protected List<String> getToolTip() {
                if (((TileCokeOvenMain)GuiCokeOven.this.container.base).heat == null) {
                    return Collections.singletonList("0/0 \u00b0C");
                }
                HeatComponent component = ((TileCokeOvenMain)GuiCokeOven.this.container.base).heat;
                ArrayList<String> stringList = new ArrayList<String>();
                stringList.add(ModUtils.getString(component.getEnergy()) + "\u00b0C/" + ModUtils.getString(component.getCapacity()) + "\u00b0C");
                if (component.need) {
                    stringList.add(Localization.translate("iu.need_heat"));
                }
                return stringList;
            }
        });
        this.addElement(new AdvArea(this, 50, 25, 105, 34){

            @Override
            protected List<String> getToolTip() {
                String temp = ModUtils.getString((double)((TileCokeOvenMain)GuiCokeOven.this.container.base).bar * 100000.0) + " Pa";
                return Collections.singletonList(temp);
            }
        });
        this.addElement(new AdvArea(this, 88, 46, 125, 57){

            @Override
            protected List<String> getToolTip() {
                return Collections.singletonList(Localization.translate("gui.MolecularTransformer.progress") + ": " + (int)(Math.min(((TileCokeOvenMain)GuiCokeOven.this.container.base).getProgress() / 3600.0, 1.0) * 100.0) + "%");
            }
        });
        this.addElement(new TankGauge(this, 6, 18, 20, 55, (IFluidTank)((TileCokeOvenMain)this.container.base).tank, TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                if (((TileCokeOvenMain)GuiCokeOven.this.container.base).tank == null) {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                } else {
                    FluidStack fs = ((TileCokeOvenMain)GuiCokeOven.this.container.base).tank.getFluid();
                    if (!fs.isEmpty() && fs.getAmount() > 0) {
                        Fluid fluid = fs.getFluid();
                        if (fluid != null) {
                            ret.add(Localization.translate(fluid.getFluidType().getDescriptionId()) + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                        } else {
                            ret.add("invalid fluid stack");
                        }
                    } else {
                        ret.add(Localization.translate("iu.generic.text.empty"));
                    }
                }
                return ret;
            }

            @Override
            public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
                if (((TileCokeOvenMain)GuiCokeOven.this.container.base).tank == null) {
                    return;
                }
                FluidStack fs = ((TileCokeOvenMain)GuiCokeOven.this.container.base).tank.getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 4;
                        fluidY += 4;
                        fluidWidth = 12;
                        fluidHeight = 48;
                    }
                    if ((fluid = fs.getFluid()) == Fluids.f_76193_) {
                        fluid = (Fluid)FluidName.fluidwater.getInstance().get();
                    }
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 4.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    4.bindBlockTexture();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, -1, 1.0, false, true);
                    if (this.getStyle().withGauge) {
                        4.bindCommonTexture();
                        int gaugeX = this.x;
                        int gaugeY = this.y;
                        if (!this.getStyle().withBorder) {
                            gaugeX -= 4;
                            gaugeY -= 4;
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
                    }
                }
            }
        });
        this.addElement(new TankGauge(this, 129, 18, 20, 55, (IFluidTank)((TileCokeOvenMain)this.container.base).tank1, TankGauge.TankGuiStyle.Normal){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                if (((TileCokeOvenMain)GuiCokeOven.this.container.base).tank1 == null) {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                } else {
                    FluidStack fs = ((TileCokeOvenMain)GuiCokeOven.this.container.base).tank1.getFluid();
                    if (!fs.isEmpty() && fs.getAmount() > 0) {
                        Fluid fluid = fs.getFluid();
                        if (fluid != null) {
                            ret.add(Localization.translate(fluid.getFluidType().getDescriptionId()) + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                        } else {
                            ret.add("invalid fluid stack");
                        }
                    } else {
                        ret.add(Localization.translate("iu.generic.text.empty"));
                    }
                }
                return ret;
            }

            @Override
            public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
                if (((TileCokeOvenMain)GuiCokeOven.this.container.base).tank1 == null) {
                    return;
                }
                FluidStack fs = ((TileCokeOvenMain)GuiCokeOven.this.container.base).tank1.getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    Fluid fluid;
                    int fluidX = this.x;
                    int fluidY = this.y;
                    int fluidWidth = this.width;
                    int fluidHeight = this.height;
                    if (this.getStyle().withBorder) {
                        fluidX += 4;
                        fluidY += 4;
                        fluidWidth = 12;
                        fluidHeight = 48;
                    }
                    if ((fluid = fs.getFluid()) == Fluids.f_76193_) {
                        fluid = (Fluid)FluidName.fluidwater.getInstance().get();
                    }
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 5.getBlockTextureMap().m_118316_(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    5.bindBlockTexture();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, -1, 1.0, false, true);
                    if (this.getStyle().withGauge) {
                        5.bindCommonTexture();
                        int gaugeX = this.x;
                        int gaugeY = this.y;
                        if (!this.getStyle().withBorder) {
                            gaugeX -= 4;
                            gaugeY -= 4;
                        }
                        this.gui.drawTexturedModalRect(poseStack, mouseX + gaugeX, mouseY + gaugeY, 38, 100, 20, 55);
                    }
                }
            }
        });
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.coke_oven_recipe.info"));
            List<String> compatibleUpgrades = ListInformationUtils.coke_oven;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.highlightedMinus = false;
        this.highlightedPlus = false;
        if (par1 >= 34 && par2 >= 23 && par1 <= 47 && par2 <= 36) {
            this.highlightedMinus = true;
        }
        if (par1 >= 108 && par2 >= 23 && par1 <= 121 && par2 <= 36) {
            this.highlightedPlus = true;
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.f_96543_ - this.f_97726_) / 2;
        int yMin = (this.f_96544_ - this.f_97727_) / 2;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 34 && x <= 47 && y >= 23 && y <= 36) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 1.0);
        }
        if (x >= 108 && x <= 121 && y >= 23 && y <= 36) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 0.0);
        }
    }

    @Override
    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
        String name = Localization.translate(((TileCokeOvenMain)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.f_97726_ / 2 + 20, 6, Component.m_130674_((String)name), 0x404040, false);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        GuiCokeOven.bindTexture(this.getTexture());
        int progress = (int)(38.0 * ((TileCokeOvenMain)this.container.base).getProgress() / 3600.0);
        int xoffset = (this.f_96543_ - this.f_97726_) / 2;
        int yoffset = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiCokeOven.bindTexture(this.getTexture());
        if (this.highlightedMinus) {
            this.drawTexturedModalRect(poseStack, xoffset + 34, yoffset + 23, 192, 3, 14, 14);
        }
        if (this.highlightedPlus) {
            this.drawTexturedModalRect(poseStack, xoffset + 108, yoffset + 23, 177, 3, 14, 14);
        }
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 88, yoffset + 46, 177, 19, progress, 11);
        }
        GuiCokeOven.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        GuiCokeOven.bindTexture(this.getTexture());
        int bar = (int)(Math.min((double)((TileCokeOvenMain)this.container.base).bar * 1.0, 5.0) / 5.0 * 50.0);
        if (bar > 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 53, this.guiTop + 28, 181, 53, bar, 5);
        }
        if (((TileCokeOvenMain)this.container.base).heat != null) {
            progress = (int)(50.0 * ((TileCokeOvenMain)this.container.base).heat.getFillRatio());
            this.drawTexturedModalRect(poseStack, this.guiLeft + 66, this.guiTop + 79, 180, 34, progress, 8);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guicokeoven.png");
    }
}

