/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerCoolMachine;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.mechanism.cooling.TileCooling;
import com.denfop.utils.ListInformationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class GuiCoolMachine<T extends ContainerCoolMachine>
extends GuiIU<ContainerCoolMachine> {
    public ContainerCoolMachine container;
    public String name;

    public GuiCoolMachine(ContainerCoolMachine guiContainer) {
        super(guiContainer);
        this.container = guiContainer;
        this.name = Localization.translate(((TileCooling)guiContainer.base).getName());
        this.addComponent(new GuiComponent(this, 3, 14, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.componentList.add(new GuiComponent(this, 113, 21, EnumTypeComponent.ENERGY_HEIGHT, new Component<Energy>(((TileCooling)this.container.base).energy)));
        this.componentList.add(new GuiComponent(this, 51, 41, EnumTypeComponent.COOL_ENERGY_WEIGHT, new Component<CoolComponent>(((TileCooling)this.container.base).cold)));
        this.componentList.add(new GuiComponent(this, 20, 37, EnumTypeComponent.WORK_BUTTON, new Component<1>(new ComponentButton((TileEntityBlock)((Object)this.container.base), 2, ""){

            @Override
            public String getText() {
                return ((TileCooling)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((TileCooling)this.getEntityBlock()).work;
            }
        })));
        this.componentList.add(new GuiComponent(this, 53, 60, EnumTypeComponent.PLUS_BUTTON, new Component<2>(new ComponentButton((TileEntityBlock)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return "+4";
            }
        })));
        this.componentList.add(new GuiComponent(this, 78, 60, EnumTypeComponent.MINUS_BUTTON, new Component<3>(new ComponentButton((TileEntityBlock)((Object)this.container.base), 1, ""){

            @Override
            public String getText() {
                return "-4";
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.cool_storage.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.cooling;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.f_96547_.m_92883_(poseStack, this.name, (float)((this.f_97726_ - this.getStringWidth(this.name)) / 2), 6.0f, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiCoolMachine.bindTexture(this.getTexture());
        int xOffset = (this.f_96543_ - this.f_97726_) / 2;
        int yOffset = (this.f_96544_ - this.f_97727_) / 2;
        GuiCoolMachine.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xOffset + 3, yOffset + 3, 0, 0, 10, 10);
        GuiCoolMachine.bindTexture(this.getTexture());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

