/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerDoubleElectricMachine;
import com.denfop.gui.GuiIU;
import com.denfop.items.ItemPaints;
import com.denfop.tiles.base.TileDoubleElectricMachine;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiPainting<T extends ContainerDoubleElectricMachine>
extends GuiIU<ContainerDoubleElectricMachine> {
    public final ContainerDoubleElectricMachine container;

    public GuiPainting(ContainerDoubleElectricMachine container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.addComponent(new GuiComponent(this, 5, 14, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
        this.addComponent(new GuiComponent(this, 42, 58, EnumTypeComponent.ENERGY, new Component<Energy>(((TileDoubleElectricMachine)this.container.base).energy)));
        this.addElement(new ItemStackImage(this, 62, 57, () -> ItemStack.f_41583_){

            @Override
            public void drawForeground(PoseStack poseStack, int mouseX, int mouseY) {
            }

            @Override
            public void drawBackground(PoseStack poseStack, int mouseX, int mouseY) {
                if (((TileDoubleElectricMachine)GuiPainting.this.container.base).output == null) {
                    return;
                }
                super.drawBackground(poseStack, mouseX, mouseY);
                ItemStack stack = ((TileDoubleElectricMachine)GuiPainting.this.container.base).inputSlotA.get(0).m_41720_() instanceof ItemPaints ? ((TileDoubleElectricMachine)GuiPainting.this.container.base).inputSlotA.get(1) : ((TileDoubleElectricMachine)GuiPainting.this.container.base).inputSlotA.get(0);
                stack = ModUtils.mode(((TileDoubleElectricMachine)GuiPainting.this.container.base).output.getRecipe().output.metadata, stack);
                if (!ModUtils.isEmpty(stack)) {
                    this.gui.drawItemStack(this.x, this.y, stack);
                }
            }

            @Override
            public boolean visible() {
                return ((TileDoubleElectricMachine)GuiPainting.this.container.base).output != null;
            }
        });
    }

    private static List<String> getInformation() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Localization.translate("iu.paintinginformation1"));
        ret.add(Localization.translate("iu.paintinginformation2"));
        ret.add(Localization.translate("iu.paintinginformation3"));
        ret.add(Localization.translate("iu.paintinginformation4"));
        ret.add(Localization.translate("iu.paintinginformation5"));
        return ret;
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip1(par1, par2);
        if (!((TileDoubleElectricMachine)this.container.base).inputSlotA.get(1).m_41619_() && !((TileDoubleElectricMachine)this.container.base).inputSlotA.get(0).m_41619_() && ((TileDoubleElectricMachine)this.container.base).output != null) {
            this.f_96547_.m_92883_(poseStack, ModUtils.mode(((TileDoubleElectricMachine)this.container.base).output.getRecipe().output.metadata), 80.0f, 63.0f, 0x404040);
        }
    }

    private void handleUpgradeTooltip1(int mouseX, int mouseY) {
        if (mouseX >= 165 && mouseX <= 175 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.paintinginformation"));
            List<String> compatibleUpgrades = GuiPainting.getInformation();
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 80, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        GuiPainting.bindTexture(this.getTexture());
        GuiPainting.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft() + 165, this.guiTop(), 0, 0, 10, 10);
        GuiPainting.bindTexture(this.getTexture());
        int progress = (int)(10.0 * ((TileDoubleElectricMachine)this.container.base).componentProgress.getBar());
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft() + 79, this.guiTop() + 38, 179, 34, progress, 13);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GUIPainter.png".toLowerCase());
    }
}

