/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ItemImage;
import com.denfop.api.gui.ItemStackImageText;
import com.denfop.api.gui.TankGauge;
import com.denfop.api.tesseract.Channel;
import com.denfop.api.tesseract.TypeChannel;
import com.denfop.api.tesseract.TypeMode;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerTesseract;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.recipes.BaseRecipes;
import com.denfop.tiles.base.TileEntityTesseract;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.IFluidTank;

public class GuiTesseract<T extends ContainerTesseract>
extends GuiIU<ContainerTesseract> {
    private final ItemStack stack;
    private final GuiComponent energy;
    private final TankGauge fluid;
    private int guiScreenID = 0;
    private int index = 24;
    private int index1 = 24;

    public GuiTesseract(ContainerTesseract guiContainer) {
        super(guiContainer);
        this.f_97726_ = 191;
        this.f_97727_ = 208;
        this.componentList.clear();
        this.stack = BaseRecipes.getBlockStack(BlockBaseMachine3.tesseract);
        this.energy = new GuiComponent(this, 140, 95, EnumTypeComponent.ENERGY_WEIGHT, new Component<Energy>(((TileEntityTesseract)((ContainerTesseract)this.container).base).getEnergy()));
        this.fluid = TankGauge.createNormal(this, 150, 35, (IFluidTank)((TileEntityTesseract)((ContainerTesseract)this.container).base).getTank());
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.tesseract.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 8; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.tesseract.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        switch (this.guiScreenID) {
            case 1: {
                ((Area)new AdvArea(this, 16, 36, 32, 62).withTooltip(Localization.translate("tesseract.energy"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 37, 34, 52, 62).withTooltip(Localization.translate("tesseract.fluid"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 56, 34, 75, 62).withTooltip(Localization.translate("tesseract.item"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 20, 91, 30, 101).withTooltip(Localization.translate("tesseract.plus"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 60, 91, 70, 101).withTooltip(Localization.translate("tesseract.minus"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 79, 69, 91, 86).withTooltip(Localization.translate("tesseract.sink"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 95, 69, 107, 86).withTooltip(Localization.translate("tesseract.source"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 112, 67, 122, 89).withTooltip(Localization.translate("tesseract.private_channel"))).drawForeground(poseStack, par1, par2);
                ((Area)new AdvArea(this, 170, 103, 180, 112).withTooltip(Localization.translate("tesseract.activate"))).drawForeground(poseStack, par1, par2);
                break;
            }
            case 2: {
                for (int i = this.index - 24; i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size(), this.index); ++i) {
                    Channel channel = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannel(i);
                    new ItemStackImageText(this, 18 + i % 24 % 8 * 20, 31 + i % 24 / 8 * 22, () -> this.stack, Localization.translate("tesseract.channel") + channel.getChannel() + "\n" + Localization.translate("tesseract.private") + (channel.isPrivate() ? "\u0434\u0430" : "\u043d\u0435\u0442") + "\n" + Localization.translate("tesseract.player") + channel.getTesseract().getPlayer() + "\n" + Localization.translate("tesseract.type_channel") + channel.getTypeChannel().name() + "\n" + Localization.translate("tesseract.mode") + channel.getMode().name() + "\n" + Localization.translate("tesseract.private") + (channel.isActive() ? "\u0434\u0430" : "\u043d\u0435\u0442") + "\n").drawForeground(poseStack, par1, par2);
                }
                break;
            }
            case 3: {
                this.energy.drawForeground(poseStack, par1, par2);
                this.fluid.drawForeground(poseStack, par1, par2);
                List<ItemStack> itemStackList = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getSlotItem().stream().filter(itemStack -> !itemStack.m_41619_()).toList();
                for (int i = 0; i < itemStackList.size(); ++i) {
                    int finalI = i;
                    ((Area)new Area(this, 18 + i % 6 * 20, 35 + i / 6 * 22, 18, 18).withTooltip((Supplier<String>)((Supplier)() -> ((ItemStack)itemStackList.get(finalI)).m_41611_().getString()))).drawForeground(poseStack, par1, par2);
                }
                break;
            }
            case 4: {
                for (int i = this.index1 - 24; i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size(), this.index1); ++i) {
                    Channel channel = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().get(i);
                    new ItemStackImageText(this, 18 + i % 24 % 8 * 20, 31 + i % 24 / 8 * 22, () -> this.stack, Localization.translate("tesseract.channel") + channel.getChannel() + "\n" + Localization.translate("tesseract.player") + channel.getTesseract().getPlayer() + "\n" + Localization.translate("tesseract.channel") + channel.getTypeChannel().name() + "\n" + Localization.translate("tesseract.mode") + channel.getMode().name() + "\n" + Localization.translate("tesseract.active") + (channel.isActive() ? "\u0434\u0430" : "\u043d\u0435\u0442") + "\n" + Localization.translate("tesseract.coordinate") + "x:" + channel.getTesseract().getPos().m_123341_() + " y: " + channel.getTesseract().getPos().m_123342_() + " z: " + channel.getTesseract().getPos().m_123343_() + "\n").drawForeground(poseStack, par1, par2);
                }
                break;
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        switch (this.guiScreenID) {
            case 0: {
                this.drawXCenteredString(poseStack, this.f_97726_ / 2, 25, Localization.translate("tesseract.lists"), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.drawXCenteredString(poseStack, 50, 65, Localization.translate("tesseract.inventory"), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.drawXCenteredString(poseStack, 150, 65, Localization.translate("tesseract.create_channel"), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.drawXCenteredString(poseStack, this.f_97726_ / 2, 95, Localization.translate("tesseract.public_channel"), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                break;
            }
            case 1: {
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel == null) {
                    return;
                }
                this.drawXCenteredString(poseStack, 46, 73, String.valueOf(((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getChannel()), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.drawXCenteredString(poseStack, 105, 100, Localization.translate("tesseract.delete"), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.drawXCenteredString(poseStack, 137, 40, Localization.translate("tesseract.player_channel"), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.drawXCenteredString(poseStack, 137, 50, ((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTesseract().getPlayer(), ModUtils.convertRGBcolorToInt(13, 229, 34), false);
                this.bindTexture();
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.INOUT || ((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.INPUT) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 79, this.guiTop + 69, 217, 59, 13, 27);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.INOUT || ((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getMode() == TypeMode.OUTPUT) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 95, this.guiTop + 69, 230, 59, 13, 27);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTypeChannel() == TypeChannel.ENERGY) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 20, this.guiTop + 52, 232, 97, 10, 11);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTypeChannel() == TypeChannel.FLUID) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 41, this.guiTop + 52, 232, 97, 10, 11);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.getTypeChannel() == TypeChannel.ITEM) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 61, this.guiTop + 52, 232, 97, 10, 11);
                }
                if (((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.isPrivate()) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 113, this.guiTop + 78, 232, 97, 10, 11);
                }
                if (!((TileEntityTesseract)((ContainerTesseract)this.container).base).channel.isActive()) break;
                this.drawTexturedModalRect(poseStack, this.guiLeft + 171, this.guiTop + 102, 232, 97, 10, 11);
                break;
            }
            case 2: {
                this.bindTexture();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.index < ((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size()) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 156, this.guiTop + 97, 227, 124, 17, 12);
                }
                if (this.index - 24 > 0) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 15, this.guiTop + 97, 204, 124, 17, 12);
                }
                for (int i = this.index - 24; i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size(), this.index); ++i) {
                    new ItemImage(this, 18 + i % 24 % 8 * 20, 31 + i % 24 / 8 * 22, (Supplier<ItemStack>)((Supplier)() -> this.stack)).drawBackground(poseStack, this.guiLeft, this.guiTop);
                }
                break;
            }
            case 3: {
                this.energy.drawBackground(poseStack, this.guiLeft, this.guiTop);
                this.fluid.drawBackground(poseStack, this.guiLeft, this.guiTop);
                List itemStackList = ((TileEntityTesseract)((ContainerTesseract)this.container).base).getSlotItem().stream().filter(itemStack -> !itemStack.m_41619_()).collect(Collectors.toList());
                for (int i = 0; i < itemStackList.size(); ++i) {
                    this.drawItemStack(18 + i % 6 * 20, 35 + i / 6 * 22, (ItemStack)itemStackList.get(i));
                }
                break;
            }
            case 4: {
                this.bindTexture();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.index1 < ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size()) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 156, this.guiTop + 97, 227, 124, 17, 12);
                }
                if (this.index1 - 24 > 0) {
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 15, this.guiTop + 97, 204, 124, 17, 12);
                }
                for (int i = this.index1 - 24; i < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size(), this.index1); ++i) {
                    new ItemImage(this, 18 + i % 24 % 8 * 20, 31 + i % 24 / 8 * 22, (Supplier<ItemStack>)((Supplier)() -> this.stack)).drawBackground(poseStack, this.guiLeft, this.guiTop);
                }
                break;
            }
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.f_96543_ - this.f_97726_) / 2;
        int yMin = (this.f_96544_ - this.f_97727_) / 2;
        int x = i - xMin;
        int y = j - yMin;
        switch (this.guiScreenID) {
            case 0: {
                if (x >= 117 && x <= 181 && y >= 53 && y <= 86) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 1.0);
                    this.guiScreenID = 1;
                }
                if (x >= 19 && x <= 182 && y >= 15 && y <= 48) {
                    this.guiScreenID = 2;
                }
                if (x >= 19 && x <= 84 && y >= 53 && y <= 86) {
                    this.guiScreenID = 3;
                }
                if (x < 19 || x > 182 || y < 90 || y > 110) break;
                this.guiScreenID = 4;
                break;
            }
            case 1: {
                if (x >= 9 && x <= 27 && y >= 8 && y <= 20) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                    this.guiScreenID = 0;
                }
                if (x >= 20 && x <= 30 && y >= 91 && y <= 101) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 2.0);
                }
                if (x >= 60 && x <= 70 && y >= 91 && y <= 101) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 3.0);
                }
                if (x >= 90 && x <= 127 && y >= 103 && y <= 111) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 9.0);
                    this.guiScreenID = 0;
                }
                if (x >= 79 && x <= 91 && y >= 69 && y <= 86) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 4.0);
                }
                if (x >= 95 && x <= 107 && y >= 69 && y <= 86) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 4.1);
                }
                if (x >= 20 && x <= 27 && y >= 54 && y <= 61) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 5.0);
                }
                if (x >= 41 && x <= 48 && y >= 54 && y <= 61) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 5.1);
                }
                if (x >= 61 && x <= 68 && y >= 54 && y <= 61) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 5.2);
                }
                if (x >= 113 && x <= 120 && y >= 80 && y <= 87) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 6.0);
                }
                if (x < 171 || x > 178 || y < 105 || y > 112) break;
                new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 7.0);
                break;
            }
            case 2: {
                if (this.index < ((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size() && x >= 156 && y >= 97 && x <= 173 && y <= 109) {
                    this.index += 24;
                }
                if (this.index - 24 > 0 && x >= 15 && y >= 97 && x <= 32 && y <= 109) {
                    this.index -= 24;
                }
                for (int index1 = this.index - 24; index1 < Math.min(((TileEntityTesseract)((ContainerTesseract)this.container).base).getChannels().size(), this.index); ++index1) {
                    int x1 = 18 + index1 % 24 % 8 * 20;
                    int y1 = 31 + index1 % 24 / 8 * 22;
                    if (x < x1 || x >= x1 + 20 || y < y1 || y >= y1 + 22) continue;
                    double index2 = index1;
                    int del = 0;
                    while (index2 >= 1.0) {
                        index2 /= 10.0;
                        ++del;
                    }
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 10.0 + (double)del / 10.0 + index2 / 10.0);
                    this.guiScreenID = 1;
                    break;
                }
                if (x < 9 || x > 27 || y < 8 || y > 20) break;
                new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                this.guiScreenID = 0;
                break;
            }
            case 3: {
                if (x < 9 || x > 27 || y < 8 || y > 20) break;
                new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                this.guiScreenID = 0;
                break;
            }
            case 4: {
                if (x >= 9 && x <= 27 && y >= 8 && y <= 20) {
                    new PacketUpdateServerTile((BlockEntity)((ContainerTesseract)this.container).base, 8.0);
                    this.guiScreenID = 0;
                }
                if (this.index1 < ((TileEntityTesseract)((ContainerTesseract)this.container).base).getPublicChannel().size() && x >= 156 && y >= 97 && x <= 173 && y <= 109) {
                    this.index1 += 24;
                }
                if (this.index1 - 24 <= 0 || x < 15 || y < 97 || x > 32 || y > 109) break;
                this.index1 -= 24;
            }
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        switch (this.guiScreenID) {
            default: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guitesseract_main.png");
            }
            case 1: {
                return new ResourceLocation("industrialupgrade", "textures/gui/gui_tesseract_4.png");
            }
            case 2: 
            case 3: 
            case 4: 
        }
        return new ResourceLocation("industrialupgrade", "textures/gui/gui_tesseract_2.png");
    }
}

