/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.apiary;

import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.material.Fluid;

public class ApiaryHandler {
    private static final List<ApiaryHandler> recipes = new ArrayList<ApiaryHandler>();
    public final Fluid input;
    public final String output;

    public ApiaryHandler(Fluid input, String output) {
        this.input = input;
        this.output = output;
    }

    public static List<ApiaryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ApiaryHandler.initRecipes();
        }
        return recipes;
    }

    public static ApiaryHandler addRecipe(Fluid input, String output) {
        ApiaryHandler recipe = new ApiaryHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        ApiaryHandler.addRecipe((Fluid)FluidName.fluidhoney.getInstance().get(), Localization.translate("iu.apiary.honey"));
        ApiaryHandler.addRecipe((Fluid)FluidName.fluidroyaljelly.getInstance().get(), Localization.translate("iu.apiary.royaljelly"));
    }
}

