/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.deposits;

import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DepositsHandler {
    private static final List<DepositsHandler> recipes = new ArrayList<DepositsHandler>();
    private final VeinType veinType;

    public DepositsHandler(VeinType veinType) {
        this.veinType = veinType;
    }

    public static List<DepositsHandler> getRecipes() {
        if (recipes.isEmpty()) {
            DepositsHandler.initRecipes();
        }
        return recipes;
    }

    public List<ItemStack> getInputs() {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        if (this.veinType.getHeavyOre() != null) {
            stack.add(new ItemStack((ItemLike)this.veinType.getHeavyOre().getBlock(), 1));
        }
        for (ChanceOre ore : this.veinType.getOres()) {
            stack.add(new ItemStack((ItemLike)ore.getBlock().m_60734_(), 1));
        }
        return stack;
    }

    public static DepositsHandler addRecipe(VeinType veinType) {
        DepositsHandler recipe = new DepositsHandler(veinType);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (VeinType veinType : WorldBaseGen.veinTypes) {
            DepositsHandler.addRecipe(veinType);
        }
    }

    public VeinType getVeinType() {
        return this.veinType;
    }
}

