/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.earthquarry;

import com.denfop.IUItem;
import com.denfop.recipes.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class EarthQuarryHandler {
    private static final List<EarthQuarryHandler> recipes = new ArrayList<EarthQuarryHandler>();
    private final ItemStack input;
    public final double chance;
    private final ItemStack output;

    public EarthQuarryHandler(ItemStack input, double chance, ItemStack output) {
        this.input = input;
        this.chance = chance;
        this.output = output;
    }

    public static List<EarthQuarryHandler> getRecipes() {
        if (recipes.isEmpty()) {
            EarthQuarryHandler.initRecipes();
        }
        return recipes;
    }

    public static EarthQuarryHandler addRecipe(ItemStack input, double chance, ItemStack output) {
        EarthQuarryHandler recipe = new EarthQuarryHandler(input, chance, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        EarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.f_50493_), 10.0, ItemStackHelper.fromData(IUItem.ore2, 1, 1));
        EarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.f_49994_), 6.0, ItemStackHelper.fromData(IUItem.ore2, 1, 2));
        EarthQuarryHandler.addRecipe(new ItemStack((ItemLike)Blocks.f_49992_), 20.0, ItemStackHelper.fromData(IUItem.ore2, 1, 0));
    }

    public double getChance() {
        return this.chance;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

