/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.fluidheater;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class HeaterFluidsHandler {
    private static final List<HeaterFluidsHandler> recipes = new ArrayList<HeaterFluidsHandler>();
    private final FluidStack input;
    private final FluidStack output;

    public HeaterFluidsHandler(FluidStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<HeaterFluidsHandler> getRecipes() {
        if (recipes.isEmpty()) {
            HeaterFluidsHandler.initRecipes();
        }
        return recipes;
    }

    public static HeaterFluidsHandler addRecipe(FluidStack input, FluidStack output) {
        HeaterFluidsHandler recipe = new HeaterFluidsHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe container : Recipes.recipes.getRecipeFluid().getRecipeList("heat")) {
            HeaterFluidsHandler.addRecipe(container.input.getInputs().get(0), container.getOutput_fluid().get(0));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

