/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.gas_well;

import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.material.Fluid;

public class GasWellHandler {
    private static final List<GasWellHandler> recipes = new ArrayList<GasWellHandler>();
    public final Fluid input;
    public final String output;

    public GasWellHandler(Fluid input, String output) {
        this.input = input;
        this.output = output;
    }

    public static List<GasWellHandler> getRecipes() {
        if (recipes.isEmpty()) {
            GasWellHandler.initRecipes();
        }
        return recipes;
    }

    public static GasWellHandler addRecipe(Fluid input, String output) {
        GasWellHandler recipe = new GasWellHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        GasWellHandler.addRecipe((Fluid)FluidName.fluidgas.getInstance().get(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe((Fluid)FluidName.fluidiodine.getInstance().get(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe((Fluid)FluidName.fluidfluor.getInstance().get(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe((Fluid)FluidName.fluidbromine.getInstance().get(), Localization.translate("quarry.guide.gas_well7"));
        GasWellHandler.addRecipe((Fluid)FluidName.fluidchlorum.getInstance().get(), Localization.translate("quarry.guide.gas_well7"));
    }
}

