/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.multiblock;

import com.denfop.Localization;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.multiblock.MultiBlockHandler;
import com.denfop.tiles.mechanism.TileEntityMoonSpotter;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MultiBlockCategory
extends GuiIU
implements IRecipeCategory<MultiBlockHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public MultiBlockCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityMoonSpotter)BlockBaseMachine3.moon_spotter.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/common3.png"), 3, 3, 140, 170);
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate("multiblock.jei");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(MultiBlockHandler recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        String name1 = Localization.translate("multiblock.jei1");
        Minecraft minecraft = Minecraft.m_91087_();
        int xCenter = 70;
        int maxWidth = 120;
        int color = 0x404040;
        this.renderTextCentered(stack, minecraft, name1, xCenter, 25, maxWidth, color);
        int y = 2;
        this.renderTextCentered(stack, minecraft, Localization.translate("multiblock.jei2"), xCenter, 57 + y * 25, maxWidth, color);
        this.renderTextCentered(stack, minecraft, Localization.translate("multiblock.jei3"), xCenter, 10 + y * 25 + 90, maxWidth, color);
    }

    public void renderTextCentered(PoseStack stack, @Nonnull Minecraft minecraft, String text, int xCenter, int y, int maxWidth, int color) {
        Font fontRenderer = minecraft.f_91062_;
        List lines = fontRenderer.m_92865_().m_92432_(text, maxWidth, Style.f_131099_);
        int lineHeight = 9;
        int totalHeight = lines.size() * lineHeight;
        int startY = y - totalHeight / 2;
        for (int i = 0; i < lines.size(); ++i) {
            String line = ((FormattedText)lines.get(i)).getString();
            int lineWidth = fontRenderer.m_92895_(line);
            int x = xCenter - lineWidth / 2;
            fontRenderer.m_92883_(stack, line, (float)x, (float)(startY + i * lineHeight), color);
        }
    }

    public RecipeType<MultiBlockHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MultiBlockHandler recipes, IFocusGroup focuses) {
        MultiBlockStructure structure = recipes.getStructure();
        for (int i = 0; i < structure.itemStackList.size(); ++i) {
            int x = 5 + i % 6 * 20;
            int y = 45 + i / 6 * 19;
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStack(structure.itemStackList.get(i));
        }
        double y = 2.0;
        builder.addSlot(RecipeIngredientRole.INPUT, 61, (int)(32.0 + y * 23.0)).addItemStack(structure.itemStackList.get(0));
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guivein.png");
    }
}

