/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.orewashing;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class OreWashingHandler {
    private static final List<OreWashingHandler> recipes = new ArrayList<OreWashingHandler>();
    private final ItemStack input;
    private final List<ItemStack> output;
    private final short temperature;
    private final BaseMachineRecipe container;

    public OreWashingHandler(ItemStack input, List<ItemStack> output, short temperature, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.container = container;
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public static List<OreWashingHandler> getRecipes() {
        if (recipes.isEmpty()) {
            OreWashingHandler.initRecipes();
        }
        return recipes;
    }

    public static OreWashingHandler addRecipe(ItemStack input, List<ItemStack> output, short temperature, BaseMachineRecipe container) {
        OreWashingHandler recipe = new OreWashingHandler(input, output, temperature, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static OreWashingHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (OreWashingHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("orewashing")) {
            OreWashingHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items, (short)1000, container);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public boolean matchesInput(ItemStack is) {
        return is.m_41720_() == this.input.m_41720_();
    }

    public short getTemperature() {
        return this.temperature;
    }
}

