/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.programming_table;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ProgrammingTableHandler {
    private static final List<ProgrammingTableHandler> recipes = new ArrayList<ProgrammingTableHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public ProgrammingTableHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<ProgrammingTableHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ProgrammingTableHandler.initRecipes();
        }
        return recipes;
    }

    public static ProgrammingTableHandler addRecipe(ItemStack input, ItemStack output) {
        ProgrammingTableHandler recipe = new ProgrammingTableHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ProgrammingTableHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (ProgrammingTableHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("programming")) {
            ProgrammingTableHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

