/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.earth;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class EarthHandler {
    private static final List<EarthHandler> recipes = new ArrayList<EarthHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final double need;

    public EarthHandler(ItemStack input, ItemStack output, double need) {
        this.input = input;
        this.output = output;
        this.need = need;
    }

    public static List<EarthHandler> getRecipes() {
        if (recipes.isEmpty()) {
            EarthHandler.initRecipes();
        }
        return recipes;
    }

    public static EarthHandler addRecipe(ItemStack input, ItemStack output, double need) {
        EarthHandler recipe = new EarthHandler(input, output, need);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static EarthHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (EarthHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("earthcollector")) {
            try {
                EarthHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.m_128459_("need"));
            }
            catch (Exception e) {
                System.out.println(2);
            }
        }
    }

    public double getNeed() {
        return this.need;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

