/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.ElectricItem;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.invslot.InvSlot;
import com.denfop.utils.ModUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class InvSlotDischarge
extends InvSlot {
    public int tier;
    public boolean allowRedstoneDust;

    public InvSlotDischarge(IAdvInventory<?> base, InvSlot.TypeItemSlot typeItemSlot, int tier) {
        this(base, typeItemSlot, tier, false);
    }

    public InvSlotDischarge(IAdvInventory<?> base, int tier) {
        this(base, InvSlot.TypeItemSlot.INPUT, tier);
    }

    public InvSlotDischarge(IAdvInventory<?> base, InvSlot.TypeItemSlot typeItemSlot, int tier, boolean allowRedstoneDust) {
        super(base, typeItemSlot, 1);
        this.tier = tier;
        this.allowRedstoneDust = allowRedstoneDust;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        if (this.allowRedstoneDust && stack.m_41720_() == Items.f_42451_) {
            return true;
        }
        if (stack.m_41720_() instanceof IEnergyItem) {
            return ElectricItem.manager.discharge(stack, 2.147483647E9, this.tier, true, true, true) > 0.0;
        }
        return false;
    }

    public double discharge(double amount, boolean ignoreLimit) {
        if (amount <= 0.0) {
            return 0.0;
        }
        ItemStack stack = this.get(0);
        if (ModUtils.isEmpty(stack)) {
            return 0.0;
        }
        double realAmount = ElectricItem.manager.discharge(stack, amount, this.tier, ignoreLimit, true, false);
        if (realAmount <= 0.0) {
            realAmount = ModUtils.getEnergyValue(stack);
            if (realAmount <= 0.0) {
                return 0.0;
            }
            stack.m_41774_(1);
            this.set(0, stack);
        }
        return realAmount;
    }

    public double dischargeWithRedstone(double capacity, double amount) {
        ItemStack stack = this.get(0);
        if (stack.m_41619_()) {
            return 0.0;
        }
        double canAdd = capacity * 0.2;
        int size = stack.m_41613_();
        int needRemove = (int)Math.min(amount / canAdd, (double)size);
        if (needRemove <= 0) {
            return 0.0;
        }
        this.set(0, ModUtils.decSize(stack, needRemove));
        return (double)needRemove * canAdd;
    }

    public void setTier(int tier1) {
        this.tier = tier1;
    }
}

