/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine;
import com.denfop.blocks.mechanism.BlockSimpleMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.tiles.base.TileCombinerMatter;
import net.minecraft.world.item.ItemStack;

public class InvSlotMatter
extends InvSlot
implements ITypeSlot {
    private final TileCombinerMatter tile;
    private int stackSizeLimit = 4;

    public InvSlotMatter(TileCombinerMatter base1) {
        super(base1, InvSlot.TypeItemSlot.INPUT, 9);
        this.tile = base1;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.BLOCKS;
    }

    @Override
    public void update() {
        this.tile.energy.setCapacity(this.getMaxEnergy(this));
        this.tile.fluidTank.setCapacity(this.getFluidTank(this));
        this.tile.energycost = this.getcostEnergy(this);
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.tile.energy.setCapacity(this.getMaxEnergy(this));
        this.tile.fluidTank.setCapacity(this.getFluidTank(this));
        this.tile.energycost = this.getcostEnergy(this);
        return content;
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        return itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockBaseMachine.adv_matter.getIDBlock() && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getId() <= 3 || itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockSimpleMachine.generator_matter.getIDBlock() && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getId() == 6 || itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockBaseMachine.imp_matter.getIDBlock() || itemStack.m_41720_() instanceof ItemBlockTileEntity && ((ItemBlockTileEntity)itemStack.m_41720_()).getTeBlock(itemStack).getIDBlock() == BlockBaseMachine.per_matter.getIDBlock();
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    public double getMattercostenergy(ItemStack stack) {
        int count = ((ItemBlockTileEntity)stack.m_41720_()).getTeBlock(stack).getId();
        switch (count) {
            case 1: {
                return 900000.0;
            }
            case 2: {
                return 800000.0;
            }
            case 3: {
                return 700000.0;
            }
        }
        return 1000000.0;
    }

    public double getMatterenergy(ItemStack stack) {
        int count = ((ItemBlockTileEntity)stack.m_41720_()).getTeBlock(stack).getId();
        switch (count) {
            case 1: {
                return 8000000.0;
            }
            case 2: {
                return 6.4E7;
            }
            case 3: {
                return 2.56E8;
            }
        }
        return 5000000.0;
    }

    public double getMaxEnergy(InvSlotMatter inputSlot) {
        double maxEnergy = 0.0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).m_41619_()) continue;
            maxEnergy += this.getMatterenergy(inputSlot.get(i)) * (double)inputSlot.get(i).m_41613_();
        }
        return maxEnergy;
    }

    public double getcostEnergy(InvSlotMatter inputSlot) {
        double cost = 0.0;
        int k = 0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).m_41619_()) continue;
            cost += this.getMattercostenergy(inputSlot.get(i)) * (double)inputSlot.get(i).m_41613_();
            k += inputSlot.get(i).m_41613_();
        }
        return cost / (double)k;
    }

    public int getFluidTank(InvSlotMatter inputSlot) {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (inputSlot.get(i).m_41619_()) continue;
            count += this.getMattertank(inputSlot.get(i)) * inputSlot.get(i).m_41613_();
        }
        return 1000 * count;
    }

    private int getMattertank(ItemStack stack) {
        int count = ((ItemBlockTileEntity)stack.m_41720_()).getTeBlock(stack).getId();
        switch (count) {
            case 1: {
                return 12;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 16;
            }
        }
        return 10;
    }
}

