/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.ElectricItem;
import com.denfop.IUItem;
import com.denfop.api.item.IEnergyItem;
import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.EnumBaseType;
import com.denfop.items.modules.EnumModule;
import com.denfop.items.modules.ItemAdditionModule;
import com.denfop.items.modules.ItemBaseModules;
import com.denfop.items.modules.ItemModuleType;
import com.denfop.items.modules.ItemModuleTypePanel;
import com.denfop.tiles.panels.entity.EnumSolarPanels;
import com.denfop.tiles.panels.entity.EnumType;
import com.denfop.tiles.panels.entity.TileSolarPanel;
import com.denfop.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class InvSlotPanel
extends InvSlot {
    public final int tier;

    public InvSlotPanel(TileSolarPanel base, int tier, int slotNumbers, InvSlot.TypeItemSlot typeItemSlot) {
        super(base, typeItemSlot, slotNumbers);
        this.tier = tier;
        this.setStackSizeLimit(1);
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.checkmodule();
        TileSolarPanel tile = (TileSolarPanel)this.base;
        tile.solarType = this.solartype();
        return content;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        return stack.m_41720_() instanceof ItemBaseModules || stack.m_41720_() instanceof ItemModuleTypePanel || stack.m_41720_() instanceof ItemAdditionModule || stack.m_41720_() instanceof IEnergyItem || stack.m_41720_() instanceof ItemModuleType;
    }

    public int solartype() {
        TileSolarPanel tile = (TileSolarPanel)this.base;
        tile.levelPanel = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemModuleType)) continue;
            tile.levelPanel = IUItem.module5.getMeta((ItemModuleType)this.get(i).m_41720_()) + 1;
        }
        EnumType type = EnumType.getFromID(tile.levelPanel);
        return tile.setSolarType(type);
    }

    public int solartypeFast() {
        TileSolarPanel tile = (TileSolarPanel)this.base;
        EnumType type = EnumType.getFromID(tile.levelPanel);
        return tile.setSolarType(type);
    }

    public void checkmodule() {
        EnumBaseType type;
        int i;
        TileSolarPanel tile = (TileSolarPanel)this.base;
        tile.charge = false;
        double temp_day = tile.defaultDay;
        double temp_night = tile.defaultNight;
        double temp_storage = tile.defaultMaxStorage;
        double temp_producing = tile.defaultOutoput;
        tile.tier = (int)tile.defaultTier;
        for (i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemAdditionModule)) continue;
            int kk = IUItem.module7.getMeta((ItemAdditionModule)this.get(i).m_41720_());
            if (kk == 1) {
                ++tile.tier;
                continue;
            }
            if (kk == 2) {
                --tile.tier;
                continue;
            }
            if (kk != 3) continue;
            tile.charge = true;
        }
        if (tile.tier < 1) {
            tile.tier = 1;
        }
        for (i = 0; i < this.size(); ++i) {
            int g;
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemModuleTypePanel) || tile.tier < (g = IUItem.module6.getMeta((ItemModuleTypePanel)this.get(i).m_41720_())) + 1) continue;
            EnumSolarPanels solar = ItemModuleTypePanel.getSolarType(g);
            temp_day += solar.genday;
            temp_night += solar.gennight;
            temp_storage += solar.maxstorage;
            temp_producing += solar.producing;
        }
        block8: for (i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemBaseModules) || EnumModule.getFromID(IUItem.basemodules.getMeta((ItemBaseModules)this.get(i).m_41720_())) == null) continue;
            EnumModule module = EnumModule.getFromID(IUItem.basemodules.getMeta((ItemBaseModules)this.get(i).m_41720_()));
            type = module.type;
            double percent = module.percent;
            switch (type) {
                case DAY: {
                    temp_day += tile.defaultDay * percent;
                    continue block8;
                }
                case NIGHT: {
                    temp_night += tile.defaultNight * percent;
                    continue block8;
                }
                case STORAGE: {
                    temp_storage += tile.defaultMaxStorage * percent;
                    continue block8;
                }
                case OUTPUT: {
                    temp_producing += tile.defaultOutoput * percent;
                }
            }
        }
        tile.genDay = temp_day;
        tile.genNight = temp_night;
        tile.maxStorage = temp_storage;
        tile.output = temp_producing;
        tile.moonPhase = 1.0;
        tile.coef = 0.0;
        this.wirelessmodule();
        for (i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemBaseModules) || EnumModule.getFromID(IUItem.basemodules.getMeta((ItemBaseModules)this.get(i).m_41720_())) == null) continue;
            EnumModule module = EnumModule.getFromID(IUItem.basemodules.getMeta((ItemBaseModules)this.get(i).m_41720_()));
            type = module.type;
            if (type != EnumBaseType.PHASE) continue;
            tile.coef = module.percent;
            break;
        }
        for (i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemBaseModules) || EnumModule.getFromID(IUItem.basemodules.getMeta((ItemBaseModules)this.get(i).m_41720_())) == null) continue;
            EnumModule module = EnumModule.getFromID(IUItem.basemodules.getMeta((ItemBaseModules)this.get(i).m_41720_()));
            type = module.type;
            if (type != EnumBaseType.MOON_LINSE) continue;
            tile.moonPhase = module.percent;
            break;
        }
    }

    public void charge() {
        TileSolarPanel tile = (TileSolarPanel)this.base;
        for (int j = 0; j < this.size(); ++j) {
            double sentPacket;
            if (this.get(j).m_41619_() || !(this.get(j).m_41720_() instanceof IEnergyItem) || !(tile.storage > 0.0) || !((sentPacket = ElectricItem.manager.charge(this.get(j), tile.storage, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
            tile.storage -= (double)((int)sentPacket);
        }
    }

    public void wirelessmodule() {
        TileSolarPanel tile = (TileSolarPanel)this.base;
        tile.wirelessComponent.setUpdate(false);
        tile.wirelessComponent.removeAll();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).m_41619_() || !(this.get(i).m_41720_() instanceof ItemAdditionModule) || IUItem.module7.getMeta((ItemAdditionModule)this.get(i).m_41720_()) != 10) continue;
            CompoundTag nbttagcompound = ModUtils.nbt(this.get(i));
            int x = nbttagcompound.m_128451_("Xcoord");
            int y = nbttagcompound.m_128451_("Ycoord");
            int z = nbttagcompound.m_128451_("Zcoord");
            if (nbttagcompound.m_128471_("change")) continue;
            tile.wirelessComponent.setUpdate(true);
            BlockPos pos = new BlockPos(x, y, z);
            tile.wirelessComponent.addConnect(pos);
        }
    }
}

