/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFluidContainer
extends Item {
    public final int capacity;
    protected String nameItem;

    public ItemFluidContainer(int capacity) {
        super(new Item.Properties().m_41491_(IUCore.ItemTab).m_41487_(64).setNoRepair());
        this.capacity = capacity;
    }

    public ItemFluidContainer(Item.Properties properties, int capacity) {
        super(properties);
        this.capacity = capacity;
    }

    public ItemFluidContainer(int capacity, int amount) {
        super(new Item.Properties().m_41491_(IUCore.ItemTab).m_41487_(amount).setNoRepair());
        this.capacity = capacity;
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem + ".name";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, list, tooltipFlag);
        IFluidHandlerItem fs = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)this.initCapabilities(stack, stack.m_41783_())));
        if (fs.getFluidInTank(0).getFluid() != Fluids.f_76191_) {
            list.add((Component)Component.m_237113_((String)("< " + Localization.translate(fs.getFluidInTank(0).getFluid().getFluidType().getDescriptionId()) + ", " + fs.getFluidInTank(0).getAmount() + " mB >")));
        } else {
            list.add((Component)Component.m_237113_((String)Localization.translate("iu.item.FluidContainer.Empty")));
        }
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (!this.hasCraftingRemainingItem(stack)) {
            return super.getCraftingRemainingItem(stack);
        }
        ItemStack ret = ModUtils.setSize(stack, 1);
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((IFluidHandlerItem)this.initCapabilities(stack, stack.m_41783_())));
        handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        return handler.getContainer();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CapabilityFluidHandlerItem(stack, this.capacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidContainer.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidContainer.this.canfill(fluid.getFluid()) && ItemFluidContainer.this.canDrain(fluid);
            }
        };
    }

    public boolean canDrain(FluidStack fluid) {
        return true;
    }

    public List<ItemStack> getAllStacks() {
        LinkedList<ItemStack> ret = new LinkedList<ItemStack>();
        ret.add(new ItemStack((ItemLike)this));
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            ItemStack add = this.getItemStack(fluid);
            if (add == ItemStack.f_41583_ || add.m_41619_() || FluidHandlerFix.getFluidHandler(add).getFluidInTank(0).isEmpty()) continue;
            ret.add(add);
        }
        return ret;
    }

    public boolean canfill(Fluid var1) {
        return true;
    }

    public ItemStack getItemStack(ItemStack ret, Fluid fluid) {
        if (fluid == null) {
            return ret;
        }
        IFluidHandlerItem handler = FluidHandlerFix.getFluidHandler(ret);
        if (handler == null) {
            return null;
        }
        return handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE) > 0 ? handler.getContainer() : null;
    }

    public ItemStack getItemStack(Fluid fluid) {
        ItemStack ret = new ItemStack((ItemLike)this);
        if (fluid == null || fluid == Fluids.f_76191_ || !fluid.m_7444_(fluid.m_76145_())) {
            return ret;
        }
        IFluidHandlerItem handler = FluidHandlerFix.getFluidHandler(ret);
        if (handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE) > 0) {
            return handler.getContainer();
        }
        return ret;
    }
}

