/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUItem;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerUpgrade;
import com.denfop.gui.GUIUpgrade;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemStackInventory;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemStackUpgradeModules
extends ItemStackInventory {
    public final ItemStack itemStack1;
    public final ItemStack[] list;
    public final int inventorySize;
    public List<FluidStack> fluidStackList;

    public ItemStackUpgradeModules(Player player, ItemStack stack) {
        super(player, stack, 0);
        this.itemStack1 = stack;
        this.inventorySize = 0;
        this.list = new ItemStack[9];
        Arrays.fill(this.list, ItemStack.f_41583_);
        if (!player.m_9236_().f_46443_) {
            CompoundTag nbt = ModUtils.nbt(this.containerStack);
            ListTag contentList = nbt.m_128437_("Items1", 10);
            for (int i = 0; i < contentList.size(); ++i) {
                CompoundTag slotNbt = contentList.m_128728_(i);
                byte slot = slotNbt.m_128445_("Slot");
                if (slot < 0 || slot >= this.list.length) continue;
                this.list[slot] = ItemStack.m_41712_((CompoundTag)slotNbt);
            }
        }
        this.fluidStackList = new ArrayList<Object>(Collections.nCopies(9, null));
        if (!IUItem.ejectorUpgrade.m_150930_(this.itemStack1.m_41720_()) && !IUItem.pullingUpgrade.m_150930_(this.itemStack1.m_41720_())) {
            for (int i = 0; i < 9; ++i) {
                IFluidHandlerItem handler;
                FluidStack containerFluid;
                if (this.list[i].m_41619_() || (containerFluid = (handler = (IFluidHandlerItem)this.list[i].getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse((Object)((CapabilityFluidHandlerItem)this.list[i].m_41720_().initCapabilities(this.list[i], this.list[i].m_41783_())))).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || containerFluid.getAmount() <= 0) continue;
                this.fluidStackList.set(i, new FluidStack(containerFluid.getFluid(), 1));
            }
        }
    }

    @Override
    public ContainerBase<ItemStackUpgradeModules> getGuiContainer(Player player) {
        return new ContainerUpgrade(this, player);
    }

    @Override
    public ItemStack m_8020_(int slot) {
        return slot >= this.inventorySize ? this.list[slot - this.inventorySize] : this.inventory[slot];
    }

    @Override
    public ItemStack m_7407_(int index, int amount) {
        ItemStack stack;
        if (index < this.inventory.length) {
            ItemStack stack2;
            if (index >= 0 && index < this.inventory.length && !ModUtils.isEmpty(stack2 = this.inventory[index])) {
                ItemStack ret;
                if (amount >= ModUtils.getSize(stack2)) {
                    ret = stack2;
                    this.inventory[index] = ModUtils.emptyStack;
                } else {
                    ret = ModUtils.setSize(stack2, amount);
                    this.inventory[index] = ModUtils.decSize(stack2, amount);
                }
                this.save();
                return ret;
            }
            return ModUtils.emptyStack;
        }
        if (index - this.inventory.length < this.list.length && !ModUtils.isEmpty(stack = this.list[index - this.inventory.length])) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.list[index - this.inventory.length] = ModUtils.emptyStack;
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.list[index - this.inventory.length] = ModUtils.decSize(stack, amount);
            }
            this.save();
            return ret;
        }
        return ModUtils.emptyStack;
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        if (slot < this.inventory.length) {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            this.inventory[slot] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        } else {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            this.list[slot - this.inventory.length] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        }
        this.save();
    }

    @Override
    protected void save() {
        super.save();
        if (!this.player.m_9236_().f_46443_ && !this.cleared) {
            int idx;
            boolean dropItself = false;
            for (int i = 0; i < this.list.length; ++i) {
                if (!this.isThisContainer(this.list[i])) continue;
                this.list[i] = null;
                dropItself = true;
            }
            ListTag contentList = new ListTag();
            for (idx = 0; idx < this.list.length; ++idx) {
                if (ModUtils.isEmpty(this.list[idx])) continue;
                CompoundTag nbt = new CompoundTag();
                nbt.m_128344_("Slot", (byte)idx);
                this.list[idx].m_41739_(nbt);
                contentList.add((Object)nbt);
            }
            ModUtils.nbt(this.containerStack).m_128365_("Items1", (Tag)contentList);
            this.containerStack = ModUtils.setSize(this.containerStack, 1);
            if (dropItself) {
                ModUtils.dropAsEntity(this.player.m_9236_(), this.player.m_20183_(), this.containerStack);
                this.clear();
            } else {
                idx = this.getPlayerInventoryIndex();
                if (idx < -1) {
                    this.clear();
                } else if (idx == -1) {
                    this.player.m_150109_().m_36012_(this.containerStack);
                } else {
                    this.player.m_150109_().m_6836_(idx, this.containerStack);
                }
            }
        }
    }

    public ItemStack[] getList() {
        return this.list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player player, ContainerBase<?> isAdmin) {
        if (this.itemStack1.m_150930_(IUItem.ejectorUpgrade.m_41720_()) || this.itemStack1.m_150930_(IUItem.pullingUpgrade.m_41720_())) {
            return new GUIUpgrade((ContainerUpgrade)isAdmin, this.itemStack1);
        }
        return new GUIUpgrade((ContainerUpgrade)isAdmin, this.itemStack1);
    }

    @Override
    public ItemStackInventory getParent() {
        return this;
    }

    @Override
    public void addInventorySlot(InvSlot var1) {
    }

    @Override
    public int getBaseIndex(InvSlot var1) {
        return 0;
    }

    @Override
    @Nonnull
    public String getName() {
        return "";
    }

    public boolean hasCustomName() {
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }
}

