/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.windsystem.IWindRotor;
import com.denfop.api.windsystem.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.api.windsystem.upgrade.IRotorUpgradeItem;
import com.denfop.api.windsystem.upgrade.RotorUpgradeItemInform;
import com.denfop.api.windsystem.upgrade.RotorUpgradeSystem;
import com.denfop.api.windsystem.upgrade.event.EventRotorItemLoad;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemWindRotor
extends ItemDamage
implements IWindRotor,
IRotorUpgradeItem {
    private final int radius;
    private final float efficiency;
    private final ResourceLocation renderTexture;
    private final int level;
    private final int index;
    private final int tier;

    public ItemWindRotor(String name, int Radius, int durability, float efficiency, ResourceLocation RenderTexture, int level, int index) {
        super(new Item.Properties().m_41491_(IUCore.ItemTab).m_41487_(1), durability);
        this.radius = Radius;
        this.efficiency = efficiency;
        this.renderTexture = RenderTexture;
        this.level = level;
        this.index = index;
        double KU1 = 20.0f * efficiency * 27.0f;
        this.tier = EnergyNetGlobal.instance.getTierFromPower(KU1);
        IUCore.runnableListAfterRegisterItem.add(() -> {
            IInputHandler input = Recipes.inputFactory;
            for (int i = 0; i < EnumInfoRotorUpgradeModules.values().length; ++i) {
                Recipes.recipes.addRecipe("rotor_upgrade", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)this, 1)), input.getInput(new ItemStack((ItemLike)IUItem.rotors_upgrade.getStack(i), 1))), new RecipeOutput(null, new ItemStack((ItemLike)this, 1))));
            }
        });
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.rotor.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        int windStrength = 10;
        int windStrength1 = 20;
        double KU = (float)windStrength * this.getEfficiency(stack) * 25.0f;
        double KU1 = (float)windStrength1 * this.getEfficiency(stack) * 25.0f;
        tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.windgenerator") + windStrength + " m/s " + Localization.translate("iu.windgenerator1") + ModUtils.getString(KU))));
        tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.windgenerator") + windStrength1 + " m/s " + Localization.translate("iu.windgenerator1") + ModUtils.getString(KU1))));
        tooltip.add((Component)Component.m_237113_((String)(Localization.translate("gui.iu.tier") + ": " + this.getLevel())));
        double hours = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        List<Double> time = ModUtils.Time(this.getMaxCustomDamage(stack) - this.getCustomDamage(stack));
        if (time.size() > 0) {
            hours = time.get(0);
            minutes = time.get(1);
            seconds = time.get(2);
        }
        String time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
        String time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
        String time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
        tooltip.add((Component)Component.m_237113_((String)(Localization.translate("iu.timetoend") + time1 + time2 + time3)));
        if (RotorUpgradeSystem.instance.hasInMap(stack)) {
            List<RotorUpgradeItemInform> lst = RotorUpgradeSystem.instance.getInformation(stack);
            int col = RotorUpgradeSystem.instance.getRemaining(stack);
            if (!lst.isEmpty()) {
                for (RotorUpgradeItemInform upgrade : lst) {
                    tooltip.add((Component)Component.m_237113_((String)upgrade.getName()));
                }
            }
            if (col != 0) {
                tooltip.add((Component)Component.m_237113_((String)(Localization.translate("free_slot") + col + Localization.translate("free_slot1"))));
            } else {
                tooltip.add((Component)Component.m_237113_((String)Localization.translate("not_free_slot")));
            }
        }
    }

    public void m_6883_(@Nonnull ItemStack itemStack, @Nonnull Level world, @Nonnull Entity entity, int slot, boolean isSelected) {
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!RotorUpgradeSystem.instance.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventRotorItemLoad(world, this, itemStack));
        }
        if (this.getMaxCustomDamage(itemStack) != nbt.m_128451_("maxDamage")) {
            nbt.m_128405_("maxDamage", this.getMaxCustomDamage(itemStack));
        }
    }

    @Override
    public int getDiameter(ItemStack stack) {
        return this.radius;
    }

    @Override
    public ResourceLocation getRotorRenderTexture(ItemStack stack) {
        return this.renderTexture;
    }

    @Override
    public float getEfficiency(ItemStack stack) {
        return this.efficiency;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getSourceTier() {
        return this.tier;
    }
}

