/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.api.item.IEnergyItem;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorBase;
import com.denfop.items.armour.material.ArmorMaterials;
import com.denfop.utils.ModUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ItemArmorEnergy
extends ItemArmorBase
implements ISpecialArmor,
IEnergyItem {
    protected final double maxCharge;
    protected final double transferLimit;
    protected final int tier;

    public ItemArmorEnergy(String armorName, EquipmentSlot armorType, double maxCharge, double transferLimit, int tier) {
        super(ArmorMaterials.ENERGY_ITEM, armorName, armorType);
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.transferLimit = transferLimit;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.m_19376_()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getArmorDisplay(Player player, ItemStack armor, int slot) {
        return ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage() ? (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio()) : 0;
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public boolean m_41465_() {
        return false;
    }

    @Override
    public void damageArmor(LivingEntity entity, ItemStack stack, DamageSource source, float damage, int slot) {
        ElectricItem.manager.discharge(stack, damage * (float)this.getEnergyPerDamage(), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public abstract double getDamageAbsorptionRatio();

    public abstract int getEnergyPerDamage();

    protected final double getBaseAbsorptionRatio() {
        switch (this.f_40377_) {
            case HEAD: 
            case FEET: {
                return 0.15;
            }
            case CHEST: {
                return 0.4;
            }
            case LEGS: {
                return 0.3;
            }
        }
        return 0.0;
    }
}

