/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour.special;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.audio.SoundHandler;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.material.ArmorMaterials;
import com.denfop.items.armour.special.EnumCapability;
import com.denfop.items.armour.special.EnumSubTypeArmor;
import com.denfop.items.armour.special.EnumTypeArmor;
import com.denfop.items.armour.special.ItemStackLegsBags;
import com.denfop.items.armour.special.ItemStackStreakSettings;
import com.denfop.mixin.invoker.LevelInvoker;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.ModUtils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSpecialArmor
extends ArmorItem
implements ISpecialArmor,
IItemStackInventory,
IEnergyItem,
IUpgradeItem {
    protected final Map<MobEffect, Integer> potionRemovalCost = new IdentityHashMap<MobEffect, Integer>();
    private final List<EnumCapability> listCapability;
    private final double maxCharge;
    private final int tier;
    private final double transferLimit;
    private final EnumTypeArmor armor;
    private final String name;
    private float jumpCharge;
    private boolean lastJetpackUsed = false;
    private String nameItem;

    public ItemSpecialArmor(EnumSubTypeArmor subTypeArmor, EnumTypeArmor typeArmor) {
        super((ArmorMaterial)ArmorMaterials.ENERGY_ITEM, subTypeArmor.getEntityEquipmentSlot(), new Item.Properties().m_41491_(IUCore.EnergyTab).m_41487_(1).setNoRepair());
        ArrayList<EnumCapability> list = new ArrayList<EnumCapability>(subTypeArmor.getCapabilities());
        list.removeIf(capability -> !typeArmor.getListCapability().contains(capability));
        this.listCapability = list;
        if (this.f_40377_ == EquipmentSlot.FEET) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.armor = typeArmor;
        this.name = typeArmor.name().toLowerCase() + "_" + subTypeArmor.name().toLowerCase();
        this.maxCharge = typeArmor.getMaxEnergy();
        this.tier = typeArmor.getTier();
        this.transferLimit = typeArmor.getMaxTransfer();
        if (this.listCapability.contains((Object)EnumCapability.ACTIVE_EFFECT) || this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
            this.potionRemovalCost.put(IUPotion.radiation, 20);
            if (this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
                this.potionRemovalCost.put(MobEffects.f_19614_, 100);
                this.potionRemovalCost.put(MobEffects.f_19615_, 100);
                this.potionRemovalCost.put(MobEffects.f_19612_, 200);
                this.potionRemovalCost.put(MobEffects.f_19597_, 200);
                this.potionRemovalCost.put(MobEffects.f_19590_, 200);
                this.potionRemovalCost.put(MobEffects.f_19620_, 200);
                this.potionRemovalCost.put(MobEffects.f_19604_, 200);
                this.potionRemovalCost.put(MobEffects.f_19610_, 200);
                this.potionRemovalCost.put(MobEffects.f_19613_, 200);
            }
        }
        switch (this.m_40402_()) {
            case HEAD: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.HELMET.list));
                break;
            }
            case CHEST: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BODY.list));
                break;
            }
            case LEGS: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.LEGGINGS.list));
                break;
            }
            case FEET: {
                IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BOOTS.list));
            }
        }
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        switch (this.m_40402_()) {
            case HEAD: {
                return EnumUpgrades.HELMET.list;
            }
            case CHEST: {
                return EnumUpgrades.BODY.list;
            }
            case LEGS: {
                return EnumUpgrades.LEGGINGS.list;
            }
            case FEET: {
                return EnumUpgrades.BOOTS.list;
            }
        }
        return EnumUpgrades.HELMET.list;
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        if (this.m_40402_() == EquipmentSlot.LEGS) {
            return new ItemStackLegsBags(player, stack);
        }
        return new ItemStackStreakSettings(player, stack);
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public EnumTypeArmor getArmor() {
        return this.armor;
    }

    public List<EnumCapability> getListCapability() {
        return this.listCapability;
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity p_41406_, int p_41407_, boolean p_41408_) {
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> items) {
        if (this.m_220152_(p_41391_)) {
            ItemStack stack = new ItemStack((ItemLike)this, 1);
            CompoundTag nbt = ModUtils.nbt(stack);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            nbt.m_128405_("ID_Item", Integer.MAX_VALUE);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((ItemLike)this, 1);
            nbt = ModUtils.nbt(itemstack);
            nbt.m_128405_("ID_Item", Integer.MAX_VALUE);
            items.add((Object)itemstack);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        int suffix = this.f_40377_ == EquipmentSlot.LEGS ? 2 : 1;
        CompoundTag nbtData = ModUtils.nbt(stack);
        String mode = nbtData.m_128461_("mode");
        if (!mode.isEmpty() && this.armor.getSkinsList().contains(mode)) {
            if (suffix == 1) {
                return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_" + mode.toLowerCase() + "_1.png";
            }
            return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_" + mode.toLowerCase() + "_2.png";
        }
        if (suffix == 1) {
            return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_1.png";
        }
        return "industrialupgrade:textures/armor/" + this.armor.name().toLowerCase() + "_2.png";
    }

    @SubscribeEvent
    public void Potion(LivingEvent.LivingTickEvent event) {
        Item item;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.f_19853_.f_46443_) {
            return;
        }
        CompoundTag nbtData = player.getPersistentData();
        ItemStack boots = (ItemStack)player.m_150109_().f_35975_.get(0);
        boolean hasStepCap = false;
        if (!boots.m_41619_() && (item = boots.m_41720_()) instanceof ItemSpecialArmor) {
            ItemSpecialArmor armor = (ItemSpecialArmor)item;
            hasStepCap = armor.listCapability.contains((Object)EnumCapability.AUTO_JUMP);
        }
        if (hasStepCap) {
            if (!nbtData.m_128471_("stepHeight")) {
                nbtData.m_128379_("stepHeight", true);
                player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22100_(1.0);
            }
        } else if (nbtData.m_128471_("stepHeight")) {
            nbtData.m_128379_("stepHeight", false);
            player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()).m_22100_(0.0);
        }
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void moveRelative(Player player, float strafe, float up, float forward, float friction) {
        float f = strafe * strafe + up * up + forward * forward;
        if (f >= 1.0E-4f) {
            if ((f = Mth.m_14116_((float)f)) < 1.0f) {
                f = 1.0f;
            }
            f = friction / f;
            strafe *= f;
            up *= f;
            forward *= f;
            if (player.m_20069_() || player.m_20077_()) {
                strafe *= (float)player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_();
                up *= (float)player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_();
                forward *= (float)player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_();
            }
            float f1 = Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            Vec3 deltaMovement = player.m_20184_();
            player.m_20256_(new Vec3(deltaMovement.f_82479_ + (double)(strafe * f2 - forward * f1), deltaMovement.f_82480_ + (double)up, deltaMovement.f_82481_ + (double)(forward * f2 + strafe * f1)));
        }
    }

    public void onArmorTick(ItemStack itemStack, @Nonnull Level world, @Nonnull Player player) {
        int repaired;
        CompoundTag nbtData = ModUtils.nbt(itemStack);
        byte toggleTimer = nbtData.m_128445_("toggleTimer");
        boolean ret = false;
        int resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
        int n = repaired = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.REPAIRED, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.REPAIRED, (ItemStack)itemStack).number : 0;
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 300));
        }
        if (repaired != 0 && world.m_46467_() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxEnergy(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, resistance));
        }
        switch (this.f_40377_) {
            case HEAD: {
                ArrayList effects = new ArrayList(player.m_21220_());
                for (MobEffectInstance effect : effects) {
                    Integer cost = this.potionRemovalCost.get(effect.m_19544_());
                    if (cost == null || !ElectricItem.manager.canUse(itemStack, (cost = Integer.valueOf(cost * (effect.m_19564_() + 1))).intValue())) continue;
                    ElectricItem.manager.use(itemStack, cost.intValue(), null);
                    IUCore.proxy.removePotion((LivingEntity)player, effect.m_19544_());
                }
                boolean Nightvision = nbtData.m_128471_("Nightvision");
                if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = Nightvision = !Nightvision;
                    if (!world.m_5776_()) {
                        nbtData.m_128379_("Nightvision", Nightvision);
                        if (!world.m_5776_()) {
                            if (Nightvision) {
                                IUCore.proxy.messagePlayer(player, "Nightvision enabled.");
                            } else {
                                IUCore.proxy.messagePlayer(player, "Nightvision disabled.");
                            }
                        }
                    }
                }
                if (!world.m_5776_() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.m_128344_("toggleTimer", toggleTimer);
                }
                if (Nightvision && !world.f_46443_ && ElectricItem.manager.use(itemStack, 1.0, (LivingEntity)player)) {
                    int x = Mth.m_14107_((double)player.m_20185_());
                    int z = Mth.m_14107_((double)player.m_20189_());
                    int y = Mth.m_14107_((double)player.m_20186_());
                    BlockPos pos = new BlockPos(x, y, z);
                    int skylight = player.m_9236_().m_46803_(pos);
                    boolean with = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITH);
                    boolean without = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITHOUT);
                    if (without || with) {
                        if (skylight > 8) {
                            IUCore.proxy.removePotion((LivingEntity)player, MobEffects.f_19611_);
                            if (with) {
                                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, true, true));
                            }
                        } else {
                            if (with) {
                                IUCore.proxy.removePotion((LivingEntity)player, MobEffects.f_19610_);
                            }
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0));
                        }
                    } else {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0));
                    }
                    ret = true;
                }
                if (this.listCapability.contains((Object)EnumCapability.FOOD) && ElectricItem.manager.canUse(itemStack, 1000.0) && player.m_36324_().m_38721_()) {
                    int slot = -1;
                    for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                        if (((ItemStack)player.m_150109_().f_35974_.get(i)).m_41619_() || !((ItemStack)player.m_150109_().f_35974_.get(i)).m_41720_().m_41472_()) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(slot);
                        if ((stack = player.m_5584_(world, stack)).m_41613_() <= 0) {
                            player.m_150109_().f_35974_.set(slot, (Object)ItemStack.f_41583_);
                        }
                        ElectricItem.manager.use(itemStack, 1000.0, (LivingEntity)player);
                        ret = true;
                    }
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WATER, itemStack)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 300));
                }
                if (!UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.NIGTHVISION, itemStack)) break;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300));
                break;
            }
            case CHEST: {
                if (nbtData.m_128471_("jetpack")) {
                    player.f_19789_ = 0.0f;
                    if (nbtData.m_128471_("jump") && !nbtData.m_128471_("canFly") && !player.m_150110_().f_35936_ && IUCore.keyboard.isJumpKeyDown(player) && !nbtData.m_128471_("isFlyActive") && toggleTimer == 0) {
                        toggleTimer = 10;
                        nbtData.m_128379_("canFly", true);
                    }
                    nbtData.m_128379_("jump", !player.m_20096_());
                    if (!player.m_20096_()) {
                        if (ElectricItem.manager.canUse(itemStack, 45.0)) {
                            ElectricItem.manager.use(itemStack, 45.0, null);
                        } else {
                            nbtData.m_128379_("jetpack", false);
                        }
                    }
                }
                boolean jetpack = nbtData.m_128471_("jetpack");
                boolean vertical = nbtData.m_128471_("vertical");
                if (this.listCapability.contains((Object)EnumCapability.VERTICAL_FLY) && IUCore.keyboard.isVerticalMode(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = vertical = !vertical;
                    if (!world.m_5776_()) {
                        nbtData.m_128379_("vertical", vertical);
                        if (!world.m_5776_()) {
                            if (vertical) {
                                IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info2"));
                            } else {
                                IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info3"));
                            }
                        }
                    }
                }
                if (vertical && jetpack) {
                    double motion = 0.0;
                    if (IUCore.keyboard.isJumpKeyDown(player)) {
                        motion = 0.3;
                    }
                    if (player.m_6144_()) {
                        motion = -0.3;
                    }
                    Vec3 deltaMotion = player.m_20184_();
                    player.m_20256_(new Vec3(deltaMotion.f_82479_, deltaMotion.f_82480_ + motion, deltaMotion.f_82481_));
                }
                if (IUCore.keyboard.isStreakKeyDown(player) && toggleTimer == 0 && IUItem.spectral_chestplate.getItem() == this) {
                    toggleTimer = 10;
                    if (!world.m_5776_()) {
                        this.save(itemStack, player);
                        CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
                        growingBuffer.writeByte(3);
                        growingBuffer.flip();
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, itemStack), buf -> buf.writeBytes((ByteBuf)growingBuffer));
                    }
                }
                int reTimer = nbtData.m_128451_("reTimer");
                if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY) && reTimer > 0) {
                    nbtData.m_128405_("reTimer", --reTimer);
                }
                if ((this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) && IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0 && reTimer == 0) {
                    toggleTimer = 10;
                    boolean bl = jetpack = !jetpack;
                    if (!world.m_5776_()) {
                        nbtData.m_128379_("jetpack", jetpack);
                        if (jetpack) {
                            if (!world.m_5776_()) {
                                IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info"));
                            }
                            if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                                nbtData.m_128405_("timer", 600);
                            }
                        } else if (!world.m_5776_()) {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"));
                        }
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                    jetpack = nbtData.m_128471_("jetpack");
                    int timer = nbtData.m_128451_("timer");
                    if (timer > 0) {
                        nbtData.m_128405_("timer", --timer);
                    } else if (jetpack) {
                        nbtData.m_128379_("jetpack", false);
                        nbtData.m_128405_("reTimer", 6000);
                        if (!world.m_5776_()) {
                            IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"));
                        }
                    }
                    boolean jetpackUsed = false;
                    if (!jetpack && IUCore.keyboard.isJumpKeyDown(player)) {
                        jetpackUsed = this.useJetpack(player);
                    }
                    if (world.f_46443_ && player == IUCore.proxy.getPlayerInstance()) {
                        if (this.lastJetpackUsed != jetpackUsed) {
                            if (jetpackUsed) {
                                SoundHandler.playSound(player, "JetpackLoop");
                            }
                            this.lastJetpackUsed = jetpackUsed;
                            if (!this.lastJetpackUsed) {
                                SoundHandler.stopSound(EnumSound.JetpackLoop);
                            }
                        }
                        Random rnd = IUCore.random;
                        if (jetpackUsed) {
                            int i;
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)(player.m_20185_() - player.m_20184_().f_82479_) + rnd.nextFloat()), (double)((float)player.m_20186_()), (double)((float)(player.m_20189_() - player.m_20184_().f_82481_) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)((float)(player.m_20185_() - player.m_20184_().f_82479_) + rnd.nextFloat()), (double)((float)player.m_20186_()), (double)((float)(player.m_20189_() - player.m_20184_().f_82481_) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                        }
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.JETPACK)) {
                    boolean jetpackUsed = false;
                    if (!jetpack && IUCore.keyboard.isJumpKeyDown(player)) {
                        jetpackUsed = this.useJetpack(player);
                    }
                    if (world.f_46443_ && player == IUCore.proxy.getPlayerInstance()) {
                        if (this.lastJetpackUsed != jetpackUsed) {
                            if (jetpackUsed) {
                                SoundHandler.playSound(player, "JetpackLoop");
                            }
                            this.lastJetpackUsed = jetpackUsed;
                            if (!this.lastJetpackUsed) {
                                SoundHandler.stopSound(EnumSound.JetpackLoop);
                            }
                        }
                        Random rnd = IUCore.random;
                        if (jetpackUsed) {
                            int i;
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)((float)(player.m_20185_() - player.m_20184_().f_82479_) + rnd.nextFloat()), (double)((float)player.m_20186_()), (double)((float)(player.m_20189_() - player.m_20184_().f_82481_) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                            for (i = 0; i < rnd.nextInt(10); ++i) {
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)((float)(player.m_20185_() - player.m_20184_().f_82479_) + rnd.nextFloat()), (double)((float)player.m_20186_()), (double)((float)(player.m_20189_() - player.m_20184_().f_82481_) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                            }
                        }
                    }
                }
                if (!world.m_5776_() && toggleTimer > 0) {
                    toggleTimer = (byte)(toggleTimer - 1);
                    nbtData.m_128344_("toggleTimer", toggleTimer);
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300));
                }
                player.m_20095_();
                break;
            }
            case LEGS: {
                if (this.listCapability.contains((Object)EnumCapability.SPEED) && ElectricItem.manager.canUse(itemStack, 1000.0) && (player.m_20096_() || player.m_20069_()) && player.m_20142_()) {
                    byte speedTicker = nbtData.m_128445_("speedTicker");
                    if ((speedTicker = (byte)(speedTicker + 1)) >= 10) {
                        speedTicker = 0;
                        ElectricItem.manager.use(itemStack, 1000.0, null);
                        ret = true;
                    }
                    nbtData.m_128344_("speedTicker", speedTicker);
                    float speed = 0.22f;
                    if (player.m_20069_()) {
                        speed = 0.1f;
                        if (IUCore.keyboard.isJumpKeyDown(player)) {
                            player.m_20184_().m_82520_(0.0, (double)0.1f, 0.0);
                        }
                    }
                    this.moveRelative(player, 0.0f, 0.0f, 1.0f, speed);
                }
                if (this.listCapability.contains((Object)EnumCapability.BAGS) && IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isBootsMode(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    if (!world.m_5776_()) {
                        this.save(itemStack, player);
                        CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
                        growingBuffer.writeByte(2);
                        growingBuffer.flip();
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, itemStack), buf -> buf.writeBytes((ByteBuf)growingBuffer));
                    }
                }
                if (this.listCapability.contains((Object)EnumCapability.MAGNET)) {
                    int mode;
                    boolean magnet;
                    boolean bl = magnet = !nbtData.m_128471_("magnet");
                    if (IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isChangeKeyDown(player) && toggleTimer == 0) {
                        toggleTimer = 10;
                        if (!world.m_5776_()) {
                            if (magnet && !world.m_5776_()) {
                                IUCore.proxy.messagePlayer(player, "Magnet enabled.");
                            }
                            if (!magnet && !world.m_5776_()) {
                                IUCore.proxy.messagePlayer(player, "Magnet disabled.");
                            }
                            nbtData.m_128379_("magnet", magnet);
                        }
                    }
                    if (IUCore.keyboard.isLeggingsMode(player) && IUCore.keyboard.isSaveModeKeyDown(player) && toggleTimer == 0) {
                        toggleTimer = 10;
                        if (!world.m_5776_()) {
                            int mode2 = ModUtils.NBTGetInteger(itemStack, "mode1");
                            if (++mode2 > 2 || mode2 < 0) {
                                mode2 = 0;
                            }
                            ModUtils.NBTSetInteger(itemStack, "mode1", mode2);
                            if (!world.m_5776_()) {
                                IUCore.proxy.messagePlayer(player, ChatFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode2));
                            }
                        }
                    }
                    if ((mode = ModUtils.NBTGetInteger(itemStack, "mode1")) != 0) {
                        int radius = 11;
                        AABB axisalignedbb = new AABB(player.m_20185_() - (double)radius, player.m_20186_() - (double)radius, player.m_20189_() - (double)radius, player.m_20185_() + (double)radius, player.m_20186_() + (double)radius, player.m_20189_() + (double)radius);
                        LevelEntityGetter<Entity> list1 = ((LevelInvoker)world).getGetEntities();
                        ArrayList list = Lists.newArrayList();
                        list1.m_142232_(axisalignedbb, p_151522_ -> {
                            if (p_151522_ instanceof ItemEntity) {
                                list.add(p_151522_);
                            }
                        });
                        boolean ret1 = false;
                        for (Entity entityinlist : list) {
                            boolean zcoord;
                            if (!(entityinlist instanceof ItemEntity)) continue;
                            ItemEntity item = (ItemEntity)entityinlist;
                            if (!ElectricItem.manager.canUse(itemStack, 200.0)) continue;
                            if (mode == 1) {
                                item.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0f, 0.0f);
                                if (!player.m_9236_().f_46443_) {
                                    ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                                }
                                item.m_32010_(0);
                                ElectricItem.manager.use(itemStack, 200.0, null);
                                ret1 = true;
                                continue;
                            }
                            if (mode != 2) continue;
                            boolean xcoord = item.m_20185_() + 2.0 >= player.m_20185_() && item.m_20185_() - 2.0 <= player.m_20185_();
                            boolean bl2 = zcoord = item.m_20189_() + 2.0 >= player.m_20189_() && item.m_20189_() - 2.0 <= player.m_20189_();
                            if (xcoord || zcoord) continue;
                            item.m_6027_(player.m_20185_(), player.m_20186_() - 1.0, player.m_20189_());
                            item.m_32010_(10);
                        }
                        if (ret1) {
                            player.f_36096_.m_38946_();
                        }
                    }
                }
                if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SPEED, itemStack)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300));
                }
                if (world.m_5776_() || toggleTimer <= 0) break;
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.m_128344_("toggleTimer", toggleTimer);
                break;
            }
            case FEET: {
                if (!world.m_5776_()) {
                    boolean wasOnGround;
                    boolean bl = wasOnGround = !nbtData.m_128441_("wasOnGround") || nbtData.m_128471_("wasOnGround");
                    if (wasOnGround && !player.m_20096_() && IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isChangeKeyDown(player)) {
                        ElectricItem.manager.use(itemStack, 4000.0, null);
                        ret = true;
                    }
                    if (player.m_20096_() != wasOnGround) {
                        nbtData.m_128379_("wasOnGround", player.m_20096_());
                    }
                    if (ElectricItem.manager.canUse(itemStack, 4000.0) && player.m_20096_()) {
                        this.jumpCharge = 1.0f;
                    }
                    if (player.m_20184_().f_82480_ >= 0.0 && this.jumpCharge > 0.0f && !player.m_20069_()) {
                        if (IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isBootsMode(player)) {
                            Vec3 deltaMovement = player.m_20184_();
                            if (this.jumpCharge == 1.0f) {
                                player.m_20256_(new Vec3(deltaMovement.f_82479_ * 3.5, deltaMovement.f_82480_ + (double)(this.jumpCharge * 0.6f), deltaMovement.f_82481_ * 3.5));
                            }
                            this.jumpCharge = (float)((double)this.jumpCharge * 0.75);
                        } else if (this.jumpCharge < 1.0f) {
                            this.jumpCharge = 0.0f;
                        }
                    }
                }
                if (!UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.JUMP, itemStack)) break;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 300));
            }
        }
        if (ret) {
            player.f_36096_.m_38946_();
        }
    }

    public void save(ItemStack stack, Player player) {
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, Player player) {
        return true;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level p_41422_, List<Component> info, TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, info, p_41424_);
        CompoundTag nbtData = ModUtils.nbt(itemStack);
        if (this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
            info.add((Component)Component.m_237113_((String)(Localization.translate("iu.fly") + " " + ModUtils.Boolean(nbtData.m_128471_("jetpack")))));
        }
        if (!KeyboardIU.isKeyDown(340)) {
            info.add((Component)Component.m_237113_((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            boolean with = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITH);
            boolean without = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_WITHOUT);
            boolean auto = this.listCapability.contains((Object)EnumCapability.NIGHT_VISION_AUTO);
            if (this.listCapability.contains((Object)EnumCapability.SPEED)) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_speed")));
            }
            if (with || without || auto) {
                info.add((Component)Component.m_237113_((String)(Localization.translate("iu.special_armor_nightvision") + KeyboardClient.armormode.getKey().m_84875_().getString())));
                if (with) {
                    info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_nightvision_1")));
                }
                if (without) {
                    info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_nightvision_2")));
                }
                if (auto) {
                    info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_nightvision_3")));
                }
            }
            if (this.listCapability.contains((Object)EnumCapability.BIG_JUMP)) {
                info.add((Component)Component.m_237113_((String)(Localization.translate("iu.special armor big jump") + InputConstants.m_84827_((int)32, (int)32).m_84875_().getString() + " + " + KeyboardClient.bootsmode.getKey().m_84875_().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.AUTO_JUMP)) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_auto_jump")));
            }
            if (this.listCapability.contains((Object)EnumCapability.ACTIVE_EFFECT)) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_active_effect")));
            }
            if (this.listCapability.contains((Object)EnumCapability.ALL_ACTIVE_EFFECT)) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_all_active_effect")));
            }
            if (this.listCapability.contains((Object)EnumCapability.BAGS)) {
                info.add((Component)Component.m_237113_((String)("Open bag: " + KeyboardClient.bootsmode.getKey().m_84875_().getString() + " + " + KeyboardClient.leggingsmode.getKey().m_84875_().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.FLY) || this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.fly_need")));
                info.add((Component)Component.m_237113_((String)(Localization.translate("iu.changemode_fly") + KeyboardClient.flymode.getKey().m_84875_().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.VERTICAL_FLY)) {
                info.add((Component)Component.m_237113_((String)(Localization.translate("iu.vertical") + KeyboardClient.verticalmode.getKey().m_84875_().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.FOOD)) {
                info.add((Component)Component.m_237115_((String)Localization.translate("iu.food_mode_helmet")));
            }
            if (this.listCapability.contains((Object)EnumCapability.JETPACK_FLY)) {
                String time3;
                String time2;
                String time1;
                double seconds;
                double minutes;
                double hours;
                List<Double> time;
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.jetpack_fly_chestplate")));
                CompoundTag nbt = ModUtils.nbt(itemStack);
                int reTimer = nbt.m_128451_("reTimer");
                int timer = nbt.m_128451_("timer");
                if (timer > 0) {
                    time = ModUtils.Time((double)timer / 20.0);
                    hours = 0.0;
                    minutes = 0.0;
                    seconds = 0.0;
                    if (time.size() > 0) {
                        hours = time.get(0);
                        minutes = time.get(1);
                        seconds = time.get(2);
                    }
                    time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
                    time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
                    time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
                    info.add((Component)Component.m_237113_((String)(Localization.translate("iu.timetoend") + time1 + time2 + time3 + " " + Localization.translate("iu.jetpack_fly_chestplate_2"))));
                }
                if (reTimer > 0) {
                    time = ModUtils.Time((double)reTimer / 20.0);
                    hours = 0.0;
                    minutes = 0.0;
                    seconds = 0.0;
                    if (time.size() > 0) {
                        hours = time.get(0);
                        minutes = time.get(1);
                        seconds = time.get(2);
                    }
                    time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
                    time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
                    time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
                    info.add((Component)Component.m_237115_((String)(Localization.translate("iu.timetoend") + time1 + time2 + time3 + " " + Localization.translate("iu.jetpack_fly_chestplate_1"))));
                }
            }
            if (itemStack.m_41720_() == IUItem.spectral_chestplate.getItem()) {
                info.add((Component)Component.m_237113_((String)(Localization.translate("iu.streak") + KeyboardClient.streakmode.getKey().m_84875_().getString())));
            }
            if (this.listCapability.contains((Object)EnumCapability.MAGNET)) {
                info.add((Component)Component.m_237113_((String)(Localization.translate("iu.magnet_mode") + KeyboardClient.changemode.getKey().m_84875_().getString() + " + " + KeyboardClient.leggingsmode.getKey().m_84875_().getString())));
                info.add((Component)Component.m_237113_((String)(Localization.translate("iu.changemode_key") + KeyboardClient.leggingsmode.getKey().m_84875_().getString() + " + " + KeyboardClient.savemode.getKey().m_84875_().getString())));
                int mode = ModUtils.NBTGetInteger(itemStack, "mode1");
                if (mode > 2 || mode < 0) {
                    mode = 0;
                }
                info.add((Component)Component.m_237113_((String)(ChatFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode))));
            }
        }
        ModUtils.mode(itemStack, info);
    }

    public boolean useJetpack(Player player) {
        ItemStack jetpack = (ItemStack)player.m_150109_().f_35975_.get(2);
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = true;
        float power = 0.7f;
        float dropPercentage = 0.05f;
        if (this.getCharge(jetpack) / this.getMaxEnergy(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxEnergy(jetpack) * (double)dropPercentage)));
        }
        if (IUCore.keyboard.isForwardKeyDown(player)) {
            float retruster = 0.15f;
            float forwardpower = power * (retruster += 0.15f) * 2.0f;
            if (forwardpower > 0.0f) {
                player.m_19920_(0.0f, new Vec3(0.0, (double)(0.4f * forwardpower), (double)0.02f));
            }
        }
        int worldHeight = player.m_9236_().m_141928_();
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        double y = player.m_20186_();
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        Vec3 affectedMotion = player.m_20184_();
        double moveY = Math.min(affectedMotion.f_82480_ + (double)(power * 0.2f), (double)0.6f);
        player.m_20334_(affectedMotion.f_82479_, moveY, affectedMotion.f_82481_);
        int consume = 2;
        consume += 6;
        if (!player.m_20096_()) {
            this.use(jetpack, consume);
        }
        player.f_19789_ = 0.0f;
        player.f_19787_ = 0.0f;
        return true;
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getEntity() instanceof LivingEntity) {
            LivingEntity entity = event.getEntity();
            ItemStack armor = entity.m_6844_(EquipmentSlot.FEET);
            if (armor.m_41720_() == this) {
                int fallDamage = Math.max((int)event.getDistance() - 10, 0);
                double energyCost = this.armor.getDamageEnergy() * (double)fallDamage * (1.0 - (double)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FALLING_DAMAGE, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FALLING_DAMAGE, (ItemStack)armor).number : 0) * 0.25);
                if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                    ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                    event.setCanceled(true);
                }
            }
            if (entity instanceof Player && entity.m_6844_(EquipmentSlot.CHEST).m_41720_() == this && entity.getPersistentData().m_128471_("isFlyActive")) {
                event.setCanceled(true);
            }
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack var1) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack var1) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack var1) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack var1) {
        return this.transferLimit;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.f_19315_ && this.f_40377_.m_20749_() == 0) {
            int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
            int energyPerDamage = (int)(this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect);
            int damageLimit = Integer.MAX_VALUE;
            if (energyPerDamage > 0) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int energyPerDamage = (int)(this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect);
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(10, absorptionRatio, damageLimit);
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public int getArmorDisplay(Player player, @Nonnull ItemStack armor, int slot) {
        return ElectricItem.manager.getCharge(armor) >= this.armor.getDamageEnergy() ? (int)Math.round(40.0 * this.getBaseAbsorptionRatio()) : 0;
    }

    private double getBaseAbsorptionRatio() {
        switch (this.f_40377_) {
            case FEET: {
                return this.armor.getArmorMulDamage().getBootsMul();
            }
            case HEAD: {
                return this.armor.getArmorMulDamage().getHeadMul();
            }
            case CHEST: {
                return this.armor.getArmorMulDamage().getChestMul();
            }
            case LEGS: {
                return this.armor.getArmorMulDamage().getLeggingsMul();
            }
        }
        return 1.0;
    }

    @Override
    public void damageArmor(LivingEntity entity, @NotNull ItemStack stack, DamageSource source, float damage, int slot) {
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)stack).number : 0;
        ElectricItem.manager.discharge(stack, (double)damage * (this.armor.getDamageEnergy() - this.armor.getDamageEnergy() * 0.2 * (double)protect), Integer.MAX_VALUE, true, false, false);
    }
}

