/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.bee.IBee;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.IProperties;
import com.denfop.items.ItemMain;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemJarBees<T extends Enum<T>>
extends ItemMain<T>
implements IProperties {
    public ItemJarBees(T element) {
        super(new Item.Properties().m_41491_(IUCore.BeesTab), element);
        IUCore.proxy.addProperties(this);
    }

    public ItemStack getStackFromId(int id) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("bee_id", id);
        return stack;
    }

    public static IBee getBee(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        IBee bee = BeeNetwork.instance.getBee(nbt.m_128451_("bee_id"));
        if (bee == null) {
            return null;
        }
        return bee.copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"iu.use_bee_analyzer").m_7220_((Component)Component.m_237115_((String)IUItem.bee_analyzer.getItem().m_5524_())));
        tooltip.add((Component)Component.m_237115_((String)"iu.bee_negative"));
        IBee bee = ItemJarBees.getBee(stack);
        if (bee != null) {
            List<IBee> unCompatibleBees = bee.getUnCompatibleBees();
            for (IBee bee1 : unCompatibleBees) {
                tooltip.add((Component)Component.m_237115_((String)("bee_" + bee1.getName())));
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("bee_id")) {
            IBee crop = BeeNetwork.instance.getBee(tag.m_128451_("bee_id"));
            return Component.m_237115_((String)super.m_5671_(stack)).m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("bee_" + crop.getName())));
        }
        return Component.m_237115_((String)super.m_5671_(stack));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            BeeNetwork.instance.getBeeMap().forEach((id, crop) -> {
                ItemStack stack = new ItemStack((ItemLike)this);
                CompoundTag tag = stack.m_41784_();
                tag.m_128405_("bee_id", id.intValue());
                items.add((Object)stack);
            });
        }
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(itemStack);
        return nbt.m_128451_("bee_id");
    }

    public static enum Types implements ISubEnum
    {
        bees;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        private Types() {
            this.ID = this.ordinal();
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "jar_bee";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

