/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.crop;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.ItemMain;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemCrops<T extends Enum<T>>
extends ItemMain<T>
implements ICropItem {
    public ItemCrops(T element) {
        super(new Item.Properties().m_41491_(IUCore.CropsTab), element);
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.crops.seeds";
        }
        return this.nameItem;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"iu.use_agriculture_analyzer").m_7220_((Component)Component.m_237115_((String)IUItem.agricultural_analyzer.getItem().m_5524_())));
        super.m_7373_(stack, level, tooltip, flag);
        ICrop crop = this.getCrop(0, stack);
        if (crop.getId() != 3) {
            ItemStack drop;
            ItemStack soil = crop.getSoil().getStack();
            if (!soil.m_41619_()) {
                tooltip.add((Component)Component.m_237115_((String)"iu.crop.oneprobe.soil").m_130946_(" ").m_7220_(soil.m_41786_()).m_130940_(ChatFormatting.YELLOW));
            }
            if (!crop.getDrops().isEmpty() && !(drop = crop.getDrops().get(0)).m_41619_()) {
                tooltip.add((Component)Component.m_237115_((String)"iu.crop.oneprobe.drop").m_130946_(" ").m_7220_(drop.m_41786_()).m_130940_(ChatFormatting.AQUA));
            }
            if (!crop.getCropCombine().isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"iu.crop.breeding").m_130940_(ChatFormatting.GREEN));
                for (ICrop crop1 : crop.getCropCombine()) {
                    tooltip.add((Component)Component.m_237115_((String)("crop." + crop1.getName())));
                }
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = ModUtils.nbt(stack);
        ICrop crop = CropNetwork.instance.getCrop(tag.m_128451_("crop_id"));
        return Component.m_237115_((String)super.m_5671_(stack)).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)("crop." + crop.getName())));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            CropNetwork.instance.getCropMap().forEach((id, crop) -> {
                if (id != 3) {
                    ItemStack stack = new ItemStack((ItemLike)this);
                    CompoundTag tag = ModUtils.nbt(stack);
                    tag.m_128405_("crop_id", id.intValue());
                    new Genome(stack);
                    items.add((Object)stack);
                }
            });
        }
    }

    @Override
    public ICrop getCrop(int meta, ItemStack stack) {
        CompoundTag tag = ModUtils.nbt(stack);
        return CropNetwork.instance.getCrop(tag.m_128451_("crop_id"));
    }

    public static enum Types implements ISubEnum
    {
        crop;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        private Types() {
            this.ID = this.ordinal();
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "crops";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

