/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.energy.EntityAdvArrow;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.eventbus.api.Event;

public class ItemEnergyBow
extends BowItem
implements IEnergyItem,
IUpgradeItem,
IProperties {
    static final int[] CHARGE = new int[]{1500, 750, 2000, 5000, 1000};
    static final String[] MODE = new String[]{"normal", "rapidfire", "spread", "sniper", "flame"};
    private final float type;
    private final String name;
    private final double nanoBowBoost;
    private final int tier;
    private final int transferenergy;
    private final int maxenergy;
    private String nameItem;

    public ItemEnergyBow(String name, double nanoBowBoost, int tier, int transferenergy, int maxenergy, float type) {
        super(new Item.Properties().m_41487_(1).m_41491_(IUCore.EnergyTab));
        this.name = name;
        this.nanoBowBoost = nanoBowBoost;
        this.tier = tier;
        this.transferenergy = transferenergy;
        this.maxenergy = maxenergy;
        this.type = type;
        if (this.properties().length > 0) {
            IUCore.proxy.addProperties(this);
        }
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BOW.list));
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.5f);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        CompoundTag nbt = ModUtils.nbt(stack);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, stack));
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity livingEntity, int i) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag nbt = ModUtils.nbt(stack);
        int mode = nbt.m_128451_("bowMode");
        if (mode == 1) {
            int bowEnergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
            int j = this.m_8105_(stack) - i;
            if (j >= 10 && ElectricItem.manager.canUse(stack, (double)CHARGE[1] - (double)CHARGE[1] * 0.1 * (double)bowEnergy)) {
                this.m_5551_(stack, livingEntity.f_19853_, livingEntity, i);
                player.m_5810_();
            }
        }
    }

    @Override
    public String[] properties() {
        return new String[]{"pulling", "pull", "mode"};
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        int bowenergy;
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = stack.m_41784_();
        int mode = nbt.m_128451_("bowMode");
        int n = bowenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            if (!world.f_46443_) {
                if (++mode >= CHARGE.length) {
                    mode = 0;
                }
                nbt.m_128405_("bowMode", mode);
            }
            if (!world.f_46443_) {
                IUCore.proxy.messagePlayer(player, Localization.translate("info.nanobow." + MODE[mode]));
            }
        } else if (player.m_150110_().f_35937_ || ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
            player.m_6672_(hand);
        }
        ArrowNockEvent event = new ArrowNockEvent(player, stack, hand, world, false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.getAction();
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_5551_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull LivingEntity entityLiving, int timeLeft) {
        float f;
        if (!(entityLiving instanceof Player)) {
            super.m_5551_(stack, world, entityLiving, timeLeft);
            return;
        }
        Player player = (Player)entityLiving;
        CompoundTag nbt = stack.m_41784_();
        int mode = nbt.m_128451_("bowMode");
        int charge = this.getMaxItemUseDuration(stack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        charge = event.getCharge();
        if (mode == 3) {
            charge /= 2;
        }
        if (mode == 1) {
            charge *= 4;
        }
        if ((double)(f = ItemEnergyBow.getArrowVelocity(charge)) < 0.1) {
            return;
        }
        if (!world.f_46443_) {
            int bowenergy;
            EntityAdvArrow arrow = this.createArrow(world, stack, (LivingEntity)player);
            arrow = this.customArrow((AbstractArrow)arrow);
            arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 1.0f);
            if (f == 1.5f) {
                arrow.m_36762_(true);
            }
            int bowdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWDAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWDAMAGE, (ItemStack)stack).number : 0;
            arrow.m_36781_(arrow.m_36789_() + (double)this.type * 2.5 + 0.5 + (double)this.type * 2.5 * 0.25 * (double)bowdamage);
            int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
            if (j > 0) {
                arrow.m_36781_(arrow.m_36789_() + (double)j * 0.5 + 0.5);
            }
            if (mode == 0 && arrow.m_36792_()) {
                j += 3;
            } else if (mode == 1 && arrow.m_36792_()) {
                ++j;
            } else if (mode == 3 && arrow.m_36792_()) {
                j += 8;
            }
            if (j > 0) {
                arrow.m_36781_(arrow.m_36789_() + (double)j * 0.5 + 0.5);
            }
            if (this.nanoBowBoost > 0.0) {
                arrow.m_36781_(arrow.m_36789_() + this.nanoBowBoost * 0.5 + 0.5);
            }
            int k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
            if (mode == 0 && arrow.m_36792_()) {
                ++k;
            } else if (mode == 3 && arrow.m_36792_()) {
                k += 5;
            }
            if (k > 0) {
                arrow.m_36735_(k);
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack) > 0) {
                arrow.m_20254_(100);
            }
            if (mode == 4 && arrow.m_36792_()) {
                arrow.m_20254_(2000);
            }
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            int n = bowenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
            if (mode == 2) {
                if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                    ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (LivingEntity)player);
                    new PacketSoundPlayer(EnumSound.bow, player);
                    world.m_7967_((Entity)arrow);
                    if (arrow.m_36792_()) {
                        this.spawnAdditionalArrows(world, player, f, arrow);
                    }
                }
            } else if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (LivingEntity)player);
                new PacketSoundPlayer(EnumSound.bow, player);
                world.m_7967_((Entity)arrow);
            }
        }
    }

    private void spawnAdditionalArrows(Level world, Player player, float f, Arrow originalArrow) {
        for (int i = 0; i < 4; ++i) {
            EntityAdvArrow arrow = this.createArrow(world, player.m_21120_(InteractionHand.MAIN_HAND), (LivingEntity)player);
            arrow = this.customArrow((AbstractArrow)arrow);
            arrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f, 1.0f);
            arrow.m_36781_(f * 2.0f);
            arrow.m_20343_(originalArrow.m_20185_() + (double)(i - 2) * 0.25, originalArrow.m_20186_(), originalArrow.m_20189_());
            arrow.m_36762_(true);
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            world.m_7967_((Entity)arrow);
        }
    }

    public int getMaxItemUseDuration(@Nonnull ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        switch (nbt.m_128451_("bowMode")) {
            case 3: 
            case 5: {
                return 144000;
            }
            case 1: {
                return 18000;
            }
        }
        return 72000;
    }

    public EntityAdvArrow customArrow(AbstractArrow arrow) {
        return (EntityAdvArrow)arrow;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel world, LivingEntity entityIn, int p174679, String property) {
        if (property.equals("pulling")) {
            return entityIn != null && entityIn.m_6117_() && entityIn.m_21211_() == stack ? 1.0f : 0.0f;
        }
        if (property.equals("mode")) {
            CompoundTag nbt = ModUtils.nbt(stack);
            if (nbt.m_128461_("mode").isEmpty()) {
                return -1.0f;
            }
            String[] mode = new String[]{"Zelen", "Demon", "Dark", "Cold", "Ender", "Ukraine", "Fire", "Snow", "Taiga", "Desert", "Emerald"};
            for (int i = 0; i < mode.length; ++i) {
                if (!nbt.m_128461_("mode").equals(mode[i])) continue;
                return i;
            }
        }
        if (entityIn == null) {
            return 0.0f;
        }
        return !(entityIn.m_21211_().m_41720_() instanceof BowItem) ? 0.0f : (float)(stack.m_41779_() - entityIn.m_21212_()) / 20.0f;
    }

    public EntityAdvArrow createArrow(Level worldIn, ItemStack stack, LivingEntity shooter) {
        EntityAdvArrow entitytippedarrow = new EntityAdvArrow(worldIn, shooter);
        entitytippedarrow.m_36878_(stack);
        entitytippedarrow.setStack(stack);
        return entitytippedarrow;
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"iu.changemode_key").m_7220_(KeyboardClient.changemode.getKey().m_84875_()).m_7220_((Component)Component.m_237115_((String)"iu.changemode_rcm")));
        }
        switch (this.tier) {
            case 2: {
                tooltip.add((Component)Component.m_237115_((String)"iu.bow.maxdamage").m_130946_(String.valueOf(47)));
                break;
            }
            case 3: {
                tooltip.add((Component)Component.m_237115_((String)"iu.bow.maxdamage").m_130946_(String.valueOf(56)));
                break;
            }
            case 4: {
                tooltip.add((Component)Component.m_237115_((String)"iu.bow.maxdamage").m_130946_(String.valueOf(71)));
            }
        }
        ModUtils.mode(stack, tooltip);
        super.m_7373_(stack, world, tooltip, flag);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxenergy;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferenergy;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.BOW.list;
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_220152_(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public int m_6473_() {
        return 0;
    }
}

