/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.armour.special.ItemSpecialArmor;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;

public class ItemKatana
extends DiggerItem
implements IEnergyItem,
IUpgradeItem,
IProperties {
    public final int maxCharge;
    public final int transferLimit;
    public final int f_43306_;
    public int damage1 = 13;
    private int soundTicker = 0;
    private String nameItem;

    public ItemKatana() {
        super(1.0f, 2.0f, (Tier)Tiers.DIAMOND, null, new Item.Properties().setNoRepair().m_41491_(IUCore.EnergyTab).setNoRepair().m_41487_(1));
        this.maxCharge = 500000;
        this.transferLimit = 5000;
        this.f_43306_ = 4;
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SABERS.list));
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.katana";
        }
        return this.nameItem;
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_220152_(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    @Override
    public String[] properties() {
        return new String[]{"type"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel world, LivingEntity entityIn, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(stack);
        switch (nbt.m_128461_("type")) {
            case "": {
                return 0.0f;
            }
            case "yellow": {
                return 0.25f;
            }
            case "green": {
                return 0.5f;
            }
            case "pink": {
                return 0.75f;
            }
        }
        return 0.0f;
    }

    public boolean drainSaber(ItemStack itemStack, double amount) {
        int saberenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABERENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABERENERGY, (ItemStack)itemStack).number : 0;
        return ElectricItem.manager.use(itemStack, amount - amount * 0.15 * (double)saberenergy, null);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
        int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)dmg, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public boolean m_7579_(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity source) {
        if (!target.m_9236_().f_46443_) {
            if (!this.drainSaber(stack, 400.0)) {
                return false;
            }
            int vampires = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.VAMPIRES, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.VAMPIRES, (ItemStack)stack).number : 0;
            boolean wither = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WITHER, stack);
            boolean poison = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.POISON, stack);
            if (vampires > 0) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 40, vampires));
            }
            if (wither) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60));
            }
            if (poison) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.HUNGRY, stack)) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60));
            }
            if (source instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)source;
                new PacketSoundPlayer("katana", (Player)player);
                CompoundTag nbtData = stack.m_41784_();
                boolean iaidoActive = nbtData.m_128471_("iaidoMode");
                if (iaidoActive) {
                    player.m_36335_().m_41524_((Item)this, 60);
                }
            }
            if (!(source instanceof ServerPlayer) || !(target instanceof Player) || ((ServerPlayer)source).m_7099_((Player)target)) {
                Iterator armorSlots = Arrays.stream(EquipmentSlot.values()).filter(slot -> slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND).iterator();
                while (armorSlots.hasNext()) {
                    EquipmentSlot slot2 = (EquipmentSlot)armorSlots.next();
                    if (!ElectricItem.manager.canUse(stack, 2000.0)) break;
                    ItemStack armor = target.m_6844_(slot2);
                    if (armor.m_41619_()) continue;
                    double amount = 0.0;
                    Item item = armor.m_41720_();
                    if (item instanceof ItemSpecialArmor) {
                        ItemSpecialArmor specialArmor = (ItemSpecialArmor)item;
                        amount = specialArmor.getArmor().getDamageEnergy();
                    }
                    if (!(amount > 0.0)) continue;
                    ElectricItem.manager.discharge(armor, amount, this.f_43306_, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        target.m_8061_(slot2, ItemStack.f_41583_);
                    }
                    this.drainSaber(stack, 2000.0);
                }
            }
        }
        return true;
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int slot, boolean p_41408_) {
        super.m_6883_(itemStack, world, entity, slot, p_41408_);
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.f_46443_) {
                ItemCooldowns cooldownTracker = player.m_36335_();
                nbt.m_128379_("cooldown", cooldownTracker.m_41519_(itemStack.m_41720_()));
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag nbt = stack.m_41784_();
        if (!IUCore.keyboard.isChangeKeyDown(player)) {
            switch (nbt.m_128461_("type")) {
                case "": {
                    nbt.m_128359_("type", "yellow");
                    break;
                }
                case "yellow": {
                    nbt.m_128359_("type", "green");
                    break;
                }
                case "green": {
                    nbt.m_128359_("type", "pink");
                    break;
                }
                case "pink": {
                    nbt.m_128359_("type", "");
                }
            }
        } else {
            nbt.m_128379_("iaidoMode", !nbt.m_128471_("iaidoMode"));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.f_43306_;
    }

    protected void removeAudioSource() {
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SABERS.list;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        this.removeAudioSource();
        return super.onDroppedByPlayer(item, player);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"iu.changemode_key").m_7220_((Component)Component.m_237115_((String)Localization.translate("iu.changemode_rcm1"))));
            tooltip.add((Component)Component.m_237115_((String)"iu.changemode_key").m_7220_(KeyboardClient.changemode.getKey().m_84875_()).m_7220_((Component)Component.m_237115_((String)"iu.changemode_rcm")));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

