/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.audio.SoundHandler;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.network.packet.PacketStopSoundPlayer;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;

public class ItemNanoSaber
extends DiggerItem
implements IEnergyItem,
IUpgradeItem,
IProperties {
    public static int ticker = 0;
    public final int maxCharge;
    public final int transferLimit;
    public final int f_43306_;
    private final int damage1;
    public int activedamage;
    private int soundTicker = 0;
    private boolean wasEquipped;
    private String nameItem;

    public ItemNanoSaber(int maxCharge, int transferLimit, int tier, int activedamage1, int damage) {
        super(0.0f, 2.0f, (Tier)Tiers.DIAMOND, null, new Item.Properties().setNoRepair().m_41491_(IUCore.EnergyTab).setNoRepair().m_41487_(1));
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.f_43306_ = tier;
        this.activedamage = activedamage1;
        this.damage1 = damage;
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SABERS.list));
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.nano_saber";
        }
        return this.nameItem;
    }

    private static boolean isActive(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        return ItemNanoSaber.isActive(nbt);
    }

    private static boolean isActive(CompoundTag nbt) {
        return nbt.m_128471_("active");
    }

    private static void setActive(CompoundTag nbt, boolean active) {
        nbt.m_128379_("active", active);
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_220152_(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    @Override
    public String[] properties() {
        return new String[]{"active"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel world, LivingEntity entityIn, int p174679, String property) {
        return ModUtils.nbt(stack).m_128471_("active") ? 1.0f : 0.0f;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public String getRandomSwingSound() {
        switch (IUCore.random.nextInt(3)) {
            default: {
                return "nanosabreswing1";
            }
            case 1: {
                return "nanosabreswing2";
            }
            case 2: 
        }
        return "nanosabreswing3";
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        if (ItemNanoSaber.isActive(itemstack)) {
            this.drainSaber(itemstack, 80.0, (LivingEntity)player);
        }
        return false;
    }

    public void drainSaber(ItemStack itemStack, double amount, LivingEntity entity) {
        int saberenergy;
        int n = saberenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABERENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABERENERGY, (ItemStack)itemStack).number : 0;
        if (!ElectricItem.manager.use(itemStack, amount - amount * 0.15 * (double)saberenergy, entity)) {
            CompoundTag nbtData = ModUtils.nbt(itemStack);
            nbtData.m_128379_("active", false);
        }
    }

    protected String getIdleSound() {
        return "NanosabreIdle".toLowerCase();
    }

    protected String getStartSound() {
        return "NanosabrePowerup".toLowerCase();
    }

    protected void removeAudioSource() {
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        CompoundTag nbt = stack.m_41784_();
        if (!IUCore.keyboard.isChangeKeyDown(player)) {
            if (ItemNanoSaber.isActive(nbt)) {
                ItemNanoSaber.setActive(nbt, false);
                new PacketStopSoundPlayer(EnumSound.NanosabreIdle, player);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            if (ElectricItem.manager.canUse(stack, 16.0)) {
                ItemNanoSaber.setActive(nbt, true);
                new PacketSoundPlayer(this.getStartSound(), player);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            return super.m_7203_(world, player, hand);
        }
        int mode = nbt.m_128451_("attackMode");
        nbt.m_128405_("attackMode", mode == 0 ? 1 : 0);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"iu.changemode_key").m_7220_(KeyboardClient.changemode.getKey().m_84875_()).m_7220_((Component)Component.m_237115_((String)"iu.changemode_rcm")));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        CompoundTag nbtData;
        if (slot != EquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(slot, stack);
        }
        int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
        int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
        if (ElectricItem.manager.canUse(stack, 400.0) && (nbtData = ModUtils.nbt(stack)).m_128471_("active")) {
            dmg = (int)((double)this.activedamage + (double)this.activedamage * 0.15 * (double)saberdamage);
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)dmg, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int slot, boolean p_41408_) {
        CompoundTag nbtData;
        super.m_6883_(itemStack, world, entity, slot, p_41408_);
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
        if (world.f_46443_ && ItemNanoSaber.isActive(itemStack) && world.m_46467_() % 20L == 0L) {
            SoundHandler.playSound(IUCore.proxy.getPlayerInstance(), this.getIdleSound());
        }
        if (!(nbtData = ModUtils.nbt(itemStack)).m_128471_("active")) {
            return;
        }
        if (ticker % 16 == 0 && entity instanceof ServerPlayer) {
            if (slot < 9) {
                this.drainSaber(itemStack, 64.0, (LivingEntity)((ServerPlayer)entity));
            } else if (ticker % 64 == 0) {
                this.drainSaber(itemStack, 16.0, (LivingEntity)((ServerPlayer)entity));
            }
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        this.removeAudioSource();
        return super.onDroppedByPlayer(item, player);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity source) {
        CompoundTag nbtData = ModUtils.nbt(stack);
        if (!nbtData.m_128471_("active")) {
            return true;
        }
        if (!target.m_9236_().f_46443_) {
            this.drainSaber(stack, 400.0, source);
            int vampires = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.VAMPIRES, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.VAMPIRES, (ItemStack)stack).number : 0;
            boolean wither = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WITHER, stack);
            boolean poison = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.POISON, stack);
            if (vampires != 0) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 40, vampires));
            }
            if (wither) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60));
            }
            if (poison) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.HUNGRY, stack)) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60));
            }
            if (source instanceof ServerPlayer) {
                new PacketSoundPlayer(this.getRandomSwingSound(), (Player)source);
            }
            int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
            int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
            int attackMode = nbtData.m_128451_("attackMode");
            if (ElectricItem.manager.canUse(stack, 400.0)) {
                CompoundTag nbtData1 = ModUtils.nbt(stack);
                if (nbtData1.m_128471_("active")) {
                    dmg = (int)((double)this.activedamage + (double)this.activedamage * 0.15 * (double)saberdamage);
                }
                if (attackMode != 0) {
                    this.areaAttack(stack, target, source, 2, dmg);
                }
            }
        }
        return true;
    }

    private void areaAttack(ItemStack stack, LivingEntity target, LivingEntity source, int radius, double damage) {
        List entities = source.f_19853_.m_45976_(LivingEntity.class, source.m_20191_().m_82400_((double)radius));
        for (LivingEntity entity : entities) {
            if (entity == source || entity == target) continue;
            entity.m_6469_(DamageSource.m_19344_((Player)((Player)source)), (float)damage);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.f_43306_;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SABERS.list;
    }
}

