/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.componets.AbstractComponent;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class ItemPurifier
extends BaseEnergyItem
implements IUpgradeItem {
    public ItemPurifier(double maxCharge, double transferLimit, int tier) {
        super(maxCharge, transferLimit, tier);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, EnumUpgrades.PURIFIER.list));
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)Registry.f_122827_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.PURIFIER.list;
    }

    public void m_6883_(ItemStack itemStack, Level p_77663_2_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(itemStack, p_77663_2_, p_41406_, p_41407_, p_41408_);
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Object base;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Direction side = context.m_43719_();
        ItemStack itemstack = context.m_43722_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileEntityInventory) && !(tile instanceof IManufacturerBlock)) {
            return InteractionResult.PASS;
        }
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, itemstack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)itemstack).number * 0.25 : 0.0);
        if (tile instanceof TileEntityBlock) {
            base = (TileEntityBlock)tile;
            double energy = 10000.0;
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PURIFIER, itemstack)) {
                energy = 0.0;
            }
            if (!((TileEntityBlock)((Object)base)).canEntityDestroy((Entity)player)) {
                return InteractionResult.FAIL;
            }
            for (AbstractComponent component : ((TileEntityBlock)((Object)base)).getComponentList()) {
                if (!component.canUsePurifier(player) || !ElectricItem.manager.canUse(itemstack, energy * coef)) continue;
                component.workPurifier();
                return InteractionResult.SUCCESS;
            }
        }
        if (tile instanceof TileMultiMachine) {
            base = (TileMultiMachine)tile;
            if (!ElectricItem.manager.canUse(itemstack, 500.0 * coef)) {
                return InteractionResult.PASS;
            }
            if (!player.m_6047_()) {
                this.dropModules(world, player, (TileMultiMachine)base);
            } else {
                this.dropAllModules(world, player, (TileMultiMachine)base);
            }
            ElectricItem.manager.use(itemstack, 500.0 * coef, (LivingEntity)player);
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof IManufacturerBlock) {
            base = (IManufacturerBlock)tile;
            if (player.m_6047_()) {
                this.dropUpgrade(world, player, (IManufacturerBlock)base);
            } else {
                this.dropSingleUpgrade(world, player, (IManufacturerBlock)base);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void dropModules(Level world, Player player, TileMultiMachine base) {
        this.dropItem(world, player, base.multi_process.quickly ? new ItemStack((ItemLike)IUItem.module_quickly.getItem()) : ItemStack.f_41583_);
        this.dropItem(world, player, base.multi_process.modulesize ? new ItemStack((ItemLike)IUItem.module_stack.getItem()) : ItemStack.f_41583_);
        this.dropItem(world, player, base.solartype != null ? new ItemStack((ItemLike)IUItem.module6.getStack(base.solartype.meta), 1) : ItemStack.f_41583_);
        this.dropItem(world, player, base.multi_process.modulestorage ? new ItemStack((ItemLike)IUItem.module_storage.getItem()) : ItemStack.f_41583_);
        this.dropItem(world, player, base.multi_process.module_infinity_water ? new ItemStack((ItemLike)IUItem.module_infinity_water.getItem()) : ItemStack.f_41583_);
        this.dropItem(world, player, base.multi_process.module_separate ? new ItemStack((ItemLike)IUItem.module_separate.getItem()) : ItemStack.f_41583_);
    }

    private void dropAllModules(Level world, Player player, TileMultiMachine base) {
        this.dropModules(world, player, base);
    }

    private void dropUpgrade(Level world, Player player, IManufacturerBlock base) {
        int level = base.getLevelMechanism();
        if (level > 0) {
            this.dropItem(world, player, new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), level));
            base.setLevelMech(0);
        }
    }

    private void dropSingleUpgrade(Level world, Player player, IManufacturerBlock base) {
        if (base.getLevelMechanism() > 0) {
            this.dropItem(world, player, new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), 1));
            base.removeLevel(1);
        }
    }

    private void dropItem(Level world, Player player, ItemStack stack) {
        if (!stack.m_41619_() && !world.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
            itemEntity.m_32010_(0);
            world.m_7967_((Entity)itemEntity);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

