/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.space;

import com.denfop.IUCore;
import com.denfop.api.space.colonies.api.IBuildingItem;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.IColonyBuilding;
import com.denfop.api.space.colonies.api.building.IBuildingHouse;
import com.denfop.api.space.colonies.api.building.IFactory;
import com.denfop.api.space.colonies.building.ColonyEntertainment;
import com.denfop.api.space.colonies.building.ColonyHouse;
import com.denfop.api.space.colonies.building.ColonyPanelFactory;
import com.denfop.api.space.colonies.building.Factory;
import com.denfop.api.space.colonies.building.FluidFactory;
import com.denfop.api.space.colonies.building.ItemFactory;
import com.denfop.api.space.colonies.building.OxygenFactory;
import com.denfop.api.space.colonies.building.ProtectionBuilding;
import com.denfop.api.space.colonies.building.StorageBuilding;
import com.denfop.api.space.colonies.enums.EnumEntertainment;
import com.denfop.api.space.colonies.enums.EnumHouses;
import com.denfop.api.space.colonies.enums.EnumMiningFactory;
import com.denfop.api.space.colonies.enums.EnumProtectionLevel;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.api.space.colonies.enums.EnumTypeFactory;
import com.denfop.api.space.colonies.enums.EnumTypeOxygenFactory;
import com.denfop.api.space.colonies.enums.EnumTypeSolarPanel;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.ItemMain;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemColonialBuilding<T extends Enum<T>>
extends ItemMain<T>
implements IBuildingItem {
    public ItemColonialBuilding(T element) {
        super(new Item.Properties().m_41491_(IUCore.SpaceTab), element);
    }

    public static EnumTypeUpgrade getType(int meta) {
        return EnumTypeUpgrade.getFromID(meta);
    }

    @Override
    public EnumTypeBuilding getBuilding(ItemStack stack) {
        switch (((ISubEnum)this.getElement()).getId()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return EnumTypeBuilding.PROTECTION;
            }
            case 4: 
            case 5: 
            case 6: {
                return EnumTypeBuilding.HOUSES;
            }
            case 19: 
            case 24: 
            case 25: {
                return EnumTypeBuilding.OXYGEN;
            }
            case 20: {
                return EnumTypeBuilding.STORAGE;
            }
            case 16: 
            case 17: 
            case 18: {
                return EnumTypeBuilding.GENERATORS;
            }
            case 21: 
            case 22: 
            case 23: {
                return EnumTypeBuilding.ENTERTAINMENT;
            }
        }
        return EnumTypeBuilding.FABRIC;
    }

    @Override
    public IColonyBuilding getBuilding(IColony colony, ItemStack stack, boolean simulate) {
        EnumTypeBuilding building = this.getBuilding(stack);
        switch (building) {
            case HOUSES: {
                EnumHouses houses = null;
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 4: {
                        houses = EnumHouses.LOW;
                        break;
                    }
                    case 5: {
                        houses = EnumHouses.MEDIUM;
                        break;
                    }
                    case 6: {
                        houses = EnumHouses.HIGH;
                    }
                }
                assert (houses != null);
                return new ColonyHouse(houses, colony, simulate);
            }
            case PROTECTION: {
                EnumProtectionLevel protectionLevel = null;
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 0: {
                        protectionLevel = EnumProtectionLevel.LOW;
                        break;
                    }
                    case 1: {
                        protectionLevel = EnumProtectionLevel.MEDIUM;
                        break;
                    }
                    case 2: {
                        protectionLevel = EnumProtectionLevel.HIGH;
                        break;
                    }
                    case 3: {
                        protectionLevel = EnumProtectionLevel.VERY_HIGH;
                    }
                }
                assert (protectionLevel != null);
                return new ProtectionBuilding(protectionLevel, colony, simulate);
            }
            case STORAGE: {
                return new StorageBuilding(colony, simulate);
            }
            case OXYGEN: {
                EnumTypeOxygenFactory oxygenFactory = null;
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 19: {
                        oxygenFactory = EnumTypeOxygenFactory.LOW;
                        break;
                    }
                    case 24: {
                        oxygenFactory = EnumTypeOxygenFactory.MEDIUM;
                        break;
                    }
                    case 25: {
                        oxygenFactory = EnumTypeOxygenFactory.HIGH;
                    }
                }
                return new OxygenFactory(colony, oxygenFactory, simulate);
            }
            case ENTERTAINMENT: {
                EnumEntertainment entertainment = null;
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 21: {
                        entertainment = EnumEntertainment.LOW;
                        break;
                    }
                    case 22: {
                        entertainment = EnumEntertainment.MEDIUM;
                        break;
                    }
                    case 23: {
                        entertainment = EnumEntertainment.HIGH;
                    }
                }
                assert (entertainment != null);
                return new ColonyEntertainment(entertainment, colony, simulate);
            }
            case GENERATORS: {
                EnumTypeSolarPanel solarPanel = null;
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 16: {
                        solarPanel = EnumTypeSolarPanel.LOW;
                        break;
                    }
                    case 17: {
                        solarPanel = EnumTypeSolarPanel.MEDIUM;
                        break;
                    }
                    case 18: {
                        solarPanel = EnumTypeSolarPanel.HIGH;
                    }
                }
                assert (solarPanel != null);
                return new ColonyPanelFactory(colony, solarPanel, simulate);
            }
            case FABRIC: {
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 13: {
                        return new Factory(colony, EnumTypeFactory.LOW, simulate);
                    }
                    case 14: {
                        return new Factory(colony, EnumTypeFactory.MEDIUM, simulate);
                    }
                    case 15: {
                        return new Factory(colony, EnumTypeFactory.HIGH, simulate);
                    }
                }
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 7: {
                        return new ItemFactory(colony, EnumMiningFactory.LOW, simulate);
                    }
                    case 8: {
                        return new ItemFactory(colony, EnumMiningFactory.MEDIUM, simulate);
                    }
                    case 9: {
                        return new ItemFactory(colony, EnumMiningFactory.HIGH, simulate);
                    }
                }
                switch (((ISubEnum)this.getElement()).getId()) {
                    case 10: {
                        return new FluidFactory(colony, EnumMiningFactory.LOW, simulate);
                    }
                    case 11: {
                        return new FluidFactory(colony, EnumMiningFactory.MEDIUM, simulate);
                    }
                    case 12: {
                        return new FluidFactory(colony, EnumMiningFactory.HIGH, simulate);
                    }
                }
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IColonyBuilding building = this.getBuilding(null, stack, true);
        if (building != null) {
            IColonyBuilding buildingHouse;
            if (building instanceof IBuildingHouse) {
                buildingHouse = (IBuildingHouse)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses").m_130946_(" " + buildingHouse.getMaxPeople()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_oxygen").m_130946_(" " + (int)((double)buildingHouse.getMaxPeople() * buildingHouse.getHouses().getConsumeOxygen())));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_food").m_130946_(" " + buildingHouse.getMaxPeople()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + buildingHouse.getHouses().getEnergy()));
            }
            if (building instanceof IFactory) {
                buildingHouse = (IFactory)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + buildingHouse.needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.generate_food").m_130946_(" " + buildingHouse.needWorkers() * 2));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + buildingHouse.getEnergy()));
            }
            if (building instanceof ColonyPanelFactory) {
                buildingHouse = (ColonyPanelFactory)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + ((ColonyPanelFactory)buildingHouse).needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.generate_energy").m_130946_(" " + ((ColonyPanelFactory)buildingHouse).getEnergy()));
            }
            if (building instanceof OxygenFactory) {
                buildingHouse = (OxygenFactory)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + ((OxygenFactory)buildingHouse).needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + ((OxygenFactory)buildingHouse).getEnergy()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.generate_oxygen").m_130946_(" " + ((OxygenFactory)buildingHouse).getGeneration()));
            }
            if (building instanceof ProtectionBuilding) {
                buildingHouse = (ProtectionBuilding)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + ((ProtectionBuilding)buildingHouse).needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.protection").m_130946_(" " + ((ProtectionBuilding)buildingHouse).getProtectionBuilding().getProtection()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + ((ProtectionBuilding)buildingHouse).getProtectionBuilding().getEnergy()));
            }
            if (building instanceof ItemFactory) {
                buildingHouse = (ItemFactory)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + ((ItemFactory)buildingHouse).needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + ((ItemFactory)buildingHouse).getEnergy()));
            }
            if (building instanceof FluidFactory) {
                buildingHouse = (FluidFactory)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + ((FluidFactory)buildingHouse).needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + ((FluidFactory)buildingHouse).getEnergy()));
            }
            if (building instanceof StorageBuilding) {
                buildingHouse = (StorageBuilding)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + ((StorageBuilding)buildingHouse).needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + ((StorageBuilding)buildingHouse).getEnergy()));
            }
            if (building instanceof ColonyEntertainment) {
                buildingHouse = (ColonyEntertainment)building;
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.need_workers").m_130946_(" " + ((ColonyEntertainment)buildingHouse).needWorkers()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.houses_energy").m_130946_(" " + ((ColonyEntertainment)buildingHouse).getType().getEnergy()));
                tooltip.add((Component)Component.m_237115_((String)"iu.colony_building.entertainment").m_130946_(" " + ((ColonyEntertainment)buildingHouse).getType().getEntertainment()));
            }
            tooltip.add((Component)Component.m_237115_((String)"iu.colonial_building.info").m_130946_(" " + building.getMinLevelColony()));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static enum Types implements ISubEnum
    {
        low_protection(0),
        medium_protection(1),
        high_protection(2),
        very_high_protection(3),
        low_house(4),
        medium_house(5),
        high_house(6),
        low_mining_factory(7),
        medium_mining_factory(8),
        high_mining_factory(9),
        low_fluid_mining_factory(10),
        medium_fluid_mining_factory(11),
        high_fluid_mining_factory(12),
        low_factory(13),
        medium_factory(14),
        high_factory(15),
        low_panel(16),
        medium_panel(17),
        high_panel(18),
        oxygen(19),
        storage(20),
        low_entertainment(21),
        medium_entertainment(22),
        high_entertainment(23),
        medium_oxygen(24),
        high_oxygen(25);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int id) {
            this.ID = id;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "colonial_building";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

