/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.vein.Vein;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EncodedType;
import com.denfop.tiles.base.DataOre;
import com.denfop.utils.ModUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.math.Vector3d;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DecoderHandler {
    private static final Map<Class<?>, EncodedType> classToTypeCache = Collections.synchronizedMap(new IdentityHashMap());

    public static Object decode(CustomPacketBuffer is) throws IOException {
        try {
            return DecoderHandler.decode(is, DecoderHandler.typeFromId(is.readUnsignedByte()));
        }
        catch (IllegalArgumentException var3) {
            return null;
        }
    }

    public static <T> T decode(CustomPacketBuffer is, Class<T> clazz) throws IOException {
        EncodedType type = DecoderHandler.typeFromClass(clazz);
        if (type.threadSafe) {
            return (T)DecoderHandler.decode(is, type);
        }
        throw new IllegalArgumentException("requesting decode for non thread safe type");
    }

    public static Object decodeDeferred(CustomPacketBuffer is, Class<?> clazz) throws IOException {
        EncodedType type = DecoderHandler.typeFromClass(clazz);
        return DecoderHandler.decode(is, type);
    }

    private static EncodedType typeFromId(int id) {
        if (id >= 0 && id < EncodedType.types.length) {
            return EncodedType.types[id];
        }
        throw new IllegalArgumentException("invalid type id: " + id);
    }

    private static Class<?> box(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz == Character.TYPE ? Character.class : clazz;
    }

    private static Class<?> unbox(Class<?> clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return clazz == Character.class ? Character.TYPE : clazz;
    }

    private static EncodedType typeFromClass(Class<?> cls) {
        EncodedType[] var3;
        EncodedType ret;
        if (cls == null) {
            return EncodedType.Null;
        }
        if (cls.isArray()) {
            return EncodedType.Array;
        }
        if (cls.isPrimitive()) {
            cls = DecoderHandler.box(cls);
        }
        if ((ret = EncodedType.classToTypeMap.get(cls)) != null) {
            return ret;
        }
        ret = classToTypeCache.get(cls);
        if (ret != null) {
            return ret;
        }
        for (EncodedType type : var3 = EncodedType.types) {
            if (type.cls == null || !type.cls.isAssignableFrom(cls)) continue;
            classToTypeCache.put(cls, type);
            return type;
        }
        throw new IllegalStateException("unmatched " + cls);
    }

    private static Class<?> getClass(String type) {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException var2) {
            throw new RuntimeException("Missing type from the class path expected by network: " + type, var2);
        }
    }

    public static Block getBlock(ResourceLocation loc) {
        Block ret = (Block)Registry.f_122824_.m_7745_(loc);
        if (ret != Blocks.f_50016_) {
            return ret;
        }
        return loc.m_135827_().equals("minecraft") && loc.m_135815_().equals("air") ? ret : null;
    }

    public static Object decode(CustomPacketBuffer is, EncodedType type) throws IOException {
        switch (type) {
            case Array: {
                Class<?> component;
                EncodedType componentType = DecoderHandler.typeFromId(is.readUnsignedByte());
                boolean primitive = is.readBoolean();
                boolean isEnum = componentType == EncodedType.Enum;
                Class<?> clazz = component = primitive ? DecoderHandler.unbox(componentType.cls) : componentType.cls;
                if (component == null || isEnum) {
                    assert (isEnum);
                    component = DecoderHandler.getClass(is.readString());
                }
                Class<?> componentClass = component;
                int len = is.m_130242_();
                boolean anyTypeMismatch = is.readBoolean();
                boolean needsResolving = !componentType.threadSafe;
                Object array = new Object[len];
                array = !needsResolving ? Array.newInstance(component, len) : new Object[len];
                if (!anyTypeMismatch) {
                    if (isEnum) {
                        ?[] constants = component.getEnumConstants();
                        assert (constants != null);
                        for (int k = 0; k < len; ++k) {
                            Array.set(array, k, constants[(Integer)DecoderHandler.decode(is, componentType)]);
                        }
                    } else {
                        for (i = 0; i < len; ++i) {
                            Array.set(array, i, DecoderHandler.decode(is, componentType));
                        }
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        EncodedType cType = DecoderHandler.typeFromId(is.readUnsignedByte());
                        if (!cType.threadSafe && !needsResolving) {
                            needsResolving = true;
                            if (componentClass != Object.class) {
                                Object[] newArray = new Object[len];
                                System.arraycopy(array, 0, newArray, 0, i);
                                array = newArray;
                            }
                        }
                        Array.set(array, i, DecoderHandler.decode(is, cType));
                    }
                }
                if (!needsResolving) {
                    return array;
                }
                Object finalArray = array;
                Object ret_array = Array.newInstance(componentClass, len);
                for (int i1 = 0; i1 < len; ++i1) {
                    Array.set(ret_array, i1, DecoderHandler.getValue(Array.get(finalArray, i1)));
                }
                return ret_array;
            }
            case Block: {
                return DecoderHandler.getBlock((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case network_object: {
                return is;
            }
            case BlockPos: {
                return new BlockPos(is.readInt(), is.readInt(), is.readInt());
            }
            case Boolean: {
                return is.readBoolean();
            }
            case Byte: {
                return is.readByte();
            }
            case Character: {
                return Character.valueOf(is.readChar());
            }
            case ChunkPos: {
                return new ChunkPos(is.readInt(), is.readInt());
            }
            case Collection: {
                Object ret = DecoderHandler.decode(is, EncodedType.Array);
                return Arrays.asList((Object[])ret);
            }
            case Component: {
                return is;
            }
            case Double: {
                return is.readDouble();
            }
            case Enchantment: {
                return Registry.f_122825_.m_7745_((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case Enum: {
                return is.m_130242_();
            }
            case Float: {
                return Float.valueOf(is.readFloat());
            }
            case Fluid: {
                return Registry.f_122822_.m_7745_((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case FluidStack: {
                FluidStack ret2 = new FluidStack((Fluid)DecoderHandler.decode(is, EncodedType.Fluid), is.readInt());
                if (!ret2.isEmpty()) {
                    ret2.setTag((CompoundTag)DecoderHandler.decode(is));
                }
                return ret2;
            }
            case FluidTank: {
                FluidStack fluidStack = (FluidStack)DecoderHandler.decode(is);
                FluidTank fluidTank = new FluidTank(is.readInt());
                fluidTank.setFluid(fluidStack);
                return fluidTank;
            }
            case GameProfile: {
                return new GameProfile((UUID)DecoderHandler.decode(is), is.readString());
            }
            case Integer: {
                return is.readInt();
            }
            case InvSlot: {
                ItemStack[] contents = (ItemStack[])DecoderHandler.decode(is, EncodedType.Array);
                InvSlot ret3 = new InvSlot(contents.length);
                for (int i = 0; i < contents.length; ++i) {
                    ret3.set(i, contents[i]);
                }
                return ret3;
            }
            case Item: {
                return Registry.f_122827_.m_7745_((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case ItemStack: {
                byte size = is.readByte();
                if (size == 0) {
                    return ModUtils.emptyStack;
                }
                Item item = DecoderHandler.decode(is, Item.class);
                CompoundTag nbt = (CompoundTag)DecoderHandler.decode(is);
                ItemStack ret1 = new ItemStack((ItemLike)item, (int)size);
                ret1.m_41751_(nbt);
                return ret1;
            }
            case Long: {
                return is.readLong();
            }
            case NBTTagCompound: {
                return NbtIo.m_128934_((DataInput)new ByteBufInputStream((ByteBuf)is), (NbtAccounter)NbtAccounter.f_128917_);
            }
            case Null: {
                return null;
            }
            case Object: {
                return new Object();
            }
            case Potion: {
                return Registry.f_122828_.m_7745_((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case ResourceLocation: {
                return new ResourceLocation(is.readString(), is.readString());
            }
            case Short: {
                return is.readShort();
            }
            case String: {
                return is.readString();
            }
            case TileEntity: {
                Level deferredWorld = (Level)DecoderHandler.decode(is, EncodedType.World);
                BlockPos pos = (BlockPos)DecoderHandler.decode(is, EncodedType.BlockPos);
                return deferredWorld.m_46745_(pos).m_7702_(pos);
            }
            case UUID: {
                return new UUID(is.readLong(), is.readLong());
            }
            case Vec3: {
                return new Vector3d(is.readDouble(), is.readDouble(), is.readDouble());
            }
            case DataOre: {
                return new DataOre(is);
            }
            case Vein: {
                return new Vein(is);
            }
            case RecipeInfo: {
                return new RecipeInfo(is);
            }
            case Radiation: {
                return new Radiation(is);
            }
            case World: {
                return IUCore.proxy.getWorld((ResourceKey<Level>)is.m_236801_(Registry.f_122819_));
            }
        }
        throw new IllegalArgumentException("unhandled type: " + type);
    }

    public static <T> T getValue(Object decoded) {
        return (T)decoded;
    }
}

